/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds.util;

import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.util.geo.Geo2D;
import cib.util.view.Projection2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;

public class CircleRubberBand
implements GeometryPanel.RubberbandListener {
    private UserInterface m_ui = null;
    private Ellipse2D m_ellipse = new Ellipse2D.Double();
    private Map<JPanel, Graphics2D> m_panelToGfx = new HashMap<JPanel, Graphics2D>();

    public CircleRubberBand(Kernel krnl, Point2D ctr) {
        this.m_ui = krnl.getUserInterface();
        this.m_ellipse.setFrameFromCenter(ctr, ctr);
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            JPanel panel = (JPanel)((Object)gp);
            Graphics2D gfx = (Graphics2D)panel.getGraphics();
            gfx.setXORMode(panel.getBackground());
            gfx.setColor(panel.getForeground());
            this.m_panelToGfx.put(panel, gfx);
            gp.addListener(this);
        }
    }

    @Override
    public void reset() {
        this.m_ellipse.setFrameFromCenter(this.m_ellipse.getCenterX(), this.m_ellipse.getCenterY(), this.m_ellipse.getCenterX(), this.m_ellipse.getCenterY());
    }

    @Override
    public void paintStarts() {
        this._draw();
        this.m_ellipse.setFrameFromCenter(this.m_ellipse.getCenterX(), this.m_ellipse.getCenterY(), this.m_ellipse.getCenterX(), this.m_ellipse.getCenterY());
    }

    @Override
    public void paintEnds() {
        this.m_ellipse.setFrameFromCenter(this.m_ellipse.getCenterX(), this.m_ellipse.getCenterY(), this.m_ellipse.getCenterX(), this.m_ellipse.getCenterY());
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            JPanel panel = (JPanel)((Object)gp);
            Point p = panel.getMousePosition();
            if (p == null) continue;
            Point2D.Double pin = new Point2D.Double();
            Point2D.Double pout = new Point2D.Double();
            Projection2D prj2D = gp.getProjection();
            ((Point2D)pin).setLocation(((Point2D)p).getX(), ((Point2D)p).getY());
            prj2D.getViewToModel().transform(pin, pout);
            double ctrX = this.m_ellipse.getCenterX();
            double ctrY = this.m_ellipse.getCenterY();
            double r = pout.distance(ctrX, ctrY);
            this.m_ellipse.setFrameFromCenter(ctrX, ctrY, ctrX + r, ctrY + r);
            break;
        }
        this._draw();
    }

    public void close() {
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            gp.removeListener(this);
            JPanel panel = (JPanel)((Object)gp);
            Graphics gfx = this.m_panelToGfx.get(panel);
            gfx.dispose();
        }
    }

    private void _draw() {
        if (this.m_ellipse.getWidth() >= Geo2D.getEps()) {
            Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
            while (it.hasNext()) {
                GeometryPanel panel = it.next();
                Graphics2D gfx = this.m_panelToGfx.get(panel);
                if (gfx == null) {
                    throw new InternalError("CircleRubberBand: gfx == null");
                }
                Projection2D prj2D = panel.getProjection();
                AffineTransform m2v = prj2D.getModelToView();
                gfx.draw(m2v.createTransformedShape(this.m_ellipse));
            }
        }
    }
}

