/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.constr;

import cib.cad.db.comp.Component;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.constr.ConObject;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.kernel.constr.Construction;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Geo2D;
import cib.util.geo.Vector2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

public class ConLineSeg2D
extends ConObject {
    private static final String PROPERTY_ORTHOGONAL_MODE = "OrthogonalMode";
    private Line2D m_defLine = null;
    private transient Object m_input = null;

    public ConLineSeg2D(Kernel krnl) {
        super(krnl);
        this._init();
    }

    protected ConLineSeg2D(ConObject con) {
        super(con);
        this._init();
    }

    private void _init() {
        this.setPrompt(Messages.getString("kernel.constr.ConLineSeg2D.0"));
    }

    public void setDefault(Line2D lin) {
        this.m_defLine = lin == null ? null : (Line2D)lin.clone();
    }

    public Line2D getDefault() {
        return this.m_defLine == null ? null : (Line2D)this.m_defLine.clone();
    }

    public static boolean isOrthogonalMode() {
        try {
            Kernel krnl = Kernel.getInstance();
            return 1 == Integer.parseInt(krnl.getProperty(PROPERTY_ORTHOGONAL_MODE));
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void setOrthogonalMode(boolean on) {
        Kernel krnl = Kernel.getInstance();
        krnl.setProperty(PROPERTY_ORTHOGONAL_MODE, on ? "1" : "0");
    }

    @Override
    public void show() {
        this.showConLineSegDialog();
    }

    @Override
    public void dispose() {
        this._setPickCursor(false);
        this._getUI().disposeCmdLineDialog();
    }

    @Override
    public void setDigitizeCursor(boolean on) {
        ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        conPoint.setDigitizeCursor(on);
    }

    private void showConLineSegDialog() {
        block5: while (true) {
            CmdLineDialog dlg = this._getUI().getCmdLineDialog();
            dlg.setUniqueName("kernel.constr.ConLineSeg2D-menu0");
            final ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
            conPoint.setFilter(this.m_filter);
            dlg.setPrompt(String.valueOf(this.getPrompt()) + (ConPoint2D.getRelCoordFlag() ? Messages.getString("kernel.constr.ConLineSeg2D.2") : ""));
            dlg.enableTextInput(true);
            if (this.m_defLine != null) {
                dlg.setDefaultText(String.valueOf(Geo2D.formatCoordinate(this.m_defLine.getX1())) + " " + Geo2D.formatCoordinate(this.m_defLine.getY1()));
            }
            dlg.enableDigitize(-1);
            dlg.addChoice("Pick");
            dlg.addChoice("Start point");
            dlg.setChoiceChecked(1, true);
            dlg.addChoice("Circle tangent");
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    ConLineSeg2D.this.m_input = new Integer(iChoice);
                    ConLineSeg2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    ConLineSeg2D.this.m_input = new CmdAbortedException();
                    ConLineSeg2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void digitized(int x, int y, GeometryPanel gp) {
                    ConLineSeg2D.this.m_input = new DigitizeToken(x, y, gp.getId());
                    ConLineSeg2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void textEntered(String text) {
                    ConLineSeg2D.this.m_input = new TextToken(text);
                    ConLineSeg2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void interruptStarts(String argList) {
                    conPoint.setDigitizeCursor(false);
                    conPoint.showRelativeCoordinatesAid(false);
                }

                @Override
                public void interruptEnds() {
                    conPoint.setDigitizeCursor(true);
                    conPoint.showRelativeCoordinatesAid(true);
                }
            });
            conPoint.setDigitizeCursor(true);
            conPoint.showRelativeCoordinatesAid(true);
            this._getUI().showCmdLineDialog(dlg);
            conPoint.setDigitizeCursor(false);
            conPoint.showRelativeCoordinatesAid(false);
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case 0: {
                        if (!this.showPickLineSegDialog()) continue block5;
                        return;
                    }
                    case 1: {
                        this.showStartPointDialog();
                        return;
                    }
                    case 2: {
                        this.show2CirclesDialog();
                        return;
                    }
                }
                System.err.println(Messages.getString("kernel.constr.ConLineSeg2D.10"));
                continue;
            }
            if (this.m_input instanceof CmdAbortedException) {
                this.notifyAborted();
                return;
            }
            if (this.m_input instanceof DigitizeToken) {
                this.m_krnl.pushBackArguments(new CmdLineToken[]{(DigitizeToken)this.m_input});
                this.showStartPointDialog();
                return;
            }
            if (this.m_input instanceof TextToken) break;
        }
        this.m_krnl.pushBackArguments(new CmdLineToken[]{(TextToken)this.m_input});
        this.showStartPointDialog();
    }

    private boolean showPickLineSegDialog() {
        CmdLineDialog dlg = this._getUI().getCmdLineDialog();
        dlg.setUniqueName("kernel.constr.ConLineSeg2D-menu1");
        dlg.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConLineSeg2D.12"));
        dlg.enableDigitize(-1);
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void dialogAborted() {
                ConLineSeg2D.this.m_input = new CmdAbortedException();
                ConLineSeg2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                ConLineSeg2D.this.m_input = new DigitizeObject(gp, x, y);
                ConLineSeg2D.this._getUI().disposeCmdLineDialog();
            }
        });
        this._setPickCursor(true);
        this._getUI().showCmdLineDialog(dlg);
        this._setPickCursor(false);
        if (this.m_input instanceof CmdAbortedException) {
            this.notifyAborted();
            return true;
        }
        if (this.m_input instanceof DigitizeObject) {
            DigitizeObject dig = (DigitizeObject)this.m_input;
            Rectangle2D.Double pickBox = new Rectangle2D.Double(dig.getX() - 5, dig.getY() - 5, 10.0, 10.0);
            GeometryPanel gp = dig.getGeometryPanel();
            double[] crds = new double[8];
            Iterator<Component> it = gp.objectIterator(pickBox, true);
            while (it.hasNext()) {
                Component o = it.next();
                if (!this._accepts(o, -1, -1)) continue;
                GeometryPanel.SegmentIterator git = gp.intersectionSegmentIterator(o, pickBox);
                while (git.hasNext()) {
                    if (git.next(crds) != 8) continue;
                    this.notifyLineSegConstructed(new Line2D.Double(crds[0], crds[1], crds[2], crds[3]), true);
                    return true;
                }
            }
            System.err.println(Messages.getString("kernel.constr.ConLineSeg2D.13"));
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void showStartPointDialog() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 34[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void show2CirclesDialog() {
        try {
            int nTangents = 0;
            do {
                Ellipse2D.Double ell1 = new Ellipse2D.Double();
                Construction.getConstruction(this.m_krnl).circle2D(Messages.getString("kernel.constr.ConLineSeg2D.32"), ell1, null, this.m_filter);
                Ellipse2D.Double ell2 = new Ellipse2D.Double();
                Construction.getConstruction(this.m_krnl).circle2D(Messages.getString("kernel.constr.ConLineSeg2D.33"), ell2, null, this.m_filter);
                Line2D[] tangents = new Line2D[4];
                nTangents = Geo2D.calculateTangentLines(ell1, (Ellipse2D)ell2, tangents);
                if (nTangents != 0) {
                    int i = 0;
                    while (i < nTangents) {
                        if (Geo2D.isNull(tangents[i])) {
                            Point2D.Double ctr = ((RectangularShape)ell1).getWidth() > ((RectangularShape)ell2).getWidth() ? new Point2D.Double(ell1.getCenterX(), ell1.getCenterY()) : new Point2D.Double(ell2.getCenterX(), ell2.getCenterY());
                            tangents[i] = this.extendDegeneratedTangent(ctr, tangents[i].getP1());
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < nTangents) {
                        this._getUI().draw(tangents[i]);
                        ++i;
                    }
                    if (nTangents == 1) {
                        this.notifyLineSegConstructed(tangents[0], true);
                        return;
                    }
                    while (true) {
                        DigitizeObject dig = this.m_krnl.readDigitizeObject(String.valueOf(Messages.getString("kernel.constr.ConLineSeg2D.35")) + nTangents + Messages.getString("kernel.constr.ConLineSeg2D.36"), Construction.getPickNearCursor());
                        GeometryPanel panel = dig.getGeometryPanel();
                        Point2D.Double pickPnt = new Point2D.Double(dig.getX(), dig.getY());
                        AffineTransform m2v = panel.getProjection().getModelToView();
                        Rectangle rectangle = new Rectangle();
                        rectangle.setFrameFromDiagonal(((Point2D)pickPnt).getX() - 5.0, ((Point2D)pickPnt).getY() - 5.0, ((Point2D)pickPnt).getX() + 5.0, ((Point2D)pickPnt).getY() + 5.0);
                        int i2 = 0;
                        while (i2 < nTangents) {
                            Shape shp = m2v.createTransformedShape(tangents[i2]);
                            if (shp.intersects(rectangle)) {
                                int j = 0;
                                while (j < nTangents) {
                                    this._getUI().undraw(tangents[j]);
                                    ++j;
                                }
                                this.notifyLineSegConstructed(tangents[i2], true);
                                return;
                            }
                            ++i2;
                        }
                        System.err.println(Messages.getString("kernel.constr.ConLineSeg2D.37"));
                    }
                }
                System.err.println(Messages.getString("kernel.constr.ConLineSeg2D.34"));
            } while (nTangents == 0);
        }
        catch (CmdAbortedException e) {
            this.notifyAborted();
        }
    }

    private void notifyLineSegConstructed(Line2D lineSeg, boolean ignoreOrthoMode) {
        if (!ignoreOrthoMode && ConLineSeg2D.isOrthogonalMode()) {
            double dy;
            double dx = Math.abs(lineSeg.getX2() - lineSeg.getX1());
            if (dx < (dy = Math.abs(lineSeg.getY2() - lineSeg.getY1()))) {
                lineSeg.setLine(lineSeg.getX1(), lineSeg.getY1(), lineSeg.getX1(), lineSeg.getY2());
            } else {
                lineSeg.setLine(lineSeg.getX1(), lineSeg.getY1(), lineSeg.getX2(), lineSeg.getY1());
            }
        }
        if (this.isDrawEnabled()) {
            this._getUI().draw(lineSeg);
        }
        Iterator<ConObject.Listener> it = this.listenerIterator();
        while (it.hasNext()) {
            Listener l = (Listener)it.next();
            l.lineSegConstructed(lineSeg);
        }
    }

    private Line2D extendDegeneratedTangent(Point2D ctr, Point2D circlePoint) {
        Vector2D radial = new Vector2D(ctr, circlePoint);
        radial.left();
        radial.add(circlePoint);
        return new Line2D.Double(circlePoint, radial);
    }

    @Override
    protected void notifyAborted() {
        super.notifyAborted();
    }

    public static class Adapter
    implements Listener {
        @Override
        public void dialogAborted() {
        }

        @Override
        public void lineSegConstructed(Line2D seg) {
        }
    }

    public static interface Listener
    extends ConObject.Listener {
        public void lineSegConstructed(Line2D var1);
    }
}

