/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.cad.db.Database;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.InputDeviceAdapter;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.WindowToken;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.coll.ObservableSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.URL;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;

public class Desktop
extends JComponent {
    private static final long serialVersionUID = 0L;
    public static final int WINDOW_CAPTION_HEIGHT = 22;
    private static final String PROP_LAYOUT = "Desktop.layout";
    public static final int LAYOUT_1_PANEL = 1;
    public static final int LAYOUT_2_PANELS_VERTICAL = 2;
    public static final int LAYOUT_2_PANELS_HORIZONTAL = 3;
    public static final int LAYOUT_3_PANELS = 4;
    public static final int LAYOUT_4_PANELS = 5;
    private final Color BORDER_COLOR = Color.BLACK;
    private _Layout m_layout = null;
    private int m_layoutPattern = 0;
    private JPanel[] m_iFrames = null;
    private Kernel m_krnl;
    private static Color BACKGROUND;
    private InputDeviceAdapter m_inputDevice = null;

    static {
        String javaVMVendor;
        BACKGROUND = UIManager.getColor("window");
        String os = System.getProperty("os.name");
        if (os.startsWith("Linux")) {
            String desktop = System.getProperty("sun.desktop");
            if (desktop != null && desktop.startsWith("gnome")) {
                BACKGROUND = Color.WHITE;
            }
        } else if (os.equals("Mac OS X") && (javaVMVendor = System.getProperty("java.vm.vendor")) != null && javaVMVendor.equals("Oracle Corporation")) {
            BACKGROUND = Color.WHITE;
        }
    }

    protected Desktop() {
    }

    public Desktop(Kernel krnl) {
        this.m_krnl = krnl;
        this.setDoubleBuffered(true);
        int layout = 1;
        String prop = this.m_krnl.getProperty(PROP_LAYOUT, "1");
        try {
            layout = Integer.parseInt(prop);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setLayoutPattern(layout);
    }

    public void setLayoutPattern(int layout) {
        if (this.m_layout != null) {
            this.m_layout._remove();
        }
        switch (layout) {
            case 2: {
                this.m_layout = new _Layout2Vertical();
                break;
            }
            case 3: {
                this.m_layout = new _Layout2Horizontal();
                break;
            }
            case 4: {
                this.m_layout = new _Layout3();
                break;
            }
            case 5: {
                this.m_layout = new _Layout4();
                break;
            }
            default: {
                this.m_layout = new _Layout1();
            }
        }
        this.m_layoutPattern = layout;
        this.m_krnl.setProperty(PROP_LAYOUT, String.valueOf(layout));
    }

    public int getLayoutPattern() {
        return this.m_layoutPattern;
    }

    public Iterator<GeometryPanel> panelIterator() {
        return new _PanelIterator();
    }

    private JComponent getWindow(int winID, final DrawPanel drawPanel) {
        URL url = Desktop.class.getClassLoader().getResource("cib/cad/img/more2.gif");
        ImageIcon icon = new ImageIcon(url);
        JPanel panel = new JPanel(new BorderLayout());
        final JButton button = new JButton(Messages.getString("view.Desktop.0"), icon);
        button.setToolTipText(String.valueOf(Messages.getString("view.Desktop.1")) + winID);
        button.putClientProperty("JButton.buttonType", "toolbar");
        button.setFocusable(false);
        button.setHorizontalTextPosition(2);
        button.setBorderPainted(false);
        final JPopupMenu m = new JPopupMenu();
        JMenuItem itemWindowFit = new JMenuItem(Messages.getString("view.Desktop.15"));
        itemWindowFit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinFit " + drawPanel.getId());
            }
        });
        m.add(itemWindowFit);
        JMenuItem itemWindowZoom = new JMenuItem(Messages.getString("view.Desktop.17"));
        itemWindowZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Kernel.Listener l = new Kernel.Listener(){
                    int m_i = 0;

                    @Override
                    public void tokenConsumed(CmdLineToken token) {
                        if (++this.m_i == 2) {
                            Desktop.this.m_krnl.addArgument(new WindowToken(drawPanel.getId()));
                        }
                    }

                    @Override
                    public void cmdEnds(String cmdName) {
                        Desktop.this.m_krnl.removeListener(this);
                    }
                };
                Desktop.this.m_krnl.addListener(l);
                Desktop.this._fireInput("WinZoom");
            }
        });
        m.add(itemWindowZoom);
        JMenu menuWindowScale = new JMenu(Messages.getString("view.Desktop.19"));
        JMenuItem itemWindowZoomOut = new JMenuItem(Messages.getString("view.Desktop.20"));
        itemWindowZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinScale 2 " + drawPanel.getId());
            }
        });
        menuWindowScale.add(itemWindowZoomOut);
        JMenuItem itemWindowZoomIn = new JMenuItem(Messages.getString("view.Desktop.22"));
        itemWindowZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinScale 0.5 " + drawPanel.getId());
            }
        });
        menuWindowScale.add(itemWindowZoomIn);
        m.add(menuWindowScale);
        JMenu menuWindowMove = new JMenu(Messages.getString("view.Desktop.24"));
        JMenuItem itemWindowRight = new JMenuItem(Messages.getString("view.Desktop.25"));
        itemWindowRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinMove 0.5 0 " + drawPanel.getId());
            }
        });
        menuWindowMove.add(itemWindowRight);
        JMenuItem itemWindowLeft = new JMenuItem(Messages.getString("view.Desktop.27"));
        itemWindowLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinMove -0.5 0 " + drawPanel.getId());
            }
        });
        menuWindowMove.add(itemWindowLeft);
        JMenuItem itemWindowUp = new JMenuItem(Messages.getString("view.Desktop.29"));
        itemWindowUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinMove 0 0.5 " + drawPanel.getId());
            }
        });
        menuWindowMove.add(itemWindowUp);
        JMenuItem itemWindowDown = new JMenuItem(Messages.getString("view.Desktop.31"));
        itemWindowDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinMove 0 -0.5 " + drawPanel.getId());
            }
        });
        menuWindowMove.add(itemWindowDown);
        m.add(menuWindowMove);
        final JMenu menuPosition = new JMenu(Messages.getString("view.Desktop.33"));
        final JMenuItem itemPosBack = new JMenuItem(Messages.getString("view.Desktop.34"));
        itemPosBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("posBack");
            }
        });
        menuPosition.add(itemPosBack);
        final JMenuItem itemPosBackward = new JMenuItem(Messages.getString("view.Desktop.36"));
        itemPosBackward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("posBackward");
            }
        });
        menuPosition.add(itemPosBackward);
        final JMenuItem itemPosSwap = new JMenuItem(Messages.getString("view.Desktop.38"));
        itemPosSwap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("posSwap");
            }
        });
        menuPosition.add(itemPosSwap);
        final JMenuItem itemPosForward = new JMenuItem(Messages.getString("view.Desktop.40"));
        itemPosForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("posForward");
            }
        });
        menuPosition.add(itemPosForward);
        final JMenuItem itemPosFront = new JMenuItem(Messages.getString("view.Desktop.42"));
        itemPosFront.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("posFront");
            }
        });
        menuPosition.add(itemPosFront);
        m.add(menuPosition);
        JMenuItem itemRectangularGrid = new JMenuItem(Messages.getString("view.Desktop.44"));
        itemRectangularGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("SetRectangularGrid " + drawPanel.getId());
            }
        });
        m.add(itemRectangularGrid);
        final JMenu menuWindowLayout = new JMenu(Messages.getString("view.Desktop.46"));
        JMenuItem itemSetWindowLayout1 = new JMenuItem(Messages.getString("view.Desktop.47"));
        itemSetWindowLayout1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("SetLayout #menu(1)");
            }
        });
        menuWindowLayout.add(itemSetWindowLayout1);
        JMenuItem itemSetWindowLayout2V = new JMenuItem(Messages.getString("view.Desktop.49"));
        itemSetWindowLayout2V.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("SetLayout #menu(2V)");
            }
        });
        menuWindowLayout.add(itemSetWindowLayout2V);
        JMenuItem itemSetWindowLayout2H = new JMenuItem(Messages.getString("view.Desktop.51"));
        itemSetWindowLayout2H.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("SetLayout #menu(2H)");
            }
        });
        menuWindowLayout.add(itemSetWindowLayout2H);
        JMenuItem itemSetWindowLayout3 = new JMenuItem(Messages.getString("view.Desktop.53"));
        itemSetWindowLayout3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("SetLayout #menu(3)");
            }
        });
        menuWindowLayout.add(itemSetWindowLayout3);
        JMenuItem itemSetWindowLayout4 = new JMenuItem(Messages.getString("view.Desktop.55"));
        itemSetWindowLayout4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("SetLayout #menu(4)");
            }
        });
        menuWindowLayout.add(itemSetWindowLayout4);
        m.add(menuWindowLayout);
        m.addSeparator();
        JMenu menuWindowFlags = new JMenu(Messages.getString("view.Desktop.57"));
        final JCheckBoxMenuItem itemFlagLineWidth = new JCheckBoxMenuItem(Messages.getString("view.Desktop.58"));
        itemFlagLineWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinFlagsLineWidth " + (itemFlagLineWidth.getState() ? "#menu(Yes)" : "#menu(No)") + drawPanel.getId());
            }
        });
        menuWindowFlags.add(itemFlagLineWidth);
        final JCheckBoxMenuItem itemFlagLinePattern = new JCheckBoxMenuItem(Messages.getString("view.Desktop.62"));
        itemFlagLinePattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinFlagsLinePattern " + (itemFlagLinePattern.getState() ? "#menu(Yes)" : "#menu(No)") + drawPanel.getId());
            }
        });
        menuWindowFlags.add(itemFlagLinePattern);
        JMenu menuWindowFill = new JMenu(Messages.getString("view.Desktop.66"));
        final JRadioButtonMenuItem rbFillOff = new JRadioButtonMenuItem(Messages.getString("view.Desktop.67"));
        final JRadioButtonMenuItem rbFillOn = new JRadioButtonMenuItem(Messages.getString("view.Desktop.68"));
        final JRadioButtonMenuItem rbFillSolid = new JRadioButtonMenuItem(Messages.getString("view.Desktop.69"));
        ButtonGroup group = new ButtonGroup();
        rbFillOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinFlagsFill #menu(No)" + drawPanel.getId());
            }
        });
        group.add(rbFillOff);
        menuWindowFill.add(rbFillOff);
        rbFillOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinFlagsFill #menu(Yes)" + drawPanel.getId());
            }
        });
        group.add(rbFillOn);
        menuWindowFill.add(rbFillOn);
        rbFillSolid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinFlagsFill #menu(Solid)" + drawPanel.getId());
            }
        });
        group.add(rbFillSolid);
        menuWindowFill.add(rbFillSolid);
        menuWindowFlags.add(menuWindowFill);
        final JCheckBoxMenuItem itemFlagFillTransparency = new JCheckBoxMenuItem(Messages.getString("view.Desktop.73"));
        itemFlagFillTransparency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinFlagsFillTransparency " + (itemFlagFillTransparency.getState() ? "#menu(Yes)" : "#menu(No)") + drawPanel.getId());
            }
        });
        menuWindowFlags.add(itemFlagFillTransparency);
        final JCheckBoxMenuItem itemFlagText = new JCheckBoxMenuItem(Messages.getString("view.Desktop.77"));
        itemFlagText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinFlagsText " + (itemFlagText.getState() ? "#menu(Yes)" : "#menu(No)") + drawPanel.getId());
            }
        });
        menuWindowFlags.add(itemFlagText);
        final JCheckBoxMenuItem itemFlagImage = new JCheckBoxMenuItem(Messages.getString("view.Desktop.81"));
        itemFlagImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinFlagsImage " + (itemFlagImage.getState() ? "#menu(Yes)" : "#menu(No)") + drawPanel.getId());
            }
        });
        menuWindowFlags.add(itemFlagImage);
        menuWindowFlags.addSeparator();
        final JCheckBoxMenuItem itemFlagGrid = new JCheckBoxMenuItem(Messages.getString("view.Desktop.85"));
        itemFlagGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinFlagsGrid " + (itemFlagGrid.getState() ? "#menu(Yes)" : "#menu(No)") + drawPanel.getId());
            }
        });
        menuWindowFlags.add(itemFlagGrid);
        final JCheckBoxMenuItem itemFlagConstruction = new JCheckBoxMenuItem(Messages.getString("view.Desktop.89"));
        itemFlagConstruction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinFlagsConstruction " + (itemFlagConstruction.getState() ? "#menu(Yes)" : "#menu(No)") + drawPanel.getId());
            }
        });
        menuWindowFlags.add(itemFlagConstruction);
        final JCheckBoxMenuItem itemFlagGroupContext = new JCheckBoxMenuItem(Messages.getString("view.Desktop.91"));
        itemFlagGroupContext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinFlagsGroupContext " + (itemFlagGroupContext.getState() ? "#menu(Yes)" : "#menu(No)") + drawPanel.getId());
            }
        });
        menuWindowFlags.add(itemFlagGroupContext);
        final JCheckBoxMenuItem itemFlagBestRenderingQuality = new JCheckBoxMenuItem(Messages.getString("view.Desktop.93"));
        itemFlagBestRenderingQuality.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this._fireInput("WinFlagsRender " + (itemFlagBestRenderingQuality.getState() ? "#menu(Yes)" : "#menu(No)") + drawPanel.getId());
            }
        });
        menuWindowFlags.add(itemFlagBestRenderingQuality);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!m.isVisible()) {
                    int flags = drawPanel.getFlags();
                    itemFlagLineWidth.setState((flags & 0x40) != 0);
                    itemFlagLinePattern.setState((flags & 0x20) != 0);
                    rbFillOff.setSelected(true);
                    rbFillOn.setSelected((flags & 8) != 0);
                    rbFillSolid.setSelected((flags & 0x10) != 0);
                    itemFlagFillTransparency.setState((flags & 4) != 0);
                    itemFlagText.setState((flags & 1) != 0);
                    itemFlagImage.setState((flags & 2) != 0);
                    itemFlagGrid.setState((flags & 0x200) != 0);
                    itemFlagConstruction.setState((flags & 0x80) != 0);
                    itemFlagGroupContext.setState((flags & 0x400) == 0);
                    itemFlagBestRenderingQuality.setState((flags & 0x100) != 0);
                    m.show(button, 0, button.getHeight());
                } else {
                    m.setVisible(false);
                }
            }
        });
        m.add(menuWindowFlags);
        this.m_krnl.addListener(new Kernel.Listener(){

            @Override
            public void waitingForCmd() {
                menuWindowLayout.setEnabled(true);
            }

            @Override
            public void cmdStarts(String cmdName) {
                menuWindowLayout.setEnabled(false);
            }

            @Override
            public void cmdEnds(String cmdName) {
                Database db = Desktop.this.m_krnl.getDatabase();
                ObservableSet<cib.cad.db.comp.Component> selSet = db.getSelectSet();
                menuPosition.setEnabled(!selSet.isEmpty());
                itemPosBack.setEnabled(!selSet.isEmpty());
                itemPosBackward.setEnabled(!selSet.isEmpty());
                itemPosSwap.setEnabled(selSet.size() == 2);
                itemPosForward.setEnabled(!selSet.isEmpty());
                itemPosFront.setEnabled(!selSet.isEmpty());
            }
        });
        panel.setPreferredSize(new Dimension(panel.getWidth(), 22));
        panel.add((Component)button, "West");
        return panel;
    }

    public static Color BACKGROUND() {
        return BACKGROUND;
    }

    private DrawPanel _getDrawPanel(int id) {
        DrawPanel drawPanel = new DrawPanel(this.m_krnl, id, true);
        drawPanel.setBackground(BACKGROUND);
        drawPanel.setVisible(true);
        return drawPanel;
    }

    private void _fireInput(String input) {
        if (this.m_inputDevice == null) {
            this.m_inputDevice = new InputDeviceAdapter();
            this.m_krnl.getUserInterface().addInputDevice(this.m_inputDevice);
        }
        if (this.m_inputDevice.isEnabled()) {
            this.m_inputDevice.fireInterruptingInput(String.valueOf(input) + ";setagain " + input);
        }
    }

    protected class _CmdListener
    implements ActionListener {
        private String m_cmd = null;

        public _CmdListener(String cmd) {
            this.m_cmd = cmd;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Desktop.this.m_inputDevice.isEnabled()) {
                Desktop.this.m_inputDevice.fireInput(this.m_cmd);
            }
        }
    }

    private static interface _Layout {
        public void _remove();
    }

    private class _Layout1
    implements _Layout {
        private ComponentListener m_componentListener = null;

        private _Layout1() {
            Desktop.this.m_iFrames = new JPanel[1];
            ((Desktop)Desktop.this).m_iFrames[0] = new JPanel(new BorderLayout());
            Desktop.this.m_iFrames[0].setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Desktop.this.BORDER_COLOR));
            DrawPanel drawPanel = Desktop.this._getDrawPanel(1);
            Desktop.this.m_iFrames[0].add(Desktop.this.getWindow(1, drawPanel), "North", 0);
            Desktop.this.m_iFrames[0].add(drawPanel, "Center", 1);
            Desktop.this.add(Desktop.this.m_iFrames[0]);
            this.m_componentListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    JComponent desktop = (JComponent)e.getComponent();
                    _Layout1.this._setLocationAndSize(desktop);
                }
            };
            Desktop.this.addComponentListener(this.m_componentListener);
            this._setLocationAndSize(Desktop.this);
        }

        @Override
        public void _remove() {
            Desktop.this.removeComponentListener(this.m_componentListener);
            Desktop.this.remove(Desktop.this.m_iFrames[0]);
            Desktop.this.m_iFrames = null;
        }

        private void _setLocationAndSize(JComponent d) {
            int width = d.getWidth();
            int height = d.getHeight();
            Desktop.this.m_iFrames[0].setLocation(0, 0);
            Desktop.this.m_iFrames[0].setSize(width, height);
            Desktop.this.revalidate();
        }
    }

    private class _Layout2Horizontal
    implements _Layout {
        private ComponentListener m_componentListener = null;

        private _Layout2Horizontal() {
            Desktop.this.m_iFrames = new JPanel[2];
            int i = 0;
            while (i < 2) {
                ((Desktop)Desktop.this).m_iFrames[i] = new JPanel(new BorderLayout());
                DrawPanel drawPanel = Desktop.this._getDrawPanel(1 << i);
                Desktop.this.m_iFrames[i].add(Desktop.this.getWindow(1 << i, drawPanel), "North", 0);
                Desktop.this.m_iFrames[i].add(drawPanel, "Center", 1);
                Desktop.this.add(Desktop.this.m_iFrames[i]);
                ++i;
            }
            Desktop.this.m_iFrames[0].setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Desktop.this.BORDER_COLOR));
            Desktop.this.m_iFrames[1].setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Desktop.this.BORDER_COLOR));
            this.m_componentListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    JComponent desktop = (JComponent)e.getComponent();
                    _Layout2Horizontal.this._setLocationAndSize(desktop);
                }
            };
            Desktop.this.addComponentListener(this.m_componentListener);
            this._setLocationAndSize(Desktop.this);
        }

        @Override
        public void _remove() {
            Desktop.this.removeComponentListener(this.m_componentListener);
            Desktop.this.remove(Desktop.this.m_iFrames[1]);
            Desktop.this.remove(Desktop.this.m_iFrames[0]);
            Desktop.this.m_iFrames = null;
        }

        private void _setLocationAndSize(JComponent d) {
            int width = d.getWidth();
            int height = d.getHeight();
            Desktop.this.m_iFrames[0].setLocation(0, 0);
            Desktop.this.m_iFrames[0].setSize(width, height * 1 / 2);
            Desktop.this.m_iFrames[1].setLocation(0, height * 1 / 2);
            Desktop.this.m_iFrames[1].setSize(width, height * 1 / 2);
            Desktop.this.revalidate();
        }
    }

    private class _Layout2Vertical
    implements _Layout {
        private ComponentListener m_componentListener = null;

        private _Layout2Vertical() {
            Desktop.this.m_iFrames = new JPanel[2];
            int i = 0;
            while (i < 2) {
                ((Desktop)Desktop.this).m_iFrames[i] = new JPanel(new BorderLayout());
                DrawPanel drawPanel = Desktop.this._getDrawPanel(1 << i);
                Desktop.this.m_iFrames[i].add(Desktop.this.getWindow(1 << i, drawPanel), "North", 0);
                Desktop.this.m_iFrames[i].add(drawPanel, "Center", 1);
                Desktop.this.add(Desktop.this.m_iFrames[i]);
                ++i;
            }
            Desktop.this.m_iFrames[0].setBorder(BorderFactory.createMatteBorder(1, 0, 0, 1, Desktop.this.BORDER_COLOR));
            Desktop.this.m_iFrames[1].setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Desktop.this.BORDER_COLOR));
            this.m_componentListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    JComponent desktop = (JComponent)e.getComponent();
                    _Layout2Vertical.this._setLocationAndSize(desktop);
                }
            };
            Desktop.this.addComponentListener(this.m_componentListener);
            this._setLocationAndSize(Desktop.this);
        }

        @Override
        public void _remove() {
            Desktop.this.removeComponentListener(this.m_componentListener);
            Desktop.this.remove(Desktop.this.m_iFrames[1]);
            Desktop.this.remove(Desktop.this.m_iFrames[0]);
            Desktop.this.m_iFrames = null;
        }

        public void _setLocationAndSize(JComponent d) {
            int width = d.getWidth();
            int height = d.getHeight();
            Desktop.this.m_iFrames[0].setLocation(0, 0);
            Desktop.this.m_iFrames[0].setSize(width * 1 / 2, height);
            Desktop.this.m_iFrames[1].setLocation(width * 1 / 2, 0);
            Desktop.this.m_iFrames[1].setSize(width * 1 / 2, height);
            Desktop.this.revalidate();
        }
    }

    private class _Layout3
    implements _Layout {
        private ComponentListener m_componentListener = null;

        private _Layout3() {
            Desktop.this.m_iFrames = new JPanel[3];
            int i = 0;
            while (i < 3) {
                ((Desktop)Desktop.this).m_iFrames[i] = new JPanel(new BorderLayout());
                DrawPanel drawPanel = Desktop.this._getDrawPanel(1 << i);
                Desktop.this.m_iFrames[i].add(Desktop.this.getWindow(1 << i, drawPanel), "North", 0);
                Desktop.this.m_iFrames[i].add(drawPanel, "Center", 1);
                Desktop.this.add(Desktop.this.m_iFrames[i]);
                ++i;
            }
            Desktop.this.m_iFrames[0].setBorder(BorderFactory.createMatteBorder(1, 0, 0, 1, Desktop.this.BORDER_COLOR));
            Desktop.this.m_iFrames[1].setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Desktop.this.BORDER_COLOR));
            Desktop.this.m_iFrames[2].setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Desktop.this.BORDER_COLOR));
            this.m_componentListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    JComponent desktop = (JComponent)e.getComponent();
                    _Layout3.this._setLocationAndSize(desktop);
                }
            };
            Desktop.this.addComponentListener(this.m_componentListener);
            this._setLocationAndSize(Desktop.this);
        }

        @Override
        public void _remove() {
            Desktop.this.removeComponentListener(this.m_componentListener);
            Desktop.this.remove(Desktop.this.m_iFrames[2]);
            Desktop.this.remove(Desktop.this.m_iFrames[1]);
            Desktop.this.remove(Desktop.this.m_iFrames[0]);
            Desktop.this.m_iFrames = null;
        }

        private void _setLocationAndSize(JComponent d) {
            int width = d.getWidth();
            int height = d.getHeight();
            Desktop.this.m_iFrames[0].setLocation(0, 0);
            Desktop.this.m_iFrames[0].setSize(width * 3 / 4, height);
            Desktop.this.m_iFrames[1].setLocation(width * 3 / 4, 0);
            Desktop.this.m_iFrames[1].setSize(width - width * 3 / 4, height * 3 / 4);
            Desktop.this.m_iFrames[2].setLocation(width * 3 / 4, height * 3 / 4);
            Desktop.this.m_iFrames[2].setSize(width - width * 3 / 4, height - height * 3 / 4);
            Desktop.this.revalidate();
        }
    }

    private class _Layout4
    implements _Layout {
        private ComponentListener m_componentListener = null;

        private _Layout4() {
            Desktop.this.m_iFrames = new JPanel[4];
            int i = 0;
            while (i < 4) {
                ((Desktop)Desktop.this).m_iFrames[i] = new JPanel(new BorderLayout());
                DrawPanel drawPanel = Desktop.this._getDrawPanel(1 << i);
                Desktop.this.m_iFrames[i].add(Desktop.this.getWindow(1 << i, drawPanel), "North", 0);
                Desktop.this.m_iFrames[i].add(drawPanel, "Center", 1);
                Desktop.this.add(Desktop.this.m_iFrames[i]);
                ++i;
            }
            Desktop.this.m_iFrames[0].setBorder(BorderFactory.createMatteBorder(1, 0, 0, 1, Desktop.this.BORDER_COLOR));
            Desktop.this.m_iFrames[1].setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Desktop.this.BORDER_COLOR));
            Desktop.this.m_iFrames[2].setBorder(BorderFactory.createMatteBorder(1, 0, 0, 1, Desktop.this.BORDER_COLOR));
            Desktop.this.m_iFrames[3].setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Desktop.this.BORDER_COLOR));
            this.m_componentListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    JComponent desktop = (JComponent)e.getComponent();
                    _Layout4.this._setLocationAndSize(desktop);
                }
            };
            Desktop.this.addComponentListener(this.m_componentListener);
            this._setLocationAndSize(Desktop.this);
        }

        @Override
        public void _remove() {
            Desktop.this.removeComponentListener(this.m_componentListener);
            Desktop.this.remove(Desktop.this.m_iFrames[3]);
            Desktop.this.remove(Desktop.this.m_iFrames[2]);
            Desktop.this.remove(Desktop.this.m_iFrames[1]);
            Desktop.this.remove(Desktop.this.m_iFrames[0]);
            Desktop.this.m_iFrames = null;
        }

        private void _setLocationAndSize(JComponent d) {
            int width = d.getWidth();
            int height = d.getHeight();
            Desktop.this.m_iFrames[0].setLocation(0, 0);
            Desktop.this.m_iFrames[0].setSize(width * 1 / 2, height * 1 / 2);
            Desktop.this.m_iFrames[1].setLocation(width * 1 / 2, 0);
            Desktop.this.m_iFrames[1].setSize(width * 1 / 2, height * 1 / 2);
            Desktop.this.m_iFrames[2].setLocation(0, height * 1 / 2);
            Desktop.this.m_iFrames[2].setSize(width * 1 / 2, height * 1 / 2);
            Desktop.this.m_iFrames[3].setLocation(width * 1 / 2, height * 1 / 2);
            Desktop.this.m_iFrames[3].setSize(width * 1 / 2, height * 1 / 2);
            Desktop.this.revalidate();
        }
    }

    private class _PanelIterator
    implements Iterator<GeometryPanel> {
        private int m_i = 0;

        private _PanelIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.m_i < Desktop.this.m_iFrames.length;
        }

        @Override
        public GeometryPanel next() {
            return (GeometryPanel)((Object)Desktop.this.m_iFrames[this.m_i++].getComponent(1));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

