/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.util.view.DeviceRenderer;
import cib.util.view.Projection2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;

public class DrawPrinter
extends DeviceRenderer
implements Printable {
    private static final boolean IS_MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private int m_crossFeedResolution;
    private int m_feedResolution;

    public DrawPrinter(Projection2D projection, double scale, int crossfeed, int feed) {
        super(projection, scale);
        this.m_crossFeedResolution = crossfeed;
        this.m_feedResolution = feed;
    }

    @Override
    public int print(Graphics _g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g = (Graphics2D)_g;
        RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        qualityHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHints(qualityHints);
        double graphics_scale = 72.0 / (double)Math.min(this.m_crossFeedResolution, this.m_feedResolution);
        g.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g.scale(graphics_scale, graphics_scale);
        try {
            Projection2D projection = this.getProjection();
            double scale = (double)Math.min(this.m_crossFeedResolution, this.m_feedResolution) * this.inPerNaturalUnit() / this.getScale();
            Rectangle2D viewPort = projection.getViewPort();
            double deviceWidth = viewPort.getWidth() * scale;
            double deviceHeight = viewPort.getHeight() * scale;
            projection.setDeviceDimensions(deviceWidth, deviceHeight);
            projection.setProjection();
            g.setClip(0, 0, (int)(deviceWidth + 1.0), (int)(deviceHeight + 1.0));
        }
        catch (NoninvertibleTransformException e) {
            System.err.println(e);
            return 1;
        }
        this._render(g);
        return 0;
    }

    @Override
    protected double _getFillOffsetX() {
        return IS_MAC_OS_X ? 4.2 : 0.0;
    }

    @Override
    protected double _getFillOffsetY() {
        return IS_MAC_OS_X ? 4.2 : 0.0;
    }
}

