/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.layer.Layer;
import cib.cad.db.layer.LayerManager;
import cib.cad.db.layer.LayerSet;
import cib.cad.kernel.InputDeviceAdapter;
import cib.cad.kernel.Kernel;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import cib.util.view.ViewUtilities;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class LayerComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;
    final String DEFAULT = "NULL_LAYER";
    private Kernel m_krnl;
    private boolean m_valid = true;
    private InputDeviceAdapter m_inputDevice;

    public LayerComboBox(Kernel krnl, InputDeviceAdapter inputDevice) {
        this.m_krnl = krnl;
        this.m_inputDevice = inputDevice;
        final LayerManager lm = LayerManager.getLayerManager();
        this.setFocusable(false);
        this.setPreferredSize(new Dimension(this._getDefaultWidth(), this.getPreferredSize().height + 2));
        this.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.setRenderer(new ViewUtilities._LabelComboBoxRenderer(false));
        this.setMaximumRowCount(8);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox c = (JComboBox)e.getSource();
                JLabel item = (JLabel)c.getSelectedItem();
                if (item == null) {
                    return;
                }
                if (LayerComboBox.this.m_inputDevice.isEnabled() && SwingUtilities.isEventDispatchThread()) {
                    ObservableSet<Component> selSet = LayerComboBox.this.m_krnl.getDatabase().getSelectSet();
                    if (selSet.isEmpty()) {
                        LayerComboBox.this.m_inputDevice.fireInterruptingInput("setdefaultlayer \"" + item.getText() + "\"");
                    } else {
                        LayerComboBox.this.m_inputDevice.fireInterruptingInput("setlayer \"" + item.getText() + "\"");
                    }
                } else if (LayerComboBox.this.m_valid) {
                    LayerComboBox.this._setDefaultLayer();
                } else {
                    LayerComboBox.this.m_valid = true;
                }
            }
        };
        this.addActionListener(al);
        final LayerSet.Listener lsl = new LayerSet.Listener(){
            private static final long serialVersionUID = 1L;

            @Override
            public void defaultLayerChanged() {
                LayerComboBox.this._setDefaultLayer();
            }

            @Override
            public void wasAdded(Layer layer) {
                String name = lm.getLayerName(layer);
                String semantics = lm.getLocalizedLayerSemantics(name);
                String locName = lm.getLocalizedLayerName(name);
                JLabel l = new JLabel(locName);
                l.setText(locName);
                l.setToolTipText(semantics);
                Collator collator = Collator.getInstance();
                int n = LayerComboBox.this.getItemCount();
                int i = 1;
                while (i < n) {
                    JLabel item = (JLabel)LayerComboBox.this.getItemAt(i);
                    String itemText = item.getText();
                    if (collator.compare(itemText, locName) > 0) {
                        LayerComboBox.this.insertItemAt(l, i);
                        return;
                    }
                    ++i;
                }
                LayerComboBox.this.insertItemAt(l, n);
            }

            @Override
            public void wasRemoved(Layer layer) {
                String name = lm.getLayerName(layer);
                String locName = lm.getLocalizedLayerName(name);
                int i = 0;
                while (i < LayerComboBox.this.getItemCount()) {
                    JLabel l = (JLabel)LayerComboBox.this.getItemAt(i);
                    if (l.getText().equals(locName)) {
                        LayerComboBox.this.removeItemAt(i);
                        break;
                    }
                    ++i;
                }
            }

            @Override
            public void wasChanged(Layer o) {
                LayerComboBox.this._init();
            }
        };
        this.m_krnl.getDatabase().getLayerSet().addListener(lsl);
        this.m_krnl.addListener(new Kernel.Listener(){

            @Override
            public void loadStarts() {
                LayerComboBox.this.m_krnl.getDatabase().getLayerSet().removeListener(lsl);
                LayerComboBox.this.removeAllItems();
            }

            @Override
            public void loadEnds() {
                LayerComboBox.this._init();
                LayerComboBox.this.m_krnl.getDatabase().getLayerSet().addListener(lsl);
            }

            @Override
            public void storeStarts() {
                LayerComboBox.this.m_krnl.getDatabase().getLayerSet().removeListener(lsl);
            }

            @Override
            public void storeEnds() {
                LayerComboBox.this.m_krnl.getDatabase().getLayerSet().addListener(lsl);
            }

            @Override
            public void cmdEnds(String name) {
                boolean status = LayerComboBox.this.m_inputDevice.isEnabled();
                LayerComboBox.this.m_inputDevice.setEnabled(false);
                LayerComboBox.this._update();
                LayerComboBox.this.m_inputDevice.setEnabled(status);
            }
        });
        this._init();
    }

    private void _update() {
        ObservableSet<Component> selSet = this.m_krnl.getDatabase().getSelectSet();
        ReverseAccessMap<Component, Layer> layerMap = this.m_krnl.getDatabase().getLayerMap();
        Iterator iter = selSet.iterator();
        Layer layer = null;
        if (!iter.hasNext()) {
            this._setDefaultLayer();
        } else {
            Component comp = null;
            comp = (Component)iter.next();
            layer = (Layer)layerMap.get(comp);
            while (iter.hasNext()) {
                comp = (Component)iter.next();
                if (layer == null || layer == layerMap.get(comp)) continue;
                layer = null;
                break;
            }
            this.m_valid = false;
            if (layer == null) {
                this.m_inputDevice.setEnabled(false);
                this.setSelectedItem(null);
                this.m_inputDevice.setEnabled(true);
                this.repaint();
            } else {
                LayerManager lm = LayerManager.getLayerManager();
                String name = this.m_krnl.getDatabase().getNameSpace().getName(layer);
                String locName = lm.getLocalizedLayerName(name);
                int i = 0;
                while (i < this.getItemCount()) {
                    JLabel l = (JLabel)this.getItemAt(i);
                    if (l.getText().equals(locName)) {
                        this.m_inputDevice.setEnabled(false);
                        this.setSelectedIndex(i);
                        this.m_inputDevice.setEnabled(true);
                        this.repaint();
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private void _init() {
        LayerManager lm = LayerManager.getLayerManager();
        this.removeAllItems();
        HashMap<String, String> localNamesMap = new HashMap<String, String>();
        HashSet<String> names = new HashSet<String>(lm.getLayers());
        for (String name : names) {
            if (name.equals("NULL_LAYER")) continue;
            localNamesMap.put(lm.getLocalizedLayerName(name), name);
        }
        ArrayList locNames = new ArrayList(localNamesMap.keySet());
        Collections.sort(locNames);
        String locDefault = lm.getLocalizedLayerName("NULL_LAYER");
        locNames.add(0, locDefault);
        localNamesMap.put(locDefault, "NULL_LAYER");
        for (String locName : locNames) {
            String name = (String)localNamesMap.get(locName);
            String semantics = lm.getLocalizedLayerSemantics(name);
            JLabel label = new JLabel();
            label.setText(locName);
            label.setToolTipText(semantics);
            this.addItem(label);
        }
        ObservableSet<Component> selSet = this.m_krnl.getDatabase().getSelectSet();
        if (selSet.isEmpty()) {
            this._setDefaultLayer();
        } else {
            Iterator iter = selSet.iterator();
            Layer layer = null;
            Database db = this.m_krnl.getDatabase();
            ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
            Component comp = null;
            comp = (Component)iter.next();
            layer = (Layer)layerMap.get(comp);
            while (iter.hasNext()) {
                comp = (Component)iter.next();
                if (layer == null || layer == layerMap.get(comp)) continue;
                layer = null;
                break;
            }
            if (layer == null) {
                this.m_inputDevice.setEnabled(false);
                this.setSelectedItem(null);
                this.m_inputDevice.setEnabled(true);
                this.repaint();
            } else {
                String name = lm.getLayerName(layer);
                int i = 0;
                while (i < this.getItemCount()) {
                    JLabel l = (JLabel)this.getItemAt(i);
                    if (l.getText().equals(name)) {
                        this.m_inputDevice.setEnabled(false);
                        this.setSelectedIndex(i);
                        this.m_inputDevice.setEnabled(true);
                        this.repaint();
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private void _setDefaultLayer() {
        LayerManager lm = LayerManager.getLayerManager();
        Layer defLayer = this.m_krnl.getDatabase().getLayerSet().getDefaultLayer();
        String name = this.m_krnl.getDatabase().getNameSpace().getName(defLayer);
        String locName = lm.getLocalizedLayerName(name);
        int i = 0;
        while (i < this.getItemCount()) {
            JLabel l = (JLabel)this.getItemAt(i);
            if (l.getText().equals(locName)) {
                this.m_inputDevice.setEnabled(false);
                this.setSelectedIndex(i);
                this.m_inputDevice.setEnabled(true);
                this.repaint();
                break;
            }
            ++i;
        }
    }

    private int _getDefaultWidth() {
        JComboBox<String> box = new JComboBox<String>();
        box.addItem("NULL_LAYER");
        return box.getPreferredSize().width;
    }
}

