/*
 * Decompiled with CFR 0.152.
 */
package cib.util.binding;

import cib.util.binding.BindingAdapter;
import cib.util.binding.BindingContext;
import cib.util.binding.BindingUtils;
import cib.util.binding.DefaultBindingModel;
import java.util.HashSet;
import java.util.Set;

public class BindingTest {
    public static void main(String[] args) {
        DefaultBindingModel<Node> bindingModel = new DefaultBindingModel<Node>();
        class Node {
            String name = "Unnamed";
            double x = 0.0;

            Node(String name, double x) {
                this.name = name;
                this.x = x;
            }

            public String toString() {
                return String.valueOf(this.name) + "(" + Double.toString(this.x) + ")";
            }
        }
        Node a = new Node("a", 1.0);
        Node b = new Node("b", 2.0);
        Node c = new Node("c", 3.0);
        Node times = new Node("times", 0.0);
        Node plus = new Node("plus", 0.0);
        BindingAdapter<Node> bTimes = new BindingAdapter<Node>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void update(BindingContext<Node> context) {
                System.out.println("bTimes:update()");
                Node bound = (Node)this.getBoundObject();
                Set bindingObjects = this.getBindingObjects();
                bound.x = 1.0;
                for (Node node : bindingObjects) {
                    bound.x *= node.x;
                }
            }

            @Override
            public Object clone() {
                return super.clone();
            }
        };
        bindingModel.addBindingObject(bTimes, b);
        bindingModel.addBindingObject(bTimes, c);
        bindingModel.put(times, bTimes);
        BindingAdapter<Node> bPlus = new BindingAdapter<Node>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void update(BindingContext<Node> context) {
                System.out.println("bPlus:update()");
                Node bound = (Node)this.getBoundObject();
                Set bindingObjects = this.getBindingObjects();
                bound.x = 0.0;
                for (Node node : bindingObjects) {
                    bound.x += node.x;
                }
            }

            @Override
            public Object clone() {
                return super.clone();
            }
        };
        bindingModel.addBindingObject(bPlus, times);
        bindingModel.addBindingObject(bPlus, a);
        bindingModel.put(plus, bPlus);
        System.out.println(bTimes);
        System.out.println(bPlus);
        HashSet<Node> changedObjects = new HashSet<Node>();
        changedObjects.add(b);
        BindingUtils.updateBindings(bindingModel, changedObjects, null);
        System.out.println("Result: " + plus.x);
        System.out.println(a + "+" + b + "*" + c + "=" + plus.x);
        changedObjects.clear();
        a.x = 4.0;
        changedObjects.add(a);
        BindingUtils.updateBindings(bindingModel, changedObjects, null);
        System.out.println("Result: " + plus.x);
        System.out.println(a + "+" + b + "*" + c + "=" + plus.x);
    }
}

