/*
 * Decompiled with CFR 0.152.
 */
package cib.util.dxf.interpreter;

import cib.util.dxf.AttributesAdapter;
import cib.util.dxf.ContentHandler;
import cib.util.dxf.GroupCode;
import cib.util.dxf.interpreter.DXFParserConstants;
import cib.util.dxf.interpreter.DXFParserTokenManager;
import cib.util.dxf.interpreter.JavaCharStream;
import cib.util.dxf.interpreter.ParseException;
import cib.util.dxf.interpreter.Token;
import cib.util.dxf.interpreter.TokenMgrError;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class DXFParser
implements DXFParserConstants {
    private ContentHandler m_ch = null;
    private String m_seqName = null;
    public DXFParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[22];
    private static int[] jj_la1_0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    static {
        DXFParser.jj_la1_0();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: DXFParser filename");
            System.exit(0);
        }
        FileInputStream myStream = null;
        try {
            myStream = new FileInputStream(new File(args[0]));
        }
        catch (IOException e) {
            System.out.println(e);
            System.exit(1);
        }
        DXFParser myParser = new DXFParser(myStream);
        try {
            myParser.start();
        }
        catch (TokenMgrError x) {
            System.out.println(x);
            System.exit(2);
        }
        catch (ParseException x) {
            System.out.println(x);
            System.exit(0);
        }
    }

    private void notifyEntity(AttributesAdapter attr) {
        String type = attr.getValue(GroupCode.GC0);
        if (type.equals("SEQEND")) {
            if (this.m_seqName == null) {
                throw new AssertionError((Object)"Unexpected SEQEND");
            }
            this.m_ch.endElement(this.m_seqName);
            this.m_seqName = null;
            return;
        }
        String val5 = attr.valueExists(GroupCode.GC5) ? attr.getValue(GroupCode.GC5) : "null";
        String name = String.valueOf(type) + "@" + val5;
        if (type.equals("POLYLINE")) {
            if (this.m_seqName != null) {
                throw new AssertionError((Object)"Unexpected start of SEQ");
            }
            this.m_seqName = name;
            this.m_ch.startElement(name, attr);
            return;
        }
        if (type.equals("INSERT")) {
            String val66;
            if (this.m_seqName != null) {
                throw new AssertionError((Object)"Unexpected start of SEQ");
            }
            if (attr.valueExists(GroupCode.GC66) && (val66 = attr.getValue(GroupCode.GC66)).endsWith("1")) {
                this.m_seqName = name;
                this.m_ch.startElement(name, attr);
                return;
            }
        }
        this.m_ch.startElement(name, attr);
        this.m_ch.endElement(name);
    }

    public ContentHandler getContentHandler() {
        return this.m_ch;
    }

    public void setContentHandler(ContentHandler handler) {
        this.m_ch = handler;
    }

    /*
     * Unable to fully structure code
     */
    public final void start() throws ParseException {
        block3: {
            try {
                this.file();
                break block3;
            }
            catch (RuntimeException e) {
                line = this.token == null ? -1 : this.token.beginLine;
                column = this.token == null ? -1 : this.token.beginColumn;
                tokenImage = this.token == null ? "" : this.token.image;
                ste = e.getStackTrace();
                steStr = " at\n";
                i = 0;
                ** while (i < ste.length)
            }
lbl-1000:
            // 1 sources

            {
                steStr = String.valueOf(steStr) + "\t" + ste[i] + "\n";
                ++i;
                continue;
            }
lbl15:
            // 1 sources

            throw new ParseException("Error while parsing line " + line + " and column " + column + ":\n" + tokenImage + "\ngot a RuntimeException " + e + steStr);
        }
    }

    public final void file() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(4);
            this.section();
            this.jj_consume_token(5);
        }
        this.jj_consume_token(6);
    }

    public final void section() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.sectionHeader();
                break;
            }
            case 8: {
                this.sectionClasses();
                break;
            }
            case 9: {
                this.sectionTables();
                break;
            }
            case 10: {
                this.sectionBlocks();
                break;
            }
            case 11: {
                this.sectionEntities();
                break;
            }
            case 12: {
                this.sectionObjects();
                break;
            }
            case 13: {
                this.sectionThumbs();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void sectionHeader() throws ParseException {
        this.jj_consume_token(7);
        this.m_ch.startSection("HEADER");
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.variable();
        }
        this.m_ch.endSection("HEADER");
    }

    public final void variable() throws ParseException {
        AttributesAdapter attr = new AttributesAdapter();
        Token tok = this.jj_consume_token(21);
        attr.add(tok);
        attr.setFirstParsedLine(tok.beginLine);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            tok = this.jj_consume_token(22);
            attr.add(tok);
        }
        attr.setLastParsedLine(tok.beginLine + 1);
        String name = attr.getValue(GroupCode.GC9);
        this.m_ch.startElement(name, attr);
        this.m_ch.endElement(name);
    }

    public final void sectionClasses() throws ParseException {
        this.jj_consume_token(8);
        this.m_ch.startSection("CLASSES");
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            this.aClass();
        }
        this.m_ch.endSection("CLASSES");
    }

    public final void aClass() throws ParseException {
        AttributesAdapter attr = new AttributesAdapter();
        Token tok = this.jj_consume_token(20);
        attr.add(tok);
        attr.setFirstParsedLine(tok.beginLine);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            tok = this.jj_consume_token(22);
            attr.add(tok);
        }
        attr.setLastParsedLine(tok.beginLine + 1);
        String name = attr.getValue(GroupCode.GC1);
        this.m_ch.startElement(name, attr);
        this.m_ch.endElement(name);
    }

    public final void sectionTables() throws ParseException {
        this.jj_consume_token(9);
        this.m_ch.startSection("TABLES");
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block6;
                }
            }
            String name = this.tableStart();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        break block7;
                    }
                }
                this.tableEntry();
            }
            this.tableEnd(name);
        }
        this.m_ch.endSection("TABLES");
    }

    public final String tableStart() throws ParseException {
        AttributesAdapter attr = new AttributesAdapter();
        Token tok = this.jj_consume_token(16);
        attr.add(tok);
        attr.setFirstParsedLine(tok.beginLine);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            tok = this.jj_consume_token(22);
            attr.add(tok);
        }
        attr.setLastParsedLine(tok.beginLine + 1);
        String val5 = attr.valueExists(GroupCode.GC5) ? attr.getValue(GroupCode.GC5) : "null";
        String name = String.valueOf(attr.getValue(GroupCode.GC2)) + "@" + val5;
        this.m_ch.startTable(name, attr);
        return name;
    }

    public final void tableEnd(String name) throws ParseException {
        this.jj_consume_token(17);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(22);
        }
        this.m_ch.endTable(name);
    }

    public final void tableEntry() throws ParseException {
        Token tok;
        AttributesAdapter attr;
        block8: {
            attr = new AttributesAdapter();
            tok = this.jj_consume_token(20);
            attr.add(tok);
            attr.setFirstParsedLine(tok.beginLine);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: 
                    case 22: {
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        tok = this.jj_consume_token(21);
                        continue block7;
                    }
                    case 22: {
                        tok = this.jj_consume_token(22);
                        attr.add(tok);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[11] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        attr.setLastParsedLine(tok.beginLine + 1);
        String type = attr.getValue(GroupCode.GC0);
        String val5 = attr.valueExists(GroupCode.GC5) ? attr.getValue(GroupCode.GC5) : "null";
        String handle = type.equals("DIMSTYLE") ? attr.getValue(GroupCode.GC105, val5) : val5;
        String name = String.valueOf(type) + "@" + handle;
        this.m_ch.startElement(name, attr);
        this.m_ch.endElement(name);
    }

    public final void sectionBlocks() throws ParseException {
        this.jj_consume_token(10);
        this.m_ch.startSection("BLOCKS");
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block6;
                }
            }
            this.blockStart();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        break block7;
                    }
                }
                this.entity();
            }
            this.blockEnd();
        }
        this.m_ch.endSection("BLOCKS");
    }

    public final void blockStart() throws ParseException {
        AttributesAdapter attr = new AttributesAdapter();
        Token tok = this.jj_consume_token(14);
        attr.add(tok);
        attr.setFirstParsedLine(tok.beginLine);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block3;
                }
            }
            tok = this.jj_consume_token(22);
            attr.add(tok);
        }
        attr.setLastParsedLine(tok.beginLine + 1);
        String val5 = attr.valueExists(GroupCode.GC5) ? attr.getValue(GroupCode.GC5) : "null";
        String name = "BLOCK@" + val5;
        this.m_ch.startBlock(name, attr);
    }

    public final void blockEnd() throws ParseException {
        AttributesAdapter attr = new AttributesAdapter();
        Token tok = this.jj_consume_token(15);
        attr.add(tok);
        attr.setFirstParsedLine(tok.beginLine);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            tok = this.jj_consume_token(22);
            attr.add(tok);
        }
        attr.setLastParsedLine(tok.beginLine + 1);
        String val5 = attr.valueExists(GroupCode.GC5) ? attr.getValue(GroupCode.GC5) : "null";
        String name = "BLOCK@" + val5;
        this.m_ch.endBlock(name, attr);
    }

    public final void sectionEntities() throws ParseException {
        this.jj_consume_token(11);
        this.m_ch.startSection("ENTITIES");
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            this.entity();
        }
        this.m_ch.endSection("ENTITIES");
    }

    public final void entity() throws ParseException {
        AttributesAdapter attr = new AttributesAdapter();
        Token tok = this.jj_consume_token(20);
        attr.add(tok);
        attr.setFirstParsedLine(tok.beginLine);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            tok = this.jj_consume_token(22);
            attr.add(tok);
        }
        attr.setLastParsedLine(tok.beginLine + 1);
        this.notifyEntity(attr);
    }

    public final void sectionObjects() throws ParseException {
        this.jj_consume_token(12);
        this.m_ch.startSection("OBJECTS");
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block3;
                }
            }
            this.anObject();
        }
        this.m_ch.endSection("OBJECTS");
    }

    public final void anObject() throws ParseException {
        Token tok;
        AttributesAdapter attr;
        block8: {
            attr = new AttributesAdapter();
            tok = this.jj_consume_token(20);
            attr.add(tok);
            attr.setFirstParsedLine(tok.beginLine);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: 
                    case 22: {
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        tok = this.jj_consume_token(21);
                        continue block7;
                    }
                    case 22: {
                        tok = this.jj_consume_token(22);
                        attr.add(tok);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[20] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        attr.setLastParsedLine(tok.beginLine + 1);
        String val5 = attr.valueExists(GroupCode.GC5) ? attr.getValue(GroupCode.GC5) : "null";
        String name = String.valueOf(attr.getValue(GroupCode.GC0)) + "@" + val5;
        this.m_ch.startElement(name, attr);
        this.m_ch.endElement(name);
    }

    public final void sectionThumbs() throws ParseException {
        this.jj_consume_token(13);
        this.m_ch.startSection("THUMBNAILIMAGE");
        this.thumb();
        this.m_ch.endSection("THUMBNAILIMAGE");
    }

    public final void thumb() throws ParseException {
        AttributesAdapter attr = new AttributesAdapter();
        Token tok = this.jj_consume_token(22);
        attr.add(tok);
        attr.setFirstParsedLine(tok.beginLine);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block3;
                }
            }
            tok = this.jj_consume_token(22);
            attr.add(tok);
        }
        attr.setLastParsedLine(tok.beginLine + 1);
        String name = "THUMBNAILIMAGE";
        this.m_ch.startElement(name, attr);
        this.m_ch.endElement(name);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{16, 16256, 0x200000, 0x400000, 0x100000, 0x400000, 65536, 0x100000, 0x400000, 0x400000, 0x600000, 0x600000, 16384, 0x100000, 0x400000, 0x400000, 0x100000, 0x400000, 0x100000, 0x600000, 0x600000, 0x400000};
    }

    public DXFParser(InputStream stream) {
        this(stream, null);
    }

    public DXFParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new DXFParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public DXFParser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new DXFParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public DXFParser(DXFParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(DXFParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[23];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i = 0;
        while (i < 22) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 23) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

