/*
 * Decompiled with CFR 0.152.
 */
package cib.util.geo;

import cib.util.geo.Geo2D;
import cib.util.geo.Vector2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Path2D
implements Cloneable,
Serializable {
    public static final int SEG_MOVETO = 0;
    public static final int SEG_LINETO = 1;
    public static final int SEG_QUADTO = 2;
    public static final int SEG_CUBICTO = 3;
    public static final int SEG_ARCTO = 4;
    public static final int SEG_CLOSE = 5;
    public static final int NULL = -1;
    private static final int[] SEG_TYPE_PRIORITY;
    private static final long serialVersionUID = 0L;
    private List<Primitive> m_path = new ArrayList<Primitive>();
    private transient Map<Integer, Point2D> m_pnts = new HashMap<Integer, Point2D>();
    private transient Map<Integer, Primitive> m_name2prim = new HashMap<Integer, Primitive>();
    private transient Map<Primitive, Integer> m_prim2name = new HashMap<Primitive, Integer>();
    private long m_num = 0L;
    private boolean m_autoCleaning = true;
    private int m_subVersion = 1;
    private double m_eps = 0.0;

    static {
        int[] nArray = new int[6];
        nArray[0] = 5;
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 4;
        nArray[4] = 2;
        SEG_TYPE_PRIORITY = nArray;
    }

    public Path2D() {
    }

    public Path2D(Point2D sp) {
        this.moveTo(sp);
    }

    public Path2D(double x, double y) {
        this.moveTo(new Point2D.Double(x, y));
    }

    public void reset(Point2D p) {
        this.reset(p.getX(), p.getY());
    }

    public void reset(double x, double y) {
        int n = this.m_path.size();
        int i = n - 1;
        while (i > 0) {
            Primitive prm = this.m_path.get(i);
            this.m_path.remove(i);
            prm.destruct();
            --i;
        }
        Vertex vtx = (Vertex)this.m_path.get(0);
        vtx.setPoint(x, y);
    }

    public void setEps(double eps) {
        if (eps <= Double.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        this.m_eps = eps;
    }

    public double getEps() {
        return this.m_eps <= Double.MIN_VALUE ? Geo2D.getEps() : this.m_eps;
    }

    private Ellipse2D _calculateEllipse2D(Point2D p1, Point2D p2, Point2D p3, Ellipse2D dst) {
        double svEps = Geo2D.getEps();
        try {
            Ellipse2D ell;
            Geo2D.setEps(this.getEps());
            Ellipse2D ellipse2D = ell = Geo2D.calculateEllipse2D(p1, p2, p3, dst);
            return ellipse2D;
        }
        finally {
            Geo2D.setEps(svEps);
        }
    }

    private Arc2D _calculateArc2D(Point2D sp, Point2D p, Point2D ep, Arc2D dst) {
        double svEps = Geo2D.getEps();
        try {
            Arc2D arc;
            Geo2D.setEps(this.getEps());
            Arc2D arc2D = arc = Geo2D.calculateArc2D(sp, p, ep, dst);
            return arc2D;
        }
        finally {
            Geo2D.setEps(svEps);
        }
    }

    public int moveTo(Point2D p) {
        return this.moveTo(p.getX(), p.getY());
    }

    public int moveTo(double x, double y) {
        if (this.m_path.size() == 1) {
            return -1;
        }
        if (this.m_path.isEmpty()) {
            int idx = this.addPoint(new Point2D.Double(x, y));
            Vertex v = new Vertex(idx);
            this.m_path.add(v);
            return -1;
        }
        int nPrims = this.m_path.size();
        Segment lastSeg = (Segment)this.m_path.get(nPrims - 2);
        if (!(lastSeg instanceof MoveSegment)) {
            MoveSegment seg = new MoveSegment(this);
            this.m_path.add(seg);
            int idx = this.addPoint(new Point2D.Double(x, y));
            Vertex v = new Vertex(idx);
            this.m_path.add(v);
            return this.m_prim2name.get(seg);
        }
        return -1;
    }

    public int lineTo(Point2D p) {
        return this.lineTo(p.getX(), p.getY());
    }

    private void _checkPathStateForAdd() {
        int nPrims;
        Segment lastSeg;
        if (this.m_path.size() == 0) {
            throw new IllegalPathStateException("Can't add segment, needs moveto");
        }
        if (this.m_path.size() > 2 && (lastSeg = (Segment)this.m_path.get((nPrims = this.m_path.size()) - 2)) instanceof CloseSegment) {
            throw new IllegalPathStateException("Can't add segment, needs moveto");
        }
    }

    public int lineTo(double x, double y) {
        this._checkPathStateForAdd();
        int idx = this.addPoint(new Point2D.Double(x, y));
        LineSegment seg = new LineSegment(this);
        this.m_path.add(seg);
        this.m_path.add(new Vertex(idx));
        return this.m_prim2name.get(seg);
    }

    public int quadTo(Point2D cp, Point2D p) {
        return this.quadTo(cp.getX(), cp.getY(), p.getX(), p.getY());
    }

    public int quadTo(double cx, double cy, double x, double y) {
        this._checkPathStateForAdd();
        int c_idx = this.addPoint(new Point2D.Double(cx, cy));
        int v_idx = this.addPoint(new Point2D.Double(x, y));
        QuadSegment seg = new QuadSegment(this, c_idx);
        this.m_path.add(seg);
        this.m_path.add(new Vertex(v_idx));
        return this.m_prim2name.get(seg);
    }

    public int cubicTo(Point2D cp1, Point2D cp2, Point2D p) {
        return this.cubicTo(cp1.getX(), cp1.getY(), cp2.getX(), cp2.getY(), p.getX(), p.getY());
    }

    public int cubicTo(double cx1, double cy1, double cx2, double cy2, double x, double y) {
        this._checkPathStateForAdd();
        int c1_idx = this.addPoint(new Point2D.Double(cx1, cy1));
        int c2_idx = this.addPoint(new Point2D.Double(cx2, cy2));
        int v_idx = this.addPoint(new Point2D.Double(x, y));
        CubicSegment seg = new CubicSegment(this, c1_idx, c2_idx);
        this.m_path.add(seg);
        this.m_path.add(new Vertex(v_idx));
        return this.m_prim2name.get(seg);
    }

    public int arcTo(Point2D ap, Point2D p) {
        return this.arcTo(ap.getX(), ap.getY(), p.getX(), p.getY());
    }

    public int arcTo(double px, double py, double x, double y) {
        this._checkPathStateForAdd();
        int p_idx = this.addPoint(new Point2D.Double(px, py));
        ArcSegment seg = new ArcSegment(this, p_idx);
        this.m_path.add(seg);
        int ep_idx = this.addPoint(new Point2D.Double(x, y));
        this.m_path.add(new Vertex(ep_idx));
        return this.m_prim2name.get(seg);
    }

    public int close() {
        if (this.m_path.isEmpty()) {
            return -1;
        }
        Vertex v = new Vertex(-1);
        CloseSegment seg = new CloseSegment(this);
        this.m_path.add(seg);
        this.m_path.add(v);
        return this.m_prim2name.get(seg);
    }

    public void setAutoCleaning(boolean on) {
        this.m_autoCleaning = on;
    }

    public boolean isAutoCleaning() {
        return this.m_autoCleaning;
    }

    public void clean() {
        Vertex vtx;
        Segment seg;
        Segment seg2;
        Segment segj;
        Segment segi;
        int i = 2;
        while (i < this.m_path.size() - 2) {
            segi = (Segment)this.m_path.get(i - 1);
            segj = (Segment)this.m_path.get(i + 1);
            if (segi instanceof MoveSegment && segj instanceof CloseSegment) {
                Vertex vtxj = (Vertex)this.m_path.get(i + 2);
                vtxj.destruct();
                segj.destruct();
                this.m_path.remove(i + 2);
                this.m_path.remove(i + 1);
                i -= 2;
            }
            i += 2;
        }
        if (this.m_path.size() > 1 && (seg2 = (Segment)this.m_path.get(1)) instanceof CloseSegment) {
            this.m_path.remove(2);
            this.m_path.remove(1);
        }
        i = 2;
        while (i < this.m_path.size() - 2) {
            segi = (Segment)this.m_path.get(i - 1);
            segj = (Segment)this.m_path.get(i + 1);
            if (segi instanceof MoveSegment && segj instanceof MoveSegment) {
                Vertex vtxi = (Vertex)this.m_path.get(i);
                vtxi.destruct();
                segj.destruct();
                this.m_path.remove(i + 1);
                this.m_path.remove(i);
                i -= 2;
            }
            i += 2;
        }
        int n = this.m_path.size();
        int i2 = n - 2;
        while (i2 > 0) {
            seg = (Segment)this.m_path.get(i2);
            if (!(seg instanceof MoveSegment)) break;
            vtx = (Vertex)this.m_path.get(i2 + 1);
            vtx.destruct();
            seg.destruct();
            this.m_path.remove(i2 + 1);
            this.m_path.remove(i2);
            i2 -= 2;
        }
        i2 = 1;
        while (i2 < this.m_path.size()) {
            seg = (Segment)this.m_path.get(i2);
            if (!(seg instanceof MoveSegment)) break;
            vtx = (Vertex)this.m_path.get(0);
            vtx.destruct();
            seg.destruct();
            this.m_path.remove(1);
            this.m_path.remove(0);
            i2 -= 2;
            i2 += 2;
        }
    }

    private Vertex _startOfLoop(Vertex closeVertex) {
        int pos = this.m_path.indexOf(closeVertex);
        int i = pos - 1;
        while (i > 0) {
            Segment seg = (Segment)this.m_path.get(i);
            if (seg instanceof MoveSegment) {
                return (Vertex)this.m_path.get(i + 1);
            }
            i -= 2;
        }
        return (Vertex)this.m_path.get(0);
    }

    public Shape getSegmentShape(int name) {
        Integer segment = this.m_prim2name.get(name);
        int segIndex = this.m_path.indexOf(segment);
        if (segIndex == -1) {
            throw new IllegalArgumentException("Illegal segment name");
        }
        Primitive start = this.m_path.get(segIndex - 1);
        Primitive end = this.m_path.get(segIndex + 1);
        if (!(segment instanceof Segment && start instanceof Vertex && end instanceof Vertex)) {
            throw new IllegalPathStateException();
        }
        return ((Segment)((Object)segment)).getShape((Vertex)start, (Vertex)end);
    }

    public Shape getShape() {
        Path2D.Double path = new Path2D.Double();
        path.setWindingRule(0);
        if (this.m_path.size() >= 1) {
            Vertex vtx = (Vertex)this.m_path.get(0);
            Point2D pnt = vtx.getPoint();
            ((java.awt.geom.Path2D)path).moveTo(pnt.getX(), pnt.getY());
        }
        int i = 1;
        while (i < this.m_path.size()) {
            Primitive el = this.m_path.get(i);
            if (el instanceof Segment) {
                Segment s = (Segment)el;
                Vertex prev = (Vertex)this.m_path.get(i - 1);
                Vertex next = (Vertex)this.m_path.get(i + 1);
                switch (s.getType()) {
                    case 0: {
                        ((java.awt.geom.Path2D)path).moveTo(next.getPoint().getX(), next.getPoint().getY());
                        break;
                    }
                    case 5: {
                        path.closePath();
                        break;
                    }
                    default: {
                        Shape shape = s.getShape(prev, next);
                        double[] crds = new double[6];
                        PathIterator pit = shape.getPathIterator(null);
                        while (!pit.isDone()) {
                            int seg = pit.currentSegment(crds);
                            switch (seg) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    ((java.awt.geom.Path2D)path).lineTo(crds[0], crds[1]);
                                    break;
                                }
                                case 2: {
                                    ((java.awt.geom.Path2D)path).quadTo(crds[0], crds[1], crds[2], crds[3]);
                                    break;
                                }
                                case 3: {
                                    ((java.awt.geom.Path2D)path).curveTo(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5]);
                                    break;
                                }
                                default: {
                                    throw new InternalError("Unexpected segment type");
                                }
                            }
                            pit.next();
                        }
                        break block0;
                    }
                }
            } else {
                throw new IllegalPathStateException("Can't create shape.");
            }
            i += 2;
        }
        return path;
    }

    public double length() {
        double svEps = Geo2D.getEps();
        Geo2D.setEps(this.m_eps);
        double len = 0.0;
        int i = 1;
        while (i < this.m_path.size()) {
            Segment s = (Segment)this.m_path.get(i);
            Vertex prev = (Vertex)this.m_path.get(i - 1);
            Vertex next = (Vertex)this.m_path.get(i + 1);
            len += s.length(prev, next);
            i += 2;
        }
        Geo2D.setEps(svEps);
        return len;
    }

    public double area() {
        if (!this.isClosed()) {
            return Double.NaN;
        }
        Shape shape = this.getShape();
        if (shape == null) {
            return Double.NaN;
        }
        double area = 0.0;
        Area areaShape = new Area(shape);
        double[] subCurveStart = new double[2];
        double[] lastCrds = new double[2];
        double[] crds = new double[2];
        PathIterator pit = areaShape.getPathIterator(null, 0.1 * Geo2D.getEps());
        while (!pit.isDone()) {
            int seg = pit.currentSegment(crds);
            switch (seg) {
                case 0: {
                    subCurveStart[0] = crds[0];
                    subCurveStart[1] = crds[1];
                    lastCrds[0] = crds[0];
                    lastCrds[1] = crds[1];
                    break;
                }
                case 1: {
                    area += (crds[0] - lastCrds[0]) * 0.5 * (lastCrds[1] + crds[1]);
                    lastCrds[0] = crds[0];
                    lastCrds[1] = crds[1];
                    break;
                }
                case 4: {
                    area += (subCurveStart[0] - lastCrds[0]) * 0.5 * (lastCrds[1] + subCurveStart[1]);
                    break;
                }
                default: {
                    throw new InternalError("Unexpected segment type");
                }
            }
            pit.next();
        }
        return area;
    }

    public boolean isClosed() {
        double svEps = Geo2D.getEps();
        Geo2D.setEps(this.m_eps);
        int startPosLoop = 0;
        int i = 1;
        while (i < this.m_path.size()) {
            Segment seg = (Segment)this.m_path.get(i);
            switch (seg.getType()) {
                case 0: {
                    Vertex sVtx = (Vertex)this.m_path.get(startPosLoop);
                    Vertex eVtx = (Vertex)this.m_path.get(i - 1);
                    if (!Geo2D.equality(sVtx.getPoint(), eVtx.getPoint())) {
                        Geo2D.setEps(svEps);
                        return false;
                    }
                    startPosLoop = i + 1;
                    break;
                }
                case 5: {
                    startPosLoop = i + 1;
                }
            }
            i += 2;
        }
        Vertex sVtx = (Vertex)this.m_path.get(startPosLoop);
        Vertex eVtx = (Vertex)this.m_path.get(this.m_path.size() - 1);
        boolean status = Geo2D.equality(sVtx.getPoint(), eVtx.getPoint());
        Geo2D.setEps(svEps);
        return status;
    }

    private int addPoint(Point2D loc) {
        int name = (int)this.m_num++;
        this.m_pnts.put(name, loc);
        return name;
    }

    public int getVertexCount() {
        int n = this.m_path.isEmpty() ? 0 : (this.m_path.size() + 1) / 2;
        return n;
    }

    public int getVertexName(int index) {
        if (index < 0 || index >= this.getVertexCount()) {
            throw new IndexOutOfBoundsException("Invalid vertex index " + index);
        }
        int pathIndex = index + index;
        Vertex vtx = (Vertex)this.m_path.get(pathIndex);
        int name = this.m_prim2name.get(vtx);
        return name;
    }

    public boolean containsVertex(int name) {
        Primitive obj = this.m_name2prim.get(name);
        return obj instanceof Vertex;
    }

    public Point2D getVertexLocation(int name, Point2D dst) {
        if (dst == null) {
            dst = new Point2D.Double();
        }
        Vertex vtx = (Vertex)this.m_name2prim.get(name);
        dst.setLocation(vtx.getPoint());
        return dst;
    }

    public void setVertexLocation(int name, Point2D location) {
        Vertex vtx = (Vertex)this.m_name2prim.get(name);
        vtx.setPoint(location);
    }

    public void removeVertex(int name) {
        if (this.m_path.size() <= 1) {
            return;
        }
        Vertex vtxi = (Vertex)this.m_name2prim.get(name);
        int i = this.m_path.indexOf(vtxi);
        if (i == -1) {
            return;
        }
        if (i == 0) {
            vtxi.destruct();
            Segment seg = (Segment)this.m_path.get(1);
            seg.destruct();
            this.m_path.remove(1);
            this.m_path.remove(0);
        } else if (i == this.m_path.size() - 1) {
            vtxi.destruct();
            Segment seg = (Segment)this.m_path.get(i - 1);
            seg.destruct();
            this.m_path.remove(i);
            this.m_path.remove(i - 1);
        } else {
            int prioj;
            Segment segi = (Segment)this.m_path.get(i - 1);
            Segment segj = (Segment)this.m_path.get(i + 1);
            int prioi = SEG_TYPE_PRIORITY[segi.getType()];
            if (prioi >= (prioj = SEG_TYPE_PRIORITY[segj.getType()])) {
                vtxi.destruct();
                Segment seg = (Segment)this.m_path.get(i + 1);
                seg.destruct();
                Vertex vtxj = (Vertex)this.m_path.get(i + 2);
                if (vtxj.isCloseVertex()) {
                    vtxj.toCloseVertex(false);
                }
                this.m_path.remove(i + 1);
                this.m_path.remove(i);
            } else {
                vtxi.destruct();
                Segment seg = (Segment)this.m_path.get(i - 1);
                seg.destruct();
                this.m_path.remove(i);
                this.m_path.remove(i - 1);
            }
        }
        if (this.m_autoCleaning) {
            this.clean();
        }
    }

    public int getSegmentCount() {
        int n = this.m_path.isEmpty() ? 0 : (this.m_path.size() - 1) / 2;
        return n;
    }

    public int getSegmentName(int index) {
        if (index < 0 || index >= this.getSegmentCount()) {
            throw new IndexOutOfBoundsException("Invalid segment index " + index);
        }
        int pathIndex = index + index + 1;
        Segment seg = (Segment)this.m_path.get(pathIndex);
        int name = this.m_prim2name.get(seg);
        return name;
    }

    public int getPreviousSegmentName(int vertexName) {
        Vertex vtx = (Vertex)this.m_name2prim.get(vertexName);
        int index = this.m_path.indexOf(vtx);
        if (index == 0) {
            return -1;
        }
        Segment seg = (Segment)this.m_path.get(--index);
        int name = this.m_prim2name.get(seg);
        return name;
    }

    public int getNextSegmentName(int vertexName) {
        Vertex vtx = (Vertex)this.m_name2prim.get(vertexName);
        int index = this.m_path.indexOf(vtx);
        if (index >= this.m_path.size() - 1) {
            return -1;
        }
        Segment seg = (Segment)this.m_path.get(++index);
        int name = this.m_prim2name.get(seg);
        return name;
    }

    public boolean containsSegment(int name) {
        Primitive obj = this.m_name2prim.get(name);
        return obj instanceof Segment;
    }

    public void setSegment(int name, int type, double[] crds) {
        Segment seg = (Segment)this.m_name2prim.get(name);
        int pathIndex = this.m_path.indexOf(seg);
        Vertex previousVtx = (Vertex)this.m_path.get(pathIndex - 1);
        Vertex nextVtx = (Vertex)this.m_path.get(pathIndex + 1);
        switch (type) {
            case 0: {
                if (seg.getType() != 0) {
                    seg = new MoveSegment(this, name);
                    this.m_path.set(pathIndex, seg);
                }
                seg.setSegment(previousVtx, nextVtx, crds);
                break;
            }
            case 1: {
                if (seg.getType() != 1) {
                    seg = new LineSegment(this, name);
                    this.m_path.set(pathIndex, seg);
                }
                seg.setSegment(previousVtx, nextVtx, crds);
                break;
            }
            case 2: {
                if (seg.getType() != 2) {
                    int ctrl = this.addPoint(new Point2D.Double(crds[2], crds[3]));
                    seg = new QuadSegment(this, name, ctrl);
                    this.m_path.set(pathIndex, seg);
                }
                seg.setSegment(previousVtx, nextVtx, crds);
                break;
            }
            case 3: {
                if (seg.getType() != 3) {
                    int ctrl1 = this.addPoint(new Point2D.Double(crds[2], crds[3]));
                    int ctrl2 = this.addPoint(new Point2D.Double(crds[4], crds[5]));
                    seg = new CubicSegment(this, name, ctrl1, ctrl2);
                    this.m_path.set(pathIndex, seg);
                }
                seg.setSegment(previousVtx, nextVtx, crds);
                break;
            }
            case 4: {
                if (seg.getType() != 4) {
                    int pnt = this.addPoint(new Point2D.Double(crds[2], crds[3]));
                    seg = new ArcSegment(this, name, pnt);
                    this.m_path.set(pathIndex, seg);
                }
                seg.setSegment(previousVtx, nextVtx, crds);
                break;
            }
            case 5: {
                if (seg.getType() != 5) {
                    seg = new CloseSegment(this, name);
                    this.m_path.set(pathIndex, seg);
                }
                seg.setSegment(previousVtx, nextVtx, crds);
                break;
            }
            default: {
                throw new IllegalPathStateException();
            }
        }
    }

    public int getSegment(int name, double[] crds) {
        Segment seg = (Segment)this.m_name2prim.get(name);
        int pathIndex = this.m_path.indexOf(seg);
        Vertex startVtx = (Vertex)this.m_path.get(pathIndex - 1);
        Vertex endVtx = (Vertex)this.m_path.get(pathIndex + 1);
        return seg.getSegment(startVtx, endVtx, crds);
    }

    public Point2D getPointOnSegment(int name, Point2D pnt) {
        if (pnt == null) {
            pnt = new Point2D.Double();
        }
        Segment seg = (Segment)this.m_name2prim.get(name);
        int pathIndex = this.m_path.indexOf(seg);
        Vertex startVtx = (Vertex)this.m_path.get(pathIndex - 1);
        Vertex endVtx = (Vertex)this.m_path.get(pathIndex + 1);
        return seg.getPointOnSegment(startVtx, endVtx, pnt);
    }

    public Point2D getSegmentRepresentativeLocation(int name, Point2D pnt) {
        if (pnt == null) {
            pnt = new Point2D.Double();
        }
        Segment seg = (Segment)this.m_name2prim.get(name);
        int pathIndex = this.m_path.indexOf(seg);
        Vertex startVtx = (Vertex)this.m_path.get(pathIndex - 1);
        Vertex endVtx = (Vertex)this.m_path.get(pathIndex + 1);
        return seg.getRepresentativeLocation(startVtx, endVtx, pnt);
    }

    public int getSegmentStartVertex(int name) {
        Segment seg = (Segment)this.m_name2prim.get(name);
        int pathIndex = this.m_path.indexOf(seg);
        Vertex vtx = (Vertex)this.m_path.get(pathIndex - 1);
        return this.m_prim2name.get(vtx);
    }

    public int getSegmentEndVertex(int name) {
        Segment seg = (Segment)this.m_name2prim.get(name);
        int pathIndex = this.m_path.indexOf(seg);
        Vertex vtx = (Vertex)this.m_path.get(pathIndex + 1);
        return this.m_prim2name.get(vtx);
    }

    public int splitSegment(int name) {
        Segment seg = (Segment)this.m_name2prim.get(name);
        int pathIndex = this.m_path.indexOf(seg);
        Vertex startVtx = (Vertex)this.m_path.get(pathIndex - 1);
        Vertex endVtx = (Vertex)this.m_path.get(pathIndex + 1);
        double[] crds = new double[8];
        int type = seg.getSegment(startVtx, endVtx, crds);
        Point2D center = this.getPointOnSegment(name, null);
        Vertex newVtx = new Vertex(this.addPoint(center));
        switch (type) {
            case 1: {
                LineSegment newSeg = new LineSegment(this);
                this.m_path.add(pathIndex + 1, newVtx);
                this.m_path.add(pathIndex + 2, newSeg);
                crds[2] = center.getX();
                crds[3] = center.getY();
                seg.setSegment(startVtx, newVtx, crds);
                crds[0] = center.getX();
                crds[1] = center.getY();
                crds[2] = endVtx.getPoint().getX();
                crds[3] = endVtx.getPoint().getY();
                newSeg.setSegment(newVtx, endVtx, crds);
                return this.m_prim2name.get(newSeg);
            }
            case 2: {
                QuadSegment newSeg = new QuadSegment(this, this.addPoint(new Point2D.Double()));
                this.m_path.add(pathIndex + 1, newVtx);
                this.m_path.add(pathIndex + 2, newSeg);
                QuadCurve2D.Double quad = new QuadCurve2D.Double(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5]);
                QuadCurve2D.Double left = new QuadCurve2D.Double();
                QuadCurve2D.Double right = new QuadCurve2D.Double();
                quad.subdivide(left, right);
                crds[0] = ((QuadCurve2D)left).getX1();
                crds[1] = ((QuadCurve2D)left).getY1();
                crds[2] = ((QuadCurve2D)left).getCtrlX();
                crds[3] = ((QuadCurve2D)left).getCtrlY();
                crds[4] = ((QuadCurve2D)left).getX2();
                crds[5] = ((QuadCurve2D)left).getY2();
                seg.setSegment(startVtx, newVtx, crds);
                crds[0] = ((QuadCurve2D)right).getX1();
                crds[1] = ((QuadCurve2D)right).getY1();
                crds[2] = ((QuadCurve2D)right).getCtrlX();
                crds[3] = ((QuadCurve2D)right).getCtrlY();
                crds[4] = ((QuadCurve2D)right).getX2();
                crds[5] = ((QuadCurve2D)right).getY2();
                newSeg.setSegment(newVtx, endVtx, crds);
                return this.m_prim2name.get(newSeg);
            }
            case 3: {
                CubicSegment newSeg = new CubicSegment(this, this.addPoint(new Point2D.Double()), this.addPoint(new Point2D.Double()));
                this.m_path.add(pathIndex + 1, newVtx);
                this.m_path.add(pathIndex + 2, newSeg);
                CubicCurve2D.Double cubic = new CubicCurve2D.Double(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5], crds[6], crds[7]);
                CubicCurve2D.Double left = new CubicCurve2D.Double();
                CubicCurve2D.Double right = new CubicCurve2D.Double();
                cubic.subdivide(left, right);
                crds[0] = ((CubicCurve2D)left).getX1();
                crds[1] = ((CubicCurve2D)left).getY1();
                crds[2] = ((CubicCurve2D)left).getCtrlX1();
                crds[3] = ((CubicCurve2D)left).getCtrlY1();
                crds[4] = ((CubicCurve2D)left).getCtrlX2();
                crds[5] = ((CubicCurve2D)left).getCtrlY2();
                crds[6] = ((CubicCurve2D)left).getX2();
                crds[7] = ((CubicCurve2D)left).getY2();
                seg.setSegment(startVtx, newVtx, crds);
                crds[0] = ((CubicCurve2D)right).getX1();
                crds[1] = ((CubicCurve2D)right).getY1();
                crds[2] = ((CubicCurve2D)right).getCtrlX1();
                crds[3] = ((CubicCurve2D)right).getCtrlY1();
                crds[4] = ((CubicCurve2D)right).getCtrlX2();
                crds[5] = ((CubicCurve2D)right).getCtrlY2();
                crds[6] = ((CubicCurve2D)right).getX2();
                crds[7] = ((CubicCurve2D)right).getY2();
                newSeg.setSegment(newVtx, endVtx, crds);
                return this.m_prim2name.get(newSeg);
            }
            case 4: {
                ArcSegment newSeg = new ArcSegment(this, this.addPoint(new Point2D.Double()));
                this.m_path.add(pathIndex + 1, newVtx);
                this.m_path.add(pathIndex + 2, newSeg);
                Point2D.Double start = new Point2D.Double(crds[0], crds[1]);
                Point2D.Double end = new Point2D.Double(crds[4], crds[5]);
                Arc2D arc = this._calculateArc2D(start, center, end, new Arc2D.Double());
                double sweepAngle = -Math.toRadians(arc.getAngleExtent());
                AffineTransform trf = AffineTransform.getRotateInstance(0.25 * sweepAngle, arc.getCenterX(), arc.getCenterY());
                Point2D.Double arcPnt = new Point2D.Double(crds[0], crds[1]);
                trf.transform(arcPnt, arcPnt);
                crds[2] = ((Point2D)arcPnt).getX();
                crds[3] = ((Point2D)arcPnt).getY();
                crds[4] = center.getX();
                crds[5] = center.getY();
                seg.setSegment(startVtx, newVtx, crds);
                arcPnt.setLocation(center);
                trf.transform(arcPnt, arcPnt);
                crds[0] = center.getX();
                crds[1] = center.getY();
                crds[2] = ((Point2D)arcPnt).getX();
                crds[3] = ((Point2D)arcPnt).getY();
                crds[4] = endVtx.getPoint().getX();
                crds[5] = endVtx.getPoint().getY();
                newSeg.setSegment(newVtx, endVtx, crds);
                return this.m_prim2name.get(newSeg);
            }
        }
        throw new IllegalArgumentException();
    }

    public void removeSegment(int name) {
        Segment seg = (Segment)this.m_name2prim.get(name);
        int pathIndex = this.m_path.indexOf(seg);
        Vertex startVtx = (Vertex)this.m_path.get(pathIndex - 1);
        Vertex endVtx = (Vertex)this.m_path.get(pathIndex + 1);
        double[] crds = new double[]{startVtx.getPoint().getX(), startVtx.getPoint().getY(), endVtx.getPoint().getX(), endVtx.getPoint().getY()};
        this.setSegment(name, 0, crds);
        if (this.m_autoCleaning) {
            this.clean();
        }
    }

    public int getSegmentPointCount(int segName) {
        Segment seg = (Segment)this.m_name2prim.get(segName);
        return seg.getPointCount();
    }

    public int getSegmentPointName(int segName, int index) {
        Segment seg = (Segment)this.m_name2prim.get(segName);
        return seg.getPointName(index);
    }

    public Point2D getSegmentPointLocation(int pntName, Point2D dst) {
        if (dst == null) {
            dst = new Point2D.Double();
        }
        dst.setLocation(this.m_pnts.get(pntName));
        return dst;
    }

    public void setSegmentPointLocation(int pntName, Point2D p) {
        Point2D pnt = this.m_pnts.get(pntName);
        pnt.setLocation(p);
    }

    public boolean containsSegmentPoint(int pntName) {
        int nSegs = this.getSegmentCount();
        int iSeg = 0;
        while (iSeg < nSegs) {
            int segName = this.getSegmentName(iSeg);
            int nPnts = this.getSegmentPointCount(segName);
            int iPnt = 0;
            while (iPnt < nPnts) {
                if (pntName == this.getSegmentPointName(segName, iPnt)) {
                    return true;
                }
                ++iPnt;
            }
            ++iSeg;
        }
        return false;
    }

    public int getSegmentOfSegmentPoint(int pntName) {
        int nSegs = this.getSegmentCount();
        int iSeg = 0;
        while (iSeg < nSegs) {
            int segName = this.getSegmentName(iSeg);
            int nPnts = this.getSegmentPointCount(segName);
            int iPnt = 0;
            while (iPnt < nPnts) {
                if (pntName == this.getSegmentPointName(segName, iPnt)) {
                    return segName;
                }
                ++iPnt;
            }
            ++iSeg;
        }
        return -1;
    }

    public void transformBy(AffineTransform at) {
        Set<Integer> keySet = this.m_pnts.keySet();
        for (int i : keySet) {
            Point2D p = this.m_pnts.get(i);
            Point2D.Double pt = new Point2D.Double();
            at.transform(p, pt);
            this.m_pnts.put(i, pt);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int size = this.m_pnts.size();
        out.writeInt(size);
        Set<Integer> keySet = this.m_pnts.keySet();
        for (int name : keySet) {
            out.writeInt(name);
            Point2D p = this.m_pnts.get(name);
            out.writeDouble(p.getX());
            out.writeDouble(p.getY());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        HashMap<Integer, Primitive> prmNameMap = new HashMap<Integer, Primitive>();
        int n = this.m_path.size();
        int i = 0;
        while (i < n) {
            Primitive prm = this.m_path.get(i);
            int prmName = prm.getPrimitiveName();
            if (prmNameMap.containsKey(prmName)) {
                System.out.println("Path2D.readObject(): name problem fixed.");
                prmName = (int)this.m_num++;
                prm.setPrimitiveName(prmName);
            }
            prmNameMap.put(prmName, prm);
            ++i;
        }
        this.m_pnts = new HashMap<Integer, Point2D>();
        int size = in.readInt();
        int i2 = 0;
        while (i2 < size) {
            int name = in.readInt();
            Point2D.Double p = new Point2D.Double(in.readDouble(), in.readDouble());
            this.m_pnts.put(name, p);
            ++i2;
        }
        this.m_name2prim = new HashMap<Integer, Primitive>();
        this.m_prim2name = new HashMap<Primitive, Integer>();
        i2 = 0;
        while (i2 < this.m_path.size()) {
            Primitive obj = this.m_path.get(i2);
            int name = obj.getPrimitiveName();
            if (this.m_subVersion == 0) {
                name = (int)this.m_num++;
                obj.setPrimitiveName(name);
            }
            this.m_name2prim.put(name, obj);
            this.m_prim2name.put(obj, name);
            ++i2;
        }
        n = this.m_path.size();
        i2 = 1;
        while (i2 < n) {
            Segment seg = (Segment)this.m_path.get(i2);
            seg.evolve((Vertex)this.m_path.get(i2 - 1), (Vertex)this.m_path.get(i2 + 1));
            i2 += 2;
        }
        this.m_subVersion = 1;
    }

    protected void _dump() {
        System.out.println("m_path");
        Iterator<Primitive> it = this.m_path.iterator();
        while (it.hasNext()) {
            System.out.println("  " + it.next());
        }
        System.out.println("m_pnts");
        Set<Integer> set = this.m_pnts.keySet();
        for (int key : set) {
            Point2D pnt = this.m_pnts.get(key);
            System.out.println("  " + key + " -> " + pnt);
        }
        System.out.println("m_name2prim");
        set = this.m_name2prim.keySet();
        for (int key : set) {
            Primitive obj = this.m_name2prim.get(key);
            System.out.println("  " + key + " -> " + obj);
        }
        System.out.println("m_prim2name");
        Set<Primitive> objSet = this.m_prim2name.keySet();
        for (Primitive key : objSet) {
            int val = this.m_prim2name.get(key);
            System.out.println("  " + val + " <- " + key);
        }
        System.out.println("m_num = " + this.m_num);
    }

    public Object clone() {
        Path2D clone = new Path2D();
        clone.m_pnts = new HashMap<Integer, Point2D>();
        for (int key : this.m_pnts.keySet()) {
            clone.m_pnts.put(key, (Point2D)this.m_pnts.get(key).clone());
        }
        clone.m_path = new ArrayList<Primitive>();
        int i = 0;
        while (i < this.m_path.size()) {
            block12: {
                block13: {
                    Primitive el;
                    block11: {
                        el = this.m_path.get(i);
                        if (!(el instanceof Vertex)) break block11;
                        Vertex vtx = (Vertex)el;
                        List<Primitive> list = clone.m_path;
                        Path2D path2D = clone;
                        path2D.getClass();
                        list.add(path2D.new Vertex((int)vtx.m_name));
                        break block12;
                    }
                    if (!(el instanceof Segment)) break block13;
                    Segment s_org = (Segment)el;
                    switch (s_org.getType()) {
                        case 0: {
                            clone.m_path.add(new MoveSegment(clone));
                            break block12;
                        }
                        case 1: {
                            clone.m_path.add(new LineSegment(clone));
                            break block12;
                        }
                        case 2: {
                            List<Primitive> list = clone.m_path;
                            Path2D path2D = clone;
                            path2D.getClass();
                            list.add(new QuadSegment(path2D, ((QuadSegment)el).getCtrlPtName()));
                            break block12;
                        }
                        case 3: {
                            List<Primitive> list = clone.m_path;
                            Path2D path2D = clone;
                            path2D.getClass();
                            list.add(new CubicSegment(path2D, ((CubicSegment)el).getCtrlP1Name(), ((CubicSegment)el).getCtrlP2Name()));
                            break block12;
                        }
                        case 4: {
                            List<Primitive> list = clone.m_path;
                            Path2D path2D = clone;
                            path2D.getClass();
                            list.add(new ArcSegment(path2D, ((ArcSegment)el).getArcPtName()));
                            break block12;
                        }
                        case 5: {
                            clone.m_path.add(new CloseSegment(clone));
                            break block12;
                        }
                        default: {
                            throw new IllegalPathStateException();
                        }
                    }
                }
                throw new IllegalStateException();
            }
            ++i;
        }
        clone.m_num = this.m_num;
        clone.m_name2prim.clear();
        clone.m_prim2name.clear();
        i = 0;
        while (i < clone.m_path.size()) {
            Primitive src = this.m_path.get(i);
            int name = this.m_prim2name.get(src);
            Primitive dst = clone.m_path.get(i);
            clone.m_name2prim.put(name, dst);
            clone.m_prim2name.put(dst, name);
            ++i;
        }
        return clone;
    }

    public Path2DIterator getIterator() {
        return new Path2DIterator();
    }

    public String toString() {
        String string = new String("Path2D:\n  " + new MoveSegment(this).toString() + "\n");
        ListIterator<Primitive> lit = this.m_path.listIterator();
        while (lit.hasNext()) {
            string = String.valueOf(string) + "  " + lit.next().toString() + "\n";
        }
        return string;
    }

    private class ArcSegment
    implements Segment {
        private static final long serialVersionUID = 0L;
        private int m_subVersion;
        private int m_segmentName;
        private long m_cp;
        private double m_alpha;
        final /* synthetic */ Path2D this$0;

        public ArcSegment(Path2D path2D, int arcPoint) {
            Path2D path2D2 = path2D;
            long l = path2D2.m_num;
            path2D2.m_num = l + 1L;
            this(path2D, (int)l, arcPoint);
        }

        public ArcSegment(Path2D path2D, int segName, int arcPoint) {
            this.this$0 = path2D;
            this.m_subVersion = 1;
            this.m_cp = arcPoint;
            this.m_segmentName = segName;
            path2D.m_name2prim.put(segName, this);
            path2D.m_prim2name.put(this, segName);
        }

        @Override
        public int getType() {
            return 4;
        }

        public int getArcPtName() {
            return (int)this.m_cp;
        }

        @Override
        public int getSegment(Vertex start, Vertex end, double[] crds) {
            Point2D p = start.getPoint();
            crds[0] = p.getX();
            crds[1] = p.getY();
            p = (Point2D)this.this$0.m_pnts.get(this.getArcPtName());
            crds[2] = p.getX();
            crds[3] = p.getY();
            p = end.getPoint();
            crds[4] = p.getX();
            crds[5] = p.getY();
            return 4;
        }

        @Override
        public void setSegment(Vertex start, Vertex end, double[] crds) {
            start.toCloseVertex(false);
            end.toCloseVertex(false);
            start.setPoint(crds[0], crds[1]);
            Point2D pArc = (Point2D)this.this$0.m_pnts.get(this.getArcPtName());
            pArc.setLocation(crds[2], crds[3]);
            end.setPoint(crds[4], crds[5]);
        }

        @Override
        public int getPointCount() {
            return 1;
        }

        @Override
        public int getPointName(int index) {
            if (index == 0) {
                return this.getArcPtName();
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Point2D getPointOnSegment(Vertex start, Vertex end, Point2D dst) {
            if (dst == null) {
                dst = new Point2D.Double();
            }
            Point2D sp = start.getPoint();
            Point2D ep = end.getPoint();
            Point2D p = (Point2D)this.this$0.m_pnts.get(this.getArcPtName());
            Arc2D arc = this.this$0._calculateArc2D(sp, p, ep, new Arc2D.Double());
            if (arc == null) {
                dst.setLocation(0.5 * (sp.getX() + ep.getX()), 0.5 * (sp.getY() + ep.getY()));
                return dst;
            }
            double alfaStart = -arc.getAngleStart();
            double alfaSweep = -arc.getAngleExtent();
            double angle = Math.toRadians(alfaStart + 0.5 * alfaSweep);
            double centerX = arc.getCenterX();
            double centerY = arc.getCenterY();
            double r = Geo2D.distance(sp, new Point2D.Double(centerX, centerY));
            double x = centerX + r * Math.cos(angle);
            double y = centerY + r * Math.sin(angle);
            dst.setLocation(x, y);
            return dst;
        }

        @Override
        public Point2D getRepresentativeLocation(Vertex start, Vertex end, Point2D dst) {
            if (dst == null) {
                dst = new Point2D.Double();
            }
            Point2D sp = start.getPoint();
            Point2D ep = end.getPoint();
            Ellipse2D ellipse = this.this$0._calculateEllipse2D(sp, (Point2D)this.this$0.m_pnts.get(this.getArcPtName()), ep, new Ellipse2D.Double());
            if (ellipse == null) {
                dst.setLocation(0.5 * (sp.getX() + ep.getX()), 0.5 * (sp.getY() + ep.getY()));
            } else {
                dst.setLocation(ellipse.getCenterX(), ellipse.getCenterY());
            }
            return dst;
        }

        @Override
        public Shape getShape(Vertex start, Vertex end) {
            Point2D ep;
            Point2D p;
            Point2D sp = start.getPoint();
            Arc2D arc = this.this$0._calculateArc2D(sp, p = (Point2D)this.this$0.m_pnts.get(this.getArcPtName()), ep = end.getPoint(), new Arc2D.Double());
            return arc == null ? new Line2D.Double(sp, ep) : arc;
        }

        @Override
        public double length(Vertex start, Vertex end) {
            Shape shape = this.getShape(start, end);
            if (shape instanceof Arc2D) {
                Arc2D arc = (Arc2D)shape;
                double alfaSweep = Math.abs(arc.getAngleExtent());
                double r = Geo2D.distance(start.getPoint(), new Point2D.Double(arc.getCenterX(), arc.getCenterY()));
                return Math.toRadians(alfaSweep) * r;
            }
            Line2D line = (Line2D)shape;
            return Geo2D.length(line);
        }

        @Override
        public double area(Vertex start, Vertex end) {
            Shape shape = this.getShape(start, end);
            return shape instanceof Arc2D ? Geo2D.area((Arc2D)shape) : Geo2D.area((Line2D)shape);
        }

        @Override
        public void setPrimitiveName(int name) {
            this.m_segmentName = name;
        }

        @Override
        public int getPrimitiveName() {
            return this.m_segmentName;
        }

        @Override
        public void destruct() {
            this.this$0.m_pnts.remove(this.getArcPtName());
            this.m_cp = 0L;
            int name = (Integer)this.this$0.m_prim2name.get(this);
            this.this$0.m_name2prim.remove(name);
            this.this$0.m_prim2name.remove(this);
        }

        @Override
        public void evolve(Vertex start, Vertex end) {
            if (this.m_subVersion == 0) {
                this.m_subVersion = 1;
                Point2D startPoint = start.getPoint();
                Point2D center = (Point2D)this.this$0.m_pnts.get((int)this.m_cp);
                double radius = Geo2D.distance(startPoint, center);
                Vector2D vcs = new Vector2D(center, startPoint);
                double angle = Vector2D.X_UNIT.getAngleCCW(vcs);
                Vector2D vArcPoint = new Vector2D(angle += 0.5 * this.m_alpha).scaleBy(radius);
                center.setLocation(center.getX() + vArcPoint.x, center.getY() + vArcPoint.y);
            }
        }

        public String toString() {
            Point2D cp = (Point2D)this.this$0.m_pnts.get(this.getArcPtName());
            return "Segment.ARCTO:[" + Geo2D.formatCoordinate(cp.getX()) + ", " + Geo2D.formatCoordinate(cp.getY()) + "] ";
        }
    }

    private class CloseSegment
    implements Segment {
        private static final long serialVersionUID = 0L;
        private int m_segmentName;
        final /* synthetic */ Path2D this$0;

        public CloseSegment(Path2D path2D) {
            Path2D path2D2 = path2D;
            long l = path2D2.m_num;
            path2D2.m_num = l + 1L;
            this(path2D, (int)l);
        }

        public CloseSegment(Path2D path2D, int segName) {
            this.this$0 = path2D;
            this.m_segmentName = segName;
            path2D.m_name2prim.put(segName, this);
            path2D.m_prim2name.put(this, segName);
        }

        @Override
        public int getType() {
            return 5;
        }

        @Override
        public int getSegment(Vertex start, Vertex end, double[] crds) {
            return 5;
        }

        @Override
        public void setSegment(Vertex start, Vertex end, double[] crds) {
            start.toCloseVertex(false);
            end.toCloseVertex(true);
        }

        @Override
        public int getPointCount() {
            return 0;
        }

        @Override
        public int getPointName(int index) {
            throw new IllegalArgumentException();
        }

        @Override
        public Point2D getPointOnSegment(Vertex start, Vertex end, Point2D dst) {
            if (dst == null) {
                dst = new Point2D.Double();
            }
            Point2D sp = start.getPoint();
            Point2D ep = end.getPoint();
            dst.setLocation(0.5 * (sp.getX() + ep.getX()), 0.5 * (sp.getY() + ep.getY()));
            return dst;
        }

        @Override
        public Point2D getRepresentativeLocation(Vertex start, Vertex end, Point2D dst) {
            return this.getPointOnSegment(start, end, dst);
        }

        @Override
        public Shape getShape(Vertex start, Vertex end) {
            return new Line2D.Double(start.getPoint(), end.getPoint());
        }

        @Override
        public double length(Vertex start, Vertex end) {
            return Geo2D.distance(start.getPoint(), end.getPoint());
        }

        @Override
        public double area(Vertex start, Vertex end) {
            return Geo2D.area(new Line2D.Double(start.getPoint(), end.getPoint()));
        }

        @Override
        public void setPrimitiveName(int name) {
            this.m_segmentName = name;
        }

        @Override
        public int getPrimitiveName() {
            return this.m_segmentName;
        }

        @Override
        public void destruct() {
            int name = (Integer)this.this$0.m_prim2name.get(this);
            this.this$0.m_name2prim.remove(name);
            this.this$0.m_prim2name.remove(this);
        }

        @Override
        public void evolve(Vertex sp, Vertex ep) {
        }

        public String toString() {
            return "Segment.CLOSE";
        }
    }

    private class CubicSegment
    implements Segment {
        private static final long serialVersionUID = 0L;
        private int m_segmentName;
        private long m_cp1;
        private long m_cp2;
        final /* synthetic */ Path2D this$0;

        public CubicSegment(Path2D path2D, int name1, int name2) {
            Path2D path2D2 = path2D;
            long l = path2D2.m_num;
            path2D2.m_num = l + 1L;
            this(path2D, (int)l, name1, name2);
        }

        public CubicSegment(Path2D path2D, int segName, int name1, int name2) {
            this.this$0 = path2D;
            this.m_cp1 = name1;
            this.m_cp2 = name2;
            this.m_segmentName = segName;
            path2D.m_name2prim.put(segName, this);
            path2D.m_prim2name.put(this, segName);
        }

        @Override
        public int getType() {
            return 3;
        }

        public int getCtrlP1Name() {
            return (int)this.m_cp1;
        }

        public int getCtrlP2Name() {
            return (int)this.m_cp2;
        }

        @Override
        public int getSegment(Vertex start, Vertex end, double[] crds) {
            Point2D p = start.getPoint();
            crds[0] = p.getX();
            crds[1] = p.getY();
            p = (Point2D)this.this$0.m_pnts.get(this.getCtrlP1Name());
            crds[2] = p.getX();
            crds[3] = p.getY();
            p = (Point2D)this.this$0.m_pnts.get(this.getCtrlP2Name());
            crds[4] = p.getX();
            crds[5] = p.getY();
            p = end.getPoint();
            crds[6] = p.getX();
            crds[7] = p.getY();
            return 3;
        }

        @Override
        public void setSegment(Vertex start, Vertex end, double[] crds) {
            start.toCloseVertex(false);
            end.toCloseVertex(false);
            start.setPoint(crds[0], crds[1]);
            Point2D p = (Point2D)this.this$0.m_pnts.get(this.getCtrlP1Name());
            p.setLocation(crds[2], crds[3]);
            p = (Point2D)this.this$0.m_pnts.get(this.getCtrlP2Name());
            p.setLocation(crds[4], crds[5]);
            end.setPoint(crds[6], crds[7]);
        }

        @Override
        public int getPointCount() {
            return 2;
        }

        @Override
        public int getPointName(int index) {
            switch (index) {
                case 0: {
                    return this.getCtrlP1Name();
                }
                case 1: {
                    return this.getCtrlP2Name();
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Point2D getPointOnSegment(Vertex start, Vertex end, Point2D dst) {
            if (dst == null) {
                dst = new Point2D.Double();
            }
            double[] crds = new double[24];
            this.getSegment(start, end, crds);
            CubicCurve2D.subdivide(crds, 0, crds, 8, crds, 16);
            dst.setLocation(crds[14], crds[15]);
            return dst;
        }

        @Override
        public Point2D getRepresentativeLocation(Vertex start, Vertex end, Point2D dst) {
            return this.getPointOnSegment(start, end, dst);
        }

        @Override
        public Shape getShape(Vertex start, Vertex end) {
            Point2D cp1 = (Point2D)this.this$0.m_pnts.get(this.getCtrlP1Name());
            Point2D cp2 = (Point2D)this.this$0.m_pnts.get(this.getCtrlP2Name());
            return new CubicCurve2D.Double(start.getPoint().getX(), start.getPoint().getY(), cp1.getX(), cp1.getY(), cp2.getX(), cp2.getY(), end.getPoint().getX(), end.getPoint().getY());
        }

        @Override
        public double length(Vertex start, Vertex end) {
            return Geo2D.length((CubicCurve2D)this.getShape(start, end));
        }

        @Override
        public double area(Vertex start, Vertex end) {
            return Geo2D.area((CubicCurve2D)this.getShape(start, end));
        }

        @Override
        public void setPrimitiveName(int name) {
            this.m_segmentName = name;
        }

        @Override
        public int getPrimitiveName() {
            return this.m_segmentName;
        }

        @Override
        public void destruct() {
            this.this$0.m_pnts.remove(this.getCtrlP1Name());
            this.m_cp1 = 0L;
            this.this$0.m_pnts.remove(this.getCtrlP2Name());
            this.m_cp2 = 0L;
            int name = (Integer)this.this$0.m_prim2name.get(this);
            this.this$0.m_name2prim.remove(name);
            this.this$0.m_prim2name.remove(this);
        }

        @Override
        public void evolve(Vertex sp, Vertex ep) {
        }

        public String toString() {
            Point2D cp1 = (Point2D)this.this$0.m_pnts.get(this.getCtrlP1Name());
            Point2D cp2 = (Point2D)this.this$0.m_pnts.get(this.getCtrlP2Name());
            return "Segment.CURVETO:[" + Geo2D.formatCoordinate(cp1.getX()) + ", " + Geo2D.formatCoordinate(cp1.getY()) + "] [" + Geo2D.formatCoordinate(cp2.getX()) + ", " + Geo2D.formatCoordinate(cp2.getY()) + "]";
        }
    }

    private class LineSegment
    implements Segment {
        private static final long serialVersionUID = 0L;
        private int m_segmentName;
        final /* synthetic */ Path2D this$0;

        public LineSegment(Path2D path2D) {
            Path2D path2D2 = path2D;
            long l = path2D2.m_num;
            path2D2.m_num = l + 1L;
            this(path2D, (int)l);
        }

        public LineSegment(Path2D path2D, int segName) {
            this.this$0 = path2D;
            this.m_segmentName = segName;
            path2D.m_name2prim.put(segName, this);
            path2D.m_prim2name.put(this, segName);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public int getSegment(Vertex start, Vertex end, double[] crds) {
            Point2D p = start.getPoint();
            crds[0] = p.getX();
            crds[1] = p.getY();
            p = end.getPoint();
            crds[2] = p.getX();
            crds[3] = p.getY();
            return 1;
        }

        @Override
        public void setSegment(Vertex start, Vertex end, double[] crds) {
            start.toCloseVertex(false);
            end.toCloseVertex(false);
            start.setPoint(crds[0], crds[1]);
            end.setPoint(crds[2], crds[3]);
        }

        @Override
        public int getPointCount() {
            return 0;
        }

        @Override
        public int getPointName(int index) {
            throw new IllegalArgumentException();
        }

        @Override
        public Point2D getPointOnSegment(Vertex start, Vertex end, Point2D dst) {
            if (dst == null) {
                dst = new Point2D.Double();
            }
            Point2D sp = start.getPoint();
            Point2D ep = end.getPoint();
            dst.setLocation(0.5 * (sp.getX() + ep.getX()), 0.5 * (sp.getY() + ep.getY()));
            return dst;
        }

        @Override
        public Point2D getRepresentativeLocation(Vertex start, Vertex end, Point2D dst) {
            return this.getPointOnSegment(start, end, dst);
        }

        @Override
        public Shape getShape(Vertex start, Vertex end) {
            return new Line2D.Double(start.getPoint(), end.getPoint());
        }

        @Override
        public double length(Vertex start, Vertex end) {
            return Geo2D.distance(start.getPoint(), end.getPoint());
        }

        @Override
        public double area(Vertex start, Vertex end) {
            return Geo2D.area(new Line2D.Double(start.getPoint(), end.getPoint()));
        }

        @Override
        public void setPrimitiveName(int name) {
            this.m_segmentName = name;
        }

        @Override
        public int getPrimitiveName() {
            return this.m_segmentName;
        }

        @Override
        public void destruct() {
            int name = (Integer)this.this$0.m_prim2name.get(this);
            this.this$0.m_name2prim.remove(name);
            this.this$0.m_prim2name.remove(this);
        }

        @Override
        public void evolve(Vertex sp, Vertex ep) {
        }

        public String toString() {
            return "Segment.LINETO";
        }
    }

    private class MoveSegment
    implements Segment {
        private static final long serialVersionUID = 0L;
        private int m_segmentName;
        final /* synthetic */ Path2D this$0;

        public MoveSegment(Path2D path2D) {
            Path2D path2D2 = path2D;
            long l = path2D2.m_num;
            path2D2.m_num = l + 1L;
            this(path2D, (int)l);
        }

        public MoveSegment(Path2D path2D, int segName) {
            this.this$0 = path2D;
            this.m_segmentName = segName;
            path2D.m_name2prim.put(segName, this);
            path2D.m_prim2name.put(this, segName);
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public int getSegment(Vertex start, Vertex end, double[] crds) {
            Point2D p = start.getPoint();
            crds[0] = p.getX();
            crds[1] = p.getY();
            p = end.getPoint();
            crds[2] = p.getX();
            crds[3] = p.getY();
            return 0;
        }

        @Override
        public void setSegment(Vertex start, Vertex end, double[] crds) {
            start.toCloseVertex(false);
            end.toCloseVertex(false);
            start.setPoint(crds[0], crds[1]);
            end.setPoint(crds[2], crds[3]);
        }

        @Override
        public int getPointCount() {
            return 0;
        }

        @Override
        public int getPointName(int index) {
            throw new IllegalArgumentException();
        }

        @Override
        public Point2D getPointOnSegment(Vertex start, Vertex end, Point2D dst) {
            if (dst == null) {
                dst = new Point2D.Double();
            }
            Point2D sp = start.getPoint();
            Point2D ep = end.getPoint();
            dst.setLocation(0.5 * (sp.getX() + ep.getX()), 0.5 * (sp.getY() + ep.getY()));
            return dst;
        }

        @Override
        public Point2D getRepresentativeLocation(Vertex start, Vertex end, Point2D dst) {
            return this.getPointOnSegment(start, end, dst);
        }

        @Override
        public Shape getShape(Vertex start, Vertex end) {
            return null;
        }

        @Override
        public double length(Vertex start, Vertex end) {
            return 0.0;
        }

        @Override
        public double area(Vertex start, Vertex end) {
            return 0.0;
        }

        @Override
        public void destruct() {
            int name = (Integer)this.this$0.m_prim2name.get(this);
            this.this$0.m_name2prim.remove(name);
            this.this$0.m_prim2name.remove(this);
        }

        @Override
        public void setPrimitiveName(int name) {
            this.m_segmentName = name;
        }

        @Override
        public int getPrimitiveName() {
            return this.m_segmentName;
        }

        @Override
        public void evolve(Vertex sp, Vertex ep) {
        }

        public String toString() {
            return "Segment.MOVETO";
        }
    }

    public class Path2DIterator {
        private int pos = -1;
        private boolean done = false;

        public void next() {
            this.pos += 2;
            if (Path2D.this.m_path.size() <= this.pos) {
                this.done = true;
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public int currentSegment(double[] crds) {
            if (crds == null) {
                crds = new double[6];
            }
            if (this.pos == -1) {
                Point2D pt = ((Vertex)Path2D.this.m_path.get(0)).getPoint();
                crds[0] = pt.getX();
                crds[1] = pt.getY();
                return 0;
            }
            Segment cs = (Segment)Path2D.this.m_path.get(this.pos);
            Point2D pt = ((Vertex)Path2D.this.m_path.get(this.pos + 1)).getPoint();
            switch (cs.getType()) {
                case 0: {
                    crds[0] = pt.getX();
                    crds[1] = pt.getY();
                    return 0;
                }
                case 1: {
                    crds[0] = pt.getX();
                    crds[1] = pt.getY();
                    return 1;
                }
                case 2: {
                    int name = ((QuadSegment)cs).getCtrlPtName();
                    Point2D cp = (Point2D)Path2D.this.m_pnts.get(name);
                    crds[0] = cp.getX();
                    crds[1] = cp.getY();
                    crds[2] = pt.getX();
                    crds[3] = pt.getY();
                    return 2;
                }
                case 3: {
                    int name1 = ((CubicSegment)cs).getCtrlP1Name();
                    int name2 = ((CubicSegment)cs).getCtrlP2Name();
                    Point2D cp1 = (Point2D)Path2D.this.m_pnts.get(name1);
                    Point2D cp2 = (Point2D)Path2D.this.m_pnts.get(name2);
                    crds[0] = cp1.getX();
                    crds[1] = cp1.getY();
                    crds[2] = cp2.getX();
                    crds[3] = cp2.getY();
                    crds[4] = pt.getX();
                    crds[5] = pt.getY();
                    return 3;
                }
                case 4: {
                    int name3 = ((ArcSegment)cs).getArcPtName();
                    Point2D cp3 = (Point2D)Path2D.this.m_pnts.get(name3);
                    crds[0] = cp3.getX();
                    crds[1] = cp3.getY();
                    crds[2] = pt.getX();
                    crds[3] = pt.getY();
                    return 4;
                }
                case 5: {
                    return 5;
                }
            }
            throw new IllegalPathStateException();
        }

        public Point2D getSegmentPoint(Point2D dst) {
            if (this.pos == -1) {
                return null;
            }
            if (dst == null) {
                dst = new Point2D.Double();
            }
            double[] crds = new double[6];
            int segType = this.currentSegment(crds);
            Point2D sp = ((Vertex)Path2D.this.m_path.get(this.pos - 1)).getPoint();
            switch (segType) {
                case 0: {
                    return null;
                }
                case 1: {
                    dst.setLocation(0.5 * (sp.getX() + crds[0]), 0.5 * (sp.getY() + crds[1]));
                    return dst;
                }
                case 2: {
                    dst.setLocation(0.5 * (sp.getX() + crds[2]), 0.5 * (sp.getY() + crds[3]));
                    return dst;
                }
                case 3: {
                    dst.setLocation(0.5 * (sp.getX() + crds[4]), 0.5 * (sp.getY() + crds[5]));
                    return dst;
                }
                case 4: {
                    dst.setLocation(0.5 * (sp.getX() + crds[0]), 0.5 * (sp.getY() + crds[1]));
                    return dst;
                }
                case 5: {
                    return null;
                }
            }
            throw new IllegalPathStateException();
        }
    }

    private static interface Primitive
    extends Serializable {
        public void destruct();

        public void setPrimitiveName(int var1);

        public int getPrimitiveName();
    }

    private class QuadSegment
    implements Segment {
        private static final long serialVersionUID = 0L;
        private long m_cp;
        private int m_segmentName;
        final /* synthetic */ Path2D this$0;

        public QuadSegment(Path2D path2D, int name) {
            Path2D path2D2 = path2D;
            long l = path2D2.m_num;
            path2D2.m_num = l + 1L;
            this(path2D, (int)l, name);
        }

        public QuadSegment(Path2D path2D, int segName, int name) {
            this.this$0 = path2D;
            this.m_cp = name;
            this.m_segmentName = segName;
            path2D.m_name2prim.put(segName, this);
            path2D.m_prim2name.put(this, segName);
        }

        @Override
        public int getType() {
            return 2;
        }

        public int getCtrlPtName() {
            return (int)this.m_cp;
        }

        @Override
        public int getSegment(Vertex start, Vertex end, double[] crds) {
            Point2D p = start.getPoint();
            crds[0] = p.getX();
            crds[1] = p.getY();
            p = (Point2D)this.this$0.m_pnts.get(this.getCtrlPtName());
            crds[2] = p.getX();
            crds[3] = p.getY();
            p = end.getPoint();
            crds[4] = p.getX();
            crds[5] = p.getY();
            return 2;
        }

        @Override
        public void setSegment(Vertex start, Vertex end, double[] crds) {
            start.toCloseVertex(false);
            end.toCloseVertex(false);
            start.setPoint(crds[0], crds[1]);
            Point2D p = (Point2D)this.this$0.m_pnts.get(this.getCtrlPtName());
            p.setLocation(crds[2], crds[3]);
            end.setPoint(crds[4], crds[5]);
        }

        @Override
        public int getPointCount() {
            return 1;
        }

        @Override
        public int getPointName(int index) {
            return this.getCtrlPtName();
        }

        @Override
        public Point2D getPointOnSegment(Vertex start, Vertex end, Point2D dst) {
            if (dst == null) {
                dst = new Point2D.Double();
            }
            double[] crds = new double[16];
            this.getSegment(start, end, crds);
            QuadCurve2D.subdivide(crds, 0, crds, 6, crds, 10);
            dst.setLocation(crds[10], crds[11]);
            return dst;
        }

        @Override
        public Point2D getRepresentativeLocation(Vertex start, Vertex end, Point2D dst) {
            return this.getPointOnSegment(start, end, dst);
        }

        @Override
        public Shape getShape(Vertex start, Vertex end) {
            Point2D p = (Point2D)this.this$0.m_pnts.get(this.getCtrlPtName());
            return new QuadCurve2D.Double(start.getPoint().getX(), start.getPoint().getY(), p.getX(), p.getY(), end.getPoint().getX(), end.getPoint().getY());
        }

        @Override
        public double length(Vertex start, Vertex end) {
            return Geo2D.length((QuadCurve2D)this.getShape(start, end));
        }

        @Override
        public double area(Vertex start, Vertex end) {
            return Geo2D.area((QuadCurve2D)this.getShape(start, end));
        }

        @Override
        public void setPrimitiveName(int name) {
            this.m_segmentName = name;
        }

        @Override
        public int getPrimitiveName() {
            return this.m_segmentName;
        }

        @Override
        public void destruct() {
            this.this$0.m_pnts.remove(this.getCtrlPtName());
            this.m_cp = 0L;
            int name = (Integer)this.this$0.m_prim2name.get(this);
            this.this$0.m_name2prim.remove(name);
            this.this$0.m_prim2name.remove(this);
        }

        @Override
        public void evolve(Vertex sp, Vertex ep) {
        }

        public String toString() {
            Point2D p = (Point2D)this.this$0.m_pnts.get(this.getCtrlPtName());
            return "Segment.QUADTO:[" + Geo2D.formatCoordinate(p.getX()) + ", " + Geo2D.formatCoordinate(p.getY()) + "]";
        }
    }

    public static interface Segment
    extends Primitive {
        public int getType();

        public int getSegment(Vertex var1, Vertex var2, double[] var3);

        public void setSegment(Vertex var1, Vertex var2, double[] var3);

        public int getPointCount();

        public int getPointName(int var1);

        public Point2D getPointOnSegment(Vertex var1, Vertex var2, Point2D var3);

        public Point2D getRepresentativeLocation(Vertex var1, Vertex var2, Point2D var3);

        public Shape getShape(Vertex var1, Vertex var2);

        public double length(Vertex var1, Vertex var2);

        public double area(Vertex var1, Vertex var2);

        public void evolve(Vertex var1, Vertex var2);
    }

    private class Vertex
    implements Primitive {
        private static final long serialVersionUID = 0L;
        private long m_name;
        private int m_vertexName;

        public Vertex(int name) {
            if (name < -1) {
                throw new IllegalArgumentException();
            }
            this.m_name = name;
            this.m_vertexName = (int)Path2D.this.m_num;
            Path2D.this.m_name2prim.put((int)Path2D.this.m_num, this);
            Map map = Path2D.this.m_prim2name;
            Path2D path2D2 = Path2D.this;
            long l = path2D2.m_num;
            path2D2.m_num = l + 1L;
            map.put(this, (int)l);
        }

        public Point2D getPoint() {
            Point2D pnt = (Point2D)Path2D.this.m_pnts.get(this.getPointName());
            return pnt;
        }

        public void setPoint(Point2D pnt) {
            this.setPoint(pnt.getX(), pnt.getY());
        }

        public void setPoint(double x, double y) {
            if (!this.isCloseVertex()) {
                Point2D p = (Point2D)Path2D.this.m_pnts.get(this.getPointName());
                p.setLocation(x, y);
            }
        }

        public void setPointName(int name) {
            if (name < -1) {
                throw new IllegalArgumentException();
            }
            this.m_name = name;
        }

        public int getPointName() {
            if (this.isCloseVertex()) {
                Vertex vtx = Path2D.this._startOfLoop(this);
                return (int)vtx.m_name;
            }
            return (int)this.m_name;
        }

        @Override
        public void setPrimitiveName(int name) {
            this.m_vertexName = name;
        }

        @Override
        public int getPrimitiveName() {
            return this.m_vertexName;
        }

        @Override
        public void destruct() {
            if (!this.isCloseVertex()) {
                Path2D.this.m_pnts.remove(this.getPointName());
            }
            this.m_name = 0L;
            int name = (Integer)Path2D.this.m_prim2name.get(this);
            Path2D.this.m_name2prim.remove(name);
            Path2D.this.m_prim2name.remove(this);
        }

        public boolean isCloseVertex() {
            return this.m_name == -1L;
        }

        public void toCloseVertex(boolean close) {
            if (close) {
                if (this.m_name != -1L) {
                    Path2D.this.m_pnts.remove(this.m_name);
                    this.m_name = -1L;
                }
            } else if (this.m_name == -1L) {
                Point2D p = this.getPoint();
                if (p == null) {
                    p = new Point2D.Double();
                }
                this.m_name = Path2D.this.addPoint(p);
            }
        }

        public String toString() {
            Point2D pnt = this.getPoint();
            if (pnt == null) {
                return String.valueOf(this.isCloseVertex() ? "Close Vertex:[" : "Vertex:[") + "null]";
            }
            return String.valueOf(this.isCloseVertex() ? "Close:[" : "Vertex:[") + Geo2D.formatCoordinate(pnt.getX()) + ", " + Geo2D.formatCoordinate(pnt.getY()) + "]";
        }
    }
}

