/*
 * Decompiled with CFR 0.152.
 */
package cib.util.geo;

import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;

public class RewindablePathIterator
implements PathIterator {
    private List<_Segment> m_segments = new ArrayList<_Segment>();
    private int m_currentIndex = 0;
    private int m_windingRule;

    public RewindablePathIterator(PathIterator pit) {
        this.m_windingRule = pit.getWindingRule();
        double[] crds = new double[6];
        while (!pit.isDone()) {
            int type = pit.currentSegment(crds);
            switch (type) {
                case 0: 
                case 1: {
                    double[] _crds = new double[]{crds[0], crds[1]};
                    this.m_segments.add(new _Segment(type, _crds));
                    break;
                }
                case 2: {
                    double[] _crds = new double[4];
                    int i = 0;
                    while (i < 4) {
                        _crds[i] = crds[i];
                        ++i;
                    }
                    this.m_segments.add(new _Segment(type, _crds));
                    break;
                }
                case 3: {
                    double[] _crds = new double[6];
                    int i = 0;
                    while (i < 6) {
                        _crds[i] = crds[i];
                        ++i;
                    }
                    this.m_segments.add(new _Segment(type, _crds));
                    break;
                }
                case 4: {
                    this.m_segments.add(new _Segment(type, new double[0]));
                    break;
                }
                default: {
                    throw new Error("Unexpected segment type");
                }
            }
            pit.next();
        }
    }

    public void rewind() {
        this.m_currentIndex = 0;
    }

    @Override
    public int currentSegment(double[] coords) {
        _Segment _seg = this.m_segments.get(this.m_currentIndex);
        int i = 0;
        while (i < _seg.m_crds.length) {
            coords[i] = _seg.m_crds[i];
            ++i;
        }
        return _seg.m_seg;
    }

    @Override
    public int currentSegment(float[] coords) {
        _Segment _seg = this.m_segments.get(this.m_currentIndex);
        int i = 0;
        while (i < _seg.m_crds.length) {
            coords[i] = (float)_seg.m_crds[i];
            ++i;
        }
        return _seg.m_seg;
    }

    @Override
    public int getWindingRule() {
        return this.m_windingRule;
    }

    @Override
    public boolean isDone() {
        return this.m_currentIndex >= this.m_segments.size();
    }

    @Override
    public void next() {
        if (!this.isDone()) {
            ++this.m_currentIndex;
        }
    }

    private static class _Segment {
        private int m_seg;
        private double[] m_crds;

        private _Segment(int seg, double[] crds) {
            this.m_seg = seg;
            this.m_crds = crds;
        }
    }
}

