/*
 * Decompiled with CFR 0.152.
 */
package cib.util.msg;

import cib.util.Dbg;
import cib.util.msg.MsgHandler;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.Set;

public class ServerMsgHandler
extends MsgHandler {
    private static ServerSocket s_serverSocket = null;
    private Socket m_clientSocket = null;
    private static int s_clientId = 0;
    private int m_clientId = 0;

    public static synchronized ServerMsgHandler getClientConnection(int port) {
        try {
            if (s_serverSocket == null) {
                s_serverSocket = new ServerSocket(port);
            }
            Socket clientSocket = s_serverSocket.accept();
            OutputStream out = clientSocket.getOutputStream();
            InputStream in = clientSocket.getInputStream();
            ServerMsgHandler smh = new ServerMsgHandler(clientSocket, in, out);
            DataOutputStream dout = new DataOutputStream(out);
            dout.writeInt(smh.getClientId());
            smh.start();
            return smh;
        }
        catch (IOException e) {
            Dbg.println("ServerMsgHandler.getClientConnection(): " + e);
            return null;
        }
    }

    private ServerMsgHandler(Socket cs, InputStream in, OutputStream out) {
        super(in, out);
        this.m_clientSocket = cs;
        this.m_clientId = ++s_clientId;
    }

    @Override
    public void close() {
        super.close();
        if (this.m_clientSocket != null) {
            try {
                this.m_clientSocket.close();
                this.m_clientSocket = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getClientId() {
        return this.m_clientId;
    }

    public String getClientName() {
        InetAddress addr = this.m_clientSocket.getInetAddress();
        return addr.getHostName();
    }

    public static String[] getAllClientNames() {
        Set<MsgHandler> clients = ServerMsgHandler.getAllMsgHandlers();
        int nClients = clients.size();
        String[] clientNames = new String[nClients];
        Iterator<MsgHandler> it = clients.iterator();
        int iClient = 0;
        while (it.hasNext()) {
            ServerMsgHandler smh = (ServerMsgHandler)it.next();
            clientNames[iClient++] = smh.getClientName();
        }
        return clientNames;
    }
}

