/*
 * Decompiled with CFR 0.152.
 */
package cib.util.update;

import cib.util.coll.CollUtilities;
import cib.util.coll.ReverseAccessMap;
import cib.util.update.Graph;
import cib.util.update.GraphException;
import cib.util.update.Node;
import cib.util.update.Updatable;
import cib.util.update.UpdatableGraph;
import cib.util.update.Update;
import cib.util.update.UpdateInterface;
import cib.util.update._UpdatableGraph;
import cib.util.update._Update;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Deprecated
public class UpdateInterfaceInstance
implements UpdateInterface,
Serializable {
    private static final long serialVersionUID = 0L;
    private ReverseAccessMap<Updatable, Object> m_pairs = CollUtilities.bijectiveReverseAccessMap(new HashMap());
    private UpdatableGraph m_updatableGraph = new _UpdatableGraph(this);
    private transient Update m_currentUpdate = null;

    @Override
    public boolean addNode(Updatable u) {
        if (!this.m_pairs.containsKey(u)) {
            Node n = new Node();
            this.m_pairs.put(u, n);
            this.m_updatableGraph.addNode(n);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeNode(Updatable u) {
        if (this.m_pairs.containsKey(u)) {
            Node n = (Node)this.m_pairs.get(u);
            this.m_updatableGraph.removeNode(n);
            this.m_pairs.remove(u);
            return true;
        }
        return false;
    }

    @Override
    public boolean addEdge(Updatable src, Updatable dest) throws GraphException {
        if (this.m_pairs.containsKey(src) && this.m_pairs.containsKey(dest)) {
            Node _src = (Node)this.m_pairs.get(src);
            Node _dest = (Node)this.m_pairs.get(dest);
            return this.m_updatableGraph.addEdge(_src, _dest);
        }
        return false;
    }

    @Override
    public boolean removeEdge(Updatable src, Updatable dest) {
        if (this.m_pairs.containsKey(src) && this.m_pairs.containsKey(dest)) {
            Node _src = (Node)this.m_pairs.get(src);
            Node _dest = (Node)this.m_pairs.get(dest);
            return this.m_updatableGraph.removeEdge(_src, _dest);
        }
        return false;
    }

    @Override
    public void wasChanged(Updatable u) {
        if (this.m_pairs.containsKey(u)) {
            Node n = (Node)this.m_pairs.get(u);
            this.m_updatableGraph.wasChanged(n);
        }
    }

    @Override
    public Updatable getUpdatable(Node node) {
        return this.m_pairs.getKey(node);
    }

    @Override
    public Node getNode(Updatable u) {
        return (Node)this.m_pairs.get(u);
    }

    public Set<Updatable> getGraphUpdatables() {
        Set<Node> nodes = this.m_updatableGraph.getNodeSet();
        HashSet<Updatable> updatables = new HashSet<Updatable>();
        Iterator<Node> it = nodes.iterator();
        while (it.hasNext()) {
            updatables.add(this.m_pairs.getKey(it.next()));
        }
        return updatables;
    }

    public Set<Updatable> getSuccessors(Updatable u) {
        HashSet<Updatable> edges = new HashSet<Updatable>();
        if (this.m_pairs.containsKey(u)) {
            Node node = (Node)this.m_pairs.get(u);
            Node[] nodes = this.m_updatableGraph.getEdges(node);
            int i = 0;
            while (i < nodes.length) {
                edges.add(this.m_pairs.getKey(nodes[i]));
                ++i;
            }
        }
        return edges;
    }

    @Override
    public void update(Object context) {
        _Update u = new _Update(this.m_updatableGraph);
        this.m_currentUpdate = u;
        this.m_updatableGraph.setUpdate(u);
        Iterator<Node> it = this.m_updatableGraph.getNodeSet().iterator();
        while (it.hasNext()) {
            u.addDestNode(it.next());
        }
        this.m_updatableGraph.update(context);
        this.m_currentUpdate = null;
    }

    @Override
    public void update(Iterator it, Object context) {
        _Update u = new _Update(this.m_updatableGraph);
        this.m_currentUpdate = u;
        this.m_updatableGraph.setUpdate(u);
        while (it.hasNext()) {
            u.addDestNode((Node)this.m_pairs.get(it.next()));
        }
        this.m_updatableGraph.update(context);
        this.m_currentUpdate = null;
    }

    protected boolean stillToUpdate(Updatable u) {
        if (this.m_currentUpdate != null) {
            Node n = (Node)this.m_pairs.get(u);
            return this.m_currentUpdate.stillToUpdate(n);
        }
        throw new IllegalStateException("No update in progress!");
    }

    protected boolean alreadyUpdated(Updatable u) {
        if (this.m_currentUpdate != null) {
            Node n = (Node)this.m_pairs.get(u);
            return this.m_currentUpdate.alreadyUpdated(n);
        }
        throw new IllegalStateException("No update in progress!");
    }

    public Set<Updatable> getPredecessors(Updatable u) {
        HashSet<Updatable> p = new HashSet<Updatable>();
        if (this.m_pairs.containsKey(u)) {
            boolean[][] l = this.m_updatableGraph.getLink();
            List<Node> nodes = Arrays.asList(this.m_updatableGraph.getNodes());
            Node n = (Node)this.m_pairs.get(u);
            int index = nodes.indexOf(n);
            int i = 0;
            while (i < l.length) {
                if (l[i][index]) {
                    Node node = nodes.get(i);
                    p.add(this.m_pairs.getKey(node));
                }
                ++i;
            }
        }
        return p;
    }

    public void printPairs() {
        String s = "---Pairs---\n";
        Set keys = this.m_pairs.keySet();
        for (Object key : keys) {
            s = String.valueOf(s) + key.toString() + " <--> " + this.m_pairs.get(key).toString() + "\n";
        }
        System.out.println(String.valueOf(s) + "---Pairs---\n");
    }

    public void printGraph() {
        String s = "---Graph---\n";
        Graph g = this.m_updatableGraph.getLinkGraph();
        Node[] n = g.getNodes();
        int i = 0;
        while (i < n.length) {
            s = String.valueOf(s) + n[i] + ": ";
            Node[] e = g.getEdges(n[i]);
            int j = 0;
            while (j < e.length) {
                s = String.valueOf(s) + e[j] + ", ";
                ++j;
            }
            s = String.valueOf(s) + "\n";
            ++i;
        }
        System.out.println(String.valueOf(s) + "---Graph---\n");
    }
}

