/*
 * Decompiled with CFR 0.152.
 */
package cib.util.view;

import cib.util.view.ScrollableJPopupMenu;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class SingleRowLayout
implements LayoutManager {
    private boolean m_sizeUnknown = true;
    private int m_gap;
    private int m_minWidth = 0;
    private int m_minHeight = 0;
    private int m_preferredWidth = 0;
    private int m_preferredHeight = 0;
    private JButton m_continuationButton;
    private ScrollableJPopupMenu m_popupMenu = new ScrollableJPopupMenu();
    private ActionListener m_popupMenuItemListener = null;
    private Map<JMenuItem, Component> m_menuItemToComponentMap = new HashMap<JMenuItem, Component>();

    public SingleRowLayout() {
        this(new JButton("\u00bb"), 5);
    }

    public SingleRowLayout(JButton continuationButton, int gap) {
        this.m_continuationButton = continuationButton;
        this.m_gap = gap;
        this.m_continuationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SingleRowLayout.this.m_popupMenu.isVisible()) {
                    SingleRowLayout.this.m_popupMenu.show(SingleRowLayout.this.m_continuationButton, 0, SingleRowLayout.this.m_continuationButton.getHeight());
                } else {
                    SingleRowLayout.this.m_popupMenu.setVisible(false);
                }
            }
        });
        this.m_popupMenuItemListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                Component c = (Component)SingleRowLayout.this.m_menuItemToComponentMap.get(menuItem);
                if (c instanceof JPanel) {
                    c = ((JPanel)c).getComponent(0);
                }
                if (c instanceof JComboBox) {
                    JComboBox cb = (JComboBox)c;
                    Point originalLocation = cb.getLocation();
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    Point p = cb.getLocationOnScreen();
                    if (p.x >= screenSize.width) {
                        int dx = p.x - screenSize.width;
                        cb.setLocation(cb.getX() - dx - 1, cb.getY());
                    }
                    if (p.y >= screenSize.height) {
                        int dy = p.y - screenSize.height;
                        cb.setLocation(cb.getX(), cb.getY() - dy - 1);
                    }
                    cb.showPopup();
                    cb.setLocation(originalLocation);
                } else {
                    EventListener[] ls = c.getListeners(ActionListener.class);
                    int i = 0;
                    while (i < ls.length) {
                        ActionListener al = (ActionListener)ls[i];
                        al.actionPerformed(new ActionEvent(c, 1001, ""));
                        ++i;
                    }
                }
                SingleRowLayout.this.m_popupMenu.setVisible(false);
            }
        };
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    private void setSizes(Container parent) {
        int nComps = parent.getComponentCount();
        this.m_minWidth = nComps == 0 ? 0 : this.m_continuationButton.getWidth();
        this.m_minHeight = nComps == 0 ? 0 : this.m_continuationButton.getHeight();
        this.m_preferredWidth = nComps * this.m_gap;
        this.m_preferredHeight = 0;
        int i = 0;
        while (i < nComps) {
            Component c = parent.getComponent(i);
            if (c.isVisible()) {
                Dimension d = c.getPreferredSize();
                this.m_preferredWidth += d.width;
                if (d.height > this.m_preferredHeight) {
                    this.m_preferredHeight = d.height;
                }
            }
            ++i;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        this.setSizes(parent);
        Insets insets = parent.getInsets();
        dim.width = this.m_preferredWidth + insets.left + insets.right;
        dim.height = this.m_preferredHeight + insets.top + insets.bottom;
        this.m_sizeUnknown = false;
        return dim;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        this.setSizes(parent);
        Insets insets = parent.getInsets();
        dim.width = this.m_minWidth + insets.left + insets.right;
        dim.height = this.m_minHeight + insets.top + insets.bottom;
        this.m_sizeUnknown = false;
        return dim;
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int maxWidth = parent.getWidth() - (insets.left + insets.right);
        int maxHeight = parent.getHeight() - (insets.top + insets.bottom);
        int x = insets.left + this.m_gap;
        int y = insets.top;
        if (this.m_sizeUnknown) {
            this.setSizes(parent);
        }
        parent.remove(this.m_continuationButton);
        if (this.m_preferredWidth < maxWidth) {
            int i = 0;
            while (i < parent.getComponentCount()) {
                Component c = parent.getComponent(i);
                if (c.isVisible()) {
                    Dimension d = c.getPreferredSize();
                    c.setBounds(x, y, d.width, d.height);
                    x += d.width + this.m_gap;
                }
                ++i;
            }
        } else {
            this.m_popupMenu.removeAll();
            this.m_menuItemToComponentMap.clear();
            int _maxWidth = maxWidth - this.m_continuationButton.getWidth() - 10 - this.m_gap;
            int i = 0;
            while (i < parent.getComponentCount()) {
                Component c = parent.getComponent(i);
                if (c.isVisible()) {
                    Dimension d = c.getPreferredSize();
                    if (x + d.width > _maxWidth) {
                        c.setBounds(maxWidth, maxHeight, d.width, d.height);
                        if (c instanceof JLabel) {
                            this.m_popupMenu.addSeparator();
                        } else {
                            String text = c instanceof AbstractButton ? ((AbstractButton)c).getText() : c.getName();
                            JMenuItem item = new JMenuItem(text);
                            item.addActionListener(this.m_popupMenuItemListener);
                            this.m_popupMenu.add(item);
                            this.m_menuItemToComponentMap.put(item, c);
                        }
                    } else {
                        c.setBounds(x, y, d.width, d.height);
                    }
                    x += d.width + this.m_gap;
                }
                ++i;
            }
            Dimension d = this.m_continuationButton.getPreferredSize();
            this.m_continuationButton.setBounds(maxWidth - d.width, y, d.width, d.height);
            parent.add(this.m_continuationButton);
        }
    }
}

