/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.diylc.appframework.images.IconLoader;

public class DoubleArrayTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private static final Format format = new DecimalFormat("0.#####");
    public static final String VALUE_PROPERTY = "DoubleValue";
    private Double[] value;
    private JLabel errorLabel;
    private boolean ignoreChanges = false;

    public DoubleArrayTextField(Double[] value) {
        this();
        this.setValue(value);
    }

    public DoubleArrayTextField() {
        this.setLayout(new BorderLayout());
        this.errorLabel = new JLabel(IconLoader.Warning.getIcon());
        this.errorLabel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.add((Component)this.errorLabel, "East");
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                DoubleArrayTextField.this.textChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DoubleArrayTextField.this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DoubleArrayTextField.this.textChanged();
            }
        });
    }

    public Double[] getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Double[] value) {
        this.firePropertyChange(VALUE_PROPERTY, this.value, value);
        this.value = value;
        this.ignoreChanges = true;
        this.errorLabel.setVisible(value == null);
        try {
            StringBuilder b = new StringBuilder();
            boolean first = true;
            for (Double v : value) {
                if (first) {
                    first = false;
                } else {
                    b.append(" / ");
                }
                b.append(v == null ? "" : format.format(v));
            }
            this.setText(value == null ? "" : b.toString());
        }
        finally {
            this.ignoreChanges = false;
        }
    }

    private void textChanged() {
        if (!this.ignoreChanges) {
            try {
                String part;
                int index = this.getText().indexOf("/");
                int start = 0;
                ArrayList<Double> items = new ArrayList<Double>();
                while (index >= 0) {
                    part = this.getText().substring(start, index).trim();
                    items.add(this.parse(part));
                    start = index + 1;
                    index = this.getText().indexOf("/", index + 1);
                }
                part = this.getText().substring(start).trim();
                items.add(this.parse(part));
                Double[] newValue = items.toArray(new Double[0]);
                this.firePropertyChange(VALUE_PROPERTY, this.value, newValue);
                this.value = newValue;
                this.errorLabel.setVisible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.value = null;
                this.errorLabel.setVisible(true);
            }
        }
    }

    private Double parse(String part) throws ParseException {
        if (part.isEmpty()) {
            return null;
        }
        Object parsed = format.parseObject(part);
        if (parsed instanceof Long) {
            return ((Long)parsed).doubleValue();
        }
        if (parsed instanceof Integer) {
            return ((Integer)parsed).doubleValue();
        }
        if (parsed instanceof Double) {
            return (Double)parsed;
        }
        if (parsed instanceof Float) {
            return ((Float)parsed).doubleValue();
        }
        throw new RuntimeException("Unrecognized data type: " + parsed.getClass().getName());
    }
}

