/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class TextDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JEditorPane htmlLabel;
    private String htmlText;

    public TextDialog(JComponent owner, String htmlText, String title, Dimension preferredSize) {
        super(SwingUtilities.getWindowAncestor(owner));
        this.htmlText = htmlText;
        this.setTitle(title);
        this.setModal(true);
        JPanel holderPanel = new JPanel();
        holderPanel.setLayout(new BorderLayout());
        holderPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        final JScrollPane scrollPane = new JScrollPane(this.getHtmlLabel());
        holderPanel.add((Component)scrollPane, "Center");
        holderPanel.add((Component)this.createButtonPanel(), "South");
        this.setContentPane(holderPanel);
        this.setPreferredSize(preferredSize == null ? new Dimension(480, 400) : preferredSize);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                scrollPane.getVerticalScrollBar().setValue(0);
            }
        });
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        JButton cancelButton = new JButton("Close");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    public JEditorPane getHtmlLabel() {
        if (this.htmlLabel == null) {
            this.htmlLabel = new JEditorPane();
            this.htmlLabel.setEditable(false);
            this.htmlLabel.setContentType("text/html");
            this.htmlLabel.setText(this.htmlText);
            this.htmlLabel.setCursor(Cursor.getPredefinedCursor(2));
            this.htmlLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        }
        return this.htmlLabel;
    }
}

