/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.boards;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.boards.AbstractBoard;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;

@ComponentDescriptor(name="Blank Board", category="Boards", author="Branislav Stojkovic", zOrder=2.0, instanceNamePrefix="Board", description="Blank circuit board", bomPolicy=BomPolicy.SHOW_ONLY_TYPE_NAME, autoEdit=false, transformer=SimpleComponentTransformer.class)
public class BlankBoard
extends AbstractBoard {
    private static final long serialVersionUID = 1L;
    private Type type = Type.SQUARE;

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int factor = 32 / width;
        g2d.setColor(BOARD_COLOR);
        g2d.fillRect(2 / factor, 2 / factor, width - 4 / factor, height - 4 / factor);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRect(2 / factor, 2 / factor, width - 4 / factor, height - 4 / factor);
    }

    @Override
    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Shape clip = g2d.getClip();
        if (this.checkPointsClipped(clip) && !clip.contains(this.firstPoint.x, this.secondPoint.y) && !clip.contains(this.secondPoint.x, this.firstPoint.y)) {
            return;
        }
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        if (componentState != ComponentState.DRAGGING) {
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            g2d.setColor(this.boardColor);
            if (this.getType() == Type.SQUARE) {
                g2d.fillRect(this.firstPoint.x, this.firstPoint.y, this.secondPoint.x - this.firstPoint.x, this.secondPoint.y - this.firstPoint.y);
            } else {
                g2d.fillOval(this.firstPoint.x, this.firstPoint.y, this.secondPoint.x - this.firstPoint.x, this.secondPoint.y - this.firstPoint.y);
            }
            g2d.setComposite(oldComposite);
        }
        drawingObserver.stopTracking();
        g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor);
        if (this.getType() == Type.SQUARE) {
            g2d.drawRect(this.firstPoint.x, this.firstPoint.y, this.secondPoint.x - this.firstPoint.x, this.secondPoint.y - this.firstPoint.y);
        } else {
            g2d.drawOval(this.firstPoint.x, this.firstPoint.y, this.secondPoint.x - this.firstPoint.x, this.secondPoint.y - this.firstPoint.y);
        }
    }

    @Override
    public AbstractBoard.CoordinateType getxType() {
        return super.getxType();
    }

    @Override
    public AbstractBoard.CoordinateDisplay getCoordinateDisplay() {
        return super.getCoordinateDisplay();
    }

    @Override
    public AbstractBoard.CoordinateType getyType() {
        return super.getyType();
    }

    @Override
    public Color getCoordinateColor() {
        return super.getCoordinateColor();
    }

    @EditableProperty(name="Shape")
    public Type getType() {
        if (this.type == null) {
            this.type = Type.SQUARE;
        }
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getControlPointNodeName(int index) {
        return null;
    }

    static enum Type {
        ROUND,
        SQUARE;


        public String toString() {
            return this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
        }
    }
}

