/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.guitar;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.awt.StringUtils;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.Orientation;
import org.diylc.common.OrientationHV;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

public abstract class AbstractGuitarPickup
extends AbstractTransparentComponent<String> {
    private static final long serialVersionUID = 1L;
    protected static Size POINT_SPACING = new Size(Double.valueOf(0.1), SizeUnit.in);
    protected static final int TERMINAL_FONT_SIZE = 11;
    protected String value = "";
    protected Orientation orientation = Orientation.DEFAULT;
    protected transient Shape[] body;
    protected Point controlPoint = new Point(0, 0);
    protected Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    protected Polarity polarity = Polarity.North;
    protected Color labelColor;

    public AbstractGuitarPickup() {
        this.updateControlPoints();
    }

    protected void drawlTerminalLabels(Graphics2D g2d, Color color, Project project) {
        Point[] points = this.getControlPoints();
        g2d.setColor(color);
        g2d.setFont(project.getFont().deriveFont(11.0f));
        int dx = 0;
        int dy = 0;
        switch (this.orientation) {
            case DEFAULT: {
                dx = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 0 : 8;
                dy = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? -11 : 0;
                break;
            }
            case _90: {
                dx = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 11 : 0;
                dy = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 0 : 8;
                break;
            }
            case _180: {
                dx = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 0 : -8;
                dy = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 11 : 0;
                break;
            }
            case _270: {
                dx = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? -11 : 0;
                dy = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 0 : -8;
            }
        }
        StringUtils.drawCenteredText(g2d, "N", (points[0].x + points[1].x) / 2 + dx, (points[0].y + points[1].y) / 2 + dy, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        StringUtils.drawCenteredText(g2d, "S", (points[2].x + points[3].x) / 2 + dx, (points[2].y + points[3].y) / 2 + dy, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
    }

    protected void drawMainLabel(Graphics2D g2d, Project project, boolean outlineMode, ComponentState componentState) {
        Color finalLabelColor;
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor();
        } else {
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : this.getLabelColor();
        }
        g2d.setColor(finalLabelColor);
        g2d.setFont(project.getFont().deriveFont(1));
        Rectangle bounds = this.getBody()[0].getBounds();
        AffineTransform originalTx = g2d.getTransform();
        g2d.translate(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        if (this.orientation == Orientation._90) {
            g2d.rotate(1.5707963267948966);
        } else if (this.orientation == Orientation._270) {
            g2d.rotate(-1.5707963267948966);
        }
        g2d.translate(0, this.getMainLabelYOffset());
        StringUtils.drawCenteredText(g2d, this.getName(), 0, 0, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        g2d.setTransform(originalTx);
    }

    protected abstract Shape[] getBody();

    public abstract boolean isHumbucker();

    protected int getMainLabelYOffset() {
        return 0;
    }

    @EditableProperty(name="Model")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.body = null;
        this.updateControlPoints();
    }

    protected Point[] getControlPoints() {
        if (this.controlPoints == null) {
            this.controlPoints = new Point[]{this.controlPoint, new Point(this.controlPoint.x, this.controlPoint.y), new Point(this.controlPoint.x, this.controlPoint.y), new Point(this.controlPoint.x, this.controlPoint.y)};
            this.updateControlPoints();
        }
        return this.controlPoints;
    }

    public int getControlPointCount() {
        return this.getControlPoints().length;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.ALWAYS;
    }

    public Point getControlPoint(int index) {
        return this.getControlPoints()[index];
    }

    public void setControlPoint(Point point, int index) {
        this.getControlPoints()[index].setLocation(point);
        this.body = null;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }

    @EditableProperty
    public Polarity getPolarity() {
        if (this.polarity == null) {
            this.polarity = Polarity.North;
        }
        return this.polarity;
    }

    public void setPolarity(Polarity polarity) {
        this.polarity = polarity;
        this.body = null;
    }

    @EditableProperty(name="Label")
    public Color getLabelColor() {
        if (this.labelColor == null) {
            this.labelColor = LABEL_COLOR;
        }
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    protected abstract OrientationHV getControlPointDirection();

    protected void updateControlPoints() {
        int dy;
        Point[] points = this.getControlPoints();
        int pointSpacing = (int)POINT_SPACING.convertToPixels();
        int dx = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 1 : 0;
        int n = dy = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 0 : 1;
        if (this.orientation != Orientation.DEFAULT) {
            switch (this.orientation) {
                case _90: {
                    dx = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 0 : -1;
                    dy = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? -1 : 0;
                    break;
                }
                case _180: {
                    dx = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? -1 : 0;
                    dy = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 0 : -1;
                    break;
                }
                case _270: {
                    dx = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 0 : 1;
                    dy = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 1 : 0;
                }
            }
        }
        points[1].setLocation(points[0].x + dx * pointSpacing, points[0].y + dy * pointSpacing);
        points[2].setLocation(points[0].x + 2 * dx * pointSpacing, points[0].y + 2 * dy * pointSpacing);
        points[3].setLocation(points[0].x + 3 * dx * pointSpacing, points[0].y + 3 * dy * pointSpacing);
    }

    public static enum Polarity {
        North,
        South,
        Humbucking;

    }
}

