/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.misc;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import org.diylc.common.ObjectCache;
import org.diylc.components.AbstractComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Ground", author="Branislav Stojkovic", category="Schematic Symbols", instanceNamePrefix="GND", description="Ground schematic symbol", zOrder=4.0, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false)
public class GroundSymbol
extends AbstractComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Color COLOR = Color.black;
    public static Size SIZE = new Size(Double.valueOf(0.15), SizeUnit.in);
    private Point point = new Point(0, 0);
    private Color color = COLOR;
    private Size size = SIZE;
    private GroundSymbolType type = GroundSymbolType.DEFAULT;

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        int sizePx = (int)this.size.convertToPixels();
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.setColor(this.color);
        int x = this.point.x;
        int y = this.point.y;
        g2d.drawLine(x, y, x, y + sizePx / 6);
        if (this.type == GroundSymbolType.DEFAULT) {
            int delta = sizePx / 7;
            for (int i = 0; i < 5; ++i) {
                g2d.drawLine(x - sizePx / 2 + delta * i, y + sizePx / 6 * (i + 1), x + sizePx / 2 - delta * i, y + sizePx / 6 * (i + 1));
            }
        } else {
            Polygon poly = new Polygon(new int[]{x - sizePx / 2, x + sizePx / 2, x}, new int[]{y + sizePx / 6, y + sizePx / 6, y + sizePx}, 3);
            g2d.draw(poly);
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int margin = 3 * width / 32;
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.setColor(COLOR);
        g2d.drawLine(width / 2, margin * 2, width / 2, margin * 3 + height / 5);
        for (int i = 0; i < 5; ++i) {
            g2d.drawLine(margin * (i + 1), margin * (3 + i) + height / 5, width - margin * (i + 1), margin * (3 + i) + height / 5);
        }
    }

    @EditableProperty(name="Style")
    public GroundSymbolType getType() {
        return this.type;
    }

    public void setType(GroundSymbolType type) {
        this.type = type;
    }

    public Point getControlPoint(int index) {
        return this.point;
    }

    @EditableProperty
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @EditableProperty
    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    public int getControlPointCount() {
        return 1;
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public void setControlPoint(Point point, int index) {
        this.point.setLocation(point);
    }

    public String getCommonPointName(int pointIndex) {
        return "GND";
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    @Deprecated
    public Void getValue() {
        return null;
    }

    @Deprecated
    public void setValue(Void value) {
    }

    public static enum GroundSymbolType {
        DEFAULT("Default"),
        TRIANGLE("Triangle");

        private String title;

        private GroundSymbolType(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public String toString() {
            return this.title;
        }
    }
}

