/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.passive.AbstractPotentiometer;
import org.diylc.components.transform.PotentiometerTransformer;
import org.diylc.core.ComponentState;
import org.diylc.core.CreationMethod;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Potentiometer", author="Branislav Stojkovic", category="Passive", creationMethod=CreationMethod.SINGLE_CLICK, instanceNamePrefix="VR", description="Panel mount potentiometer with solder lugs", zOrder=4.0, transformer=PotentiometerTransformer.class)
public class PotentiometerPanel
extends AbstractPotentiometer {
    private static final long serialVersionUID = 1L;
    protected static Size BODY_DIAMETER = new Size(Double.valueOf(1.0), SizeUnit.in);
    protected static Size SPACING = new Size(Double.valueOf(0.3), SizeUnit.in);
    protected static Size LUG_DIAMETER = new Size(Double.valueOf(0.15), SizeUnit.in);
    protected static Size PIN_SIZE = new Size(Double.valueOf(0.05), SizeUnit.in);
    protected static Size NUT_SIZE = new Size(Double.valueOf(0.4), SizeUnit.in);
    protected static Size SHAFT_SIZE = new Size(Double.valueOf(0.25), SizeUnit.in);
    protected static Color BODY_COLOR = Color.lightGray;
    protected static Color WAFER_COLOR = Color.decode("#CD8500");
    protected static Color BORDER_COLOR = Color.gray;
    protected static Color NUT_COLOR = Color.decode("#CBD5DB");
    protected Size bodyDiameter = BODY_DIAMETER;
    protected Size spacing = SPACING;
    protected Size lugDiameter = LUG_DIAMETER;
    protected Color bodyColor = BODY_COLOR;
    protected Color borderColor = BORDER_COLOR;
    protected Color nutColor = NUT_COLOR;
    protected Color waferColor = WAFER_COLOR;
    protected Type type = Type.ThroughHole;
    @Deprecated
    protected boolean showShaft = false;
    protected View view;
    protected transient Area[] body = null;

    public PotentiometerPanel() {
        this.controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0)};
        this.updateControlPoints();
    }

    protected void updateControlPoints() {
        int spacing = (int)this.spacing.convertToPixels();
        switch (this.orientation) {
            case DEFAULT: {
                this.controlPoints[1].setLocation(this.controlPoints[0].x + spacing, this.controlPoints[0].y);
                this.controlPoints[2].setLocation(this.controlPoints[0].x + 2 * spacing, this.controlPoints[0].y);
                break;
            }
            case _90: {
                this.controlPoints[1].setLocation(this.controlPoints[0].x, this.controlPoints[0].y + spacing);
                this.controlPoints[2].setLocation(this.controlPoints[0].x, this.controlPoints[0].y + 2 * spacing);
                break;
            }
            case _180: {
                this.controlPoints[1].setLocation(this.controlPoints[0].x - spacing, this.controlPoints[0].y);
                this.controlPoints[2].setLocation(this.controlPoints[0].x - 2 * spacing, this.controlPoints[0].y);
                break;
            }
            case _270: {
                this.controlPoints[1].setLocation(this.controlPoints[0].x, this.controlPoints[0].y - spacing);
                this.controlPoints[2].setLocation(this.controlPoints[0].x, this.controlPoints[0].y - 2 * spacing);
                break;
            }
        }
    }

    public Area[] getBody() {
        int spacing = (int)this.spacing.convertToPixels();
        int diameter = this.getClosestOdd(this.bodyDiameter.convertToPixels());
        if (this.body == null) {
            int i;
            this.body = new Area[10];
            int pinWidth = (int)PIN_SIZE.convertToPixels();
            int centerX = 0;
            int centerY = 0;
            double waferWidth = 2.5 * (double)spacing;
            double waferHeight = spacing;
            switch (this.orientation) {
                case DEFAULT: {
                    centerX = this.controlPoints[0].x + spacing;
                    centerY = this.controlPoints[0].y - spacing / 2 - diameter / 2;
                    this.body[9] = new Area(new RoundRectangle2D.Double((double)centerX - waferWidth / 2.0, (double)this.controlPoints[0].y - waferHeight - (double)(spacing / 2), waferWidth, waferHeight, spacing / 4, spacing / 4));
                    for (i = 0; i < 3; ++i) {
                        this.body[i] = new Area(new Rectangle2D.Double(this.controlPoints[i].x - pinWidth / 2, this.controlPoints[i].y - (spacing + diameter) / 2, pinWidth, (spacing + diameter) / 2));
                    }
                    break;
                }
                case _90: {
                    centerX = this.controlPoints[0].x + spacing / 2 + diameter / 2;
                    centerY = this.controlPoints[0].y + spacing;
                    this.body[9] = new Area(new RoundRectangle2D.Double(this.controlPoints[0].x + spacing / 2, (double)centerY - waferWidth / 2.0, waferHeight, waferWidth, spacing / 4, spacing / 4));
                    for (i = 0; i < 3; ++i) {
                        this.body[i] = new Area(new Rectangle2D.Double(this.controlPoints[i].x, this.controlPoints[i].y - pinWidth / 2, (spacing + diameter) / 2, pinWidth));
                    }
                    break;
                }
                case _180: {
                    centerX = this.controlPoints[0].x - spacing;
                    centerY = this.controlPoints[0].y + spacing / 2 + diameter / 2;
                    this.body[9] = new Area(new RoundRectangle2D.Double((double)centerX - waferWidth / 2.0, this.controlPoints[0].y + spacing / 2, waferWidth, waferHeight, spacing / 4, spacing / 4));
                    for (i = 0; i < 3; ++i) {
                        this.body[i] = new Area(new Rectangle2D.Double(this.controlPoints[i].x - pinWidth / 2, this.controlPoints[i].y, pinWidth, (spacing + diameter) / 2));
                    }
                    break;
                }
                case _270: {
                    centerX = this.controlPoints[0].x - spacing / 2 - diameter / 2;
                    centerY = this.controlPoints[0].y - spacing;
                    this.body[9] = new Area(new RoundRectangle2D.Double((double)this.controlPoints[0].x - waferHeight - (double)(spacing / 2), (double)centerY - waferWidth / 2.0, waferHeight, waferWidth, spacing / 4, spacing / 4));
                    for (i = 0; i < 3; ++i) {
                        this.body[i] = new Area(new Rectangle2D.Double(this.controlPoints[i].x - (spacing + diameter) / 2, this.controlPoints[i].y - pinWidth / 2, (spacing + diameter) / 2, pinWidth));
                    }
                    break;
                }
            }
            this.body[3] = new Area(new Ellipse2D.Double(centerX - diameter / 2, centerY - diameter / 2, diameter, diameter));
            this.body[9].subtract(this.body[3]);
            for (i = 0; i < 3; ++i) {
                this.body[i].subtract(this.body[3]);
            }
            if (this.getType() == Type.ThroughHole) {
                int i2;
                int lugDiameter = this.getClosestOdd(this.lugDiameter.convertToPixels());
                int holeDiameter = this.getClosestOdd(this.lugDiameter.convertToPixels() / 2.0);
                for (i2 = 0; i2 < 3; ++i2) {
                    Area area;
                    this.body[4 + i2] = area = new Area(new Ellipse2D.Double(this.controlPoints[i2].x - lugDiameter / 2, this.controlPoints[i2].y - lugDiameter / 2, lugDiameter, lugDiameter));
                }
                for (i2 = 0; i2 < 3; ++i2) {
                    for (int j = 0; j < 3; ++j) {
                        this.body[i2].subtract(this.body[4 + j]);
                    }
                }
                for (i2 = 0; i2 < 3; ++i2) {
                    this.body[4 + i2].subtract(new Area(new Ellipse2D.Double(this.controlPoints[i2].x - holeDiameter / 2, this.controlPoints[i2].y - holeDiameter / 2, holeDiameter, holeDiameter)));
                }
            }
            if (this.getView() == View.ShaftUp) {
                int nutSize = (int)NUT_SIZE.convertToPixels();
                int shaftSize = (int)SHAFT_SIZE.convertToPixels();
                int[] xPoints = new int[6];
                int[] yPoints = new int[6];
                for (int i3 = 0; i3 < 6; ++i3) {
                    double alpha = Math.toRadians(60 * i3);
                    xPoints[i3] = (int)((double)centerX + Math.cos(alpha) * (double)nutSize / 2.0);
                    yPoints[i3] = (int)((double)centerY + Math.sin(alpha) * (double)nutSize / 2.0);
                }
                this.body[7] = new Area(new Polygon(xPoints, yPoints, 6));
                this.body[8] = new Area(new Ellipse2D.Double(centerX - shaftSize / 2, centerY - shaftSize / 2, shaftSize, shaftSize));
            }
        }
        return this.body;
    }

    @Override
    public void setControlPoint(Point point, int index) {
        super.setControlPoint(point, index);
        this.body = null;
    }

    @Override
    public void setOrientation(Orientation orientation) {
        super.setOrientation(orientation);
        this.updateControlPoints();
        this.body = null;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
        Area[] body = this.getBody();
        for (int i = 0; i < body.length; ++i) {
            Area shape = body[i];
            if (shape == null) continue;
            switch (i) {
                case 7: {
                    g2d.setColor(this.getNutColor());
                    break;
                }
                case 9: {
                    g2d.setColor(this.getWaferColor());
                    break;
                }
                default: {
                    g2d.setColor(this.getBodyColor());
                }
            }
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            if (!outlineMode) {
                if (i == 3) {
                    drawingObserver.startTrackingContinuityArea(true);
                }
                g2d.fill(shape);
                if (i == 3) {
                    drawingObserver.stopTrackingContinuityArea();
                }
            }
            g2d.setComposite(oldComposite);
            Color finalBorderColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.getBorderColor());
            g2d.setColor(finalBorderColor);
            g2d.draw(shape);
        }
        g2d.setFont(project.getFont());
        Color finalLabelColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : LABEL_COLOR);
        g2d.setColor(finalLabelColor);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Rectangle2D bodyRect = this.getBody()[3].getBounds2D();
        Rectangle2D rect = fontMetrics.getStringBounds(this.getName(), g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        int panelHeight = (int)bodyRect.getHeight();
        int panelWidth = (int)bodyRect.getWidth();
        int x = (panelWidth - textWidth) / 2;
        int y = panelHeight / 2 - textHeight + fontMetrics.getAscent();
        g2d.drawString(this.getName(), (int)(bodyRect.getX() + (double)x), (int)(bodyRect.getY() + (double)y));
        rect = fontMetrics.getStringBounds(this.getValueForDisplay(), g2d);
        textHeight = (int)rect.getHeight();
        textWidth = (int)rect.getWidth();
        x = (panelWidth - textWidth) / 2;
        y = panelHeight / 2 + fontMetrics.getAscent();
        g2d.drawString(this.getValueForDisplay(), (int)(bodyRect.getX() + (double)x), (int)(bodyRect.getY() + (double)y));
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int margin = 4 * width / 32;
        int waferMargin = 5 * width / 32;
        int spacing = width / 3 - 1;
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)(1 * width / 32)));
        g2d.setColor(WAFER_COLOR);
        g2d.fillRect(waferMargin, height / 2, width - 2 * waferMargin, height / 3);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRoundRect(waferMargin, height / 2, width - 2 * waferMargin, height / 3, 2 * width / 32, 2 * width / 32);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)(2 * width / 32)));
        g2d.drawLine(width / 2 - spacing, height / 2, width / 2 - spacing, height - margin);
        g2d.drawLine(width / 2 + spacing, height / 2, width / 2 + spacing, height - margin);
        g2d.drawLine(width / 2, height / 2, width / 2, height - margin);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)(4 * width / 32)));
        g2d.drawLine(width / 2 - spacing, height - margin, width / 2 - spacing, height - margin);
        g2d.drawLine(width / 2 + spacing, height - margin, width / 2 + spacing, height - margin);
        g2d.drawLine(width / 2, height - margin, width / 2, height - margin);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.setColor(BODY_COLOR);
        g2d.fillOval(margin, margin / 2, width - 2 * margin, height - 2 * margin);
        g2d.setColor(BORDER_COLOR);
        g2d.drawOval(margin, margin / 2, width - 2 * margin, height - 2 * margin);
    }

    @EditableProperty
    public Size getSpacing() {
        return this.spacing;
    }

    public void setSpacing(Size spacing) {
        this.spacing = spacing;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public Type getType() {
        if (this.type == null) {
            this.type = Type.ThroughHole;
        }
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
        this.body = null;
    }

    @EditableProperty(name="Nut")
    public Color getNutColor() {
        if (this.nutColor == null) {
            this.nutColor = NUT_COLOR;
        }
        return this.nutColor;
    }

    public void setNutColor(Color nutColor) {
        this.nutColor = nutColor;
    }

    @EditableProperty(name="Diameter")
    public Size getBodyDiameter() {
        return this.bodyDiameter;
    }

    public void setBodyDiameter(Size bodyDiameter) {
        this.bodyDiameter = bodyDiameter;
        this.body = null;
    }

    @EditableProperty(name="Lug Size")
    public Size getLugDiameter() {
        return this.lugDiameter;
    }

    public void setLugDiameter(Size lugDiameter) {
        this.lugDiameter = lugDiameter;
        this.body = null;
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty(name="View")
    public View getView() {
        if (this.view == null) {
            this.view = this.showShaft ? View.ShaftUp : View.ShaftDown;
        }
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
        this.body = null;
    }

    @EditableProperty(name="Wafer")
    public Color getWaferColor() {
        if (this.waferColor == null) {
            this.waferColor = WAFER_COLOR;
        }
        return this.waferColor;
    }

    public void setWaferColor(Color waferColor) {
        this.waferColor = waferColor;
    }

    public String getInternalLinkName(int index1, int index2) {
        if (index1 > index2) {
            return this.getInternalLinkName(index2, index1);
        }
        if (index2 - index1 == 1) {
            return index1 + 1 + "-" + (index2 + 1);
        }
        return null;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }

    public static enum View {
        ShaftDown("Shaft Down"),
        ShaftUp("Shaft Up");

        private String value;

        private View(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Type {
        ThroughHole("Through Hole"),
        PCB("PCB");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

