/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractRadialComponent;
import org.diylc.core.CreationMethod;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Inductance;
import org.diylc.core.measures.Resistance;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Inductor (Radial)", author="Branislav Stojkovic", category="Passive", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="L", description="Vertically mounted ferrite core inductor", zOrder=4.0, transformer=SimpleComponentTransformer.class)
public class RadialInductor
extends AbstractRadialComponent<Inductance> {
    private static final long serialVersionUID = 1L;
    public static Size DEFAULT_SIZE = new Size(Double.valueOf(0.25), SizeUnit.in);
    public static Color BODY_COLOR = Color.darkGray;
    public static Color BORDER_COLOR = BODY_COLOR.darker();
    public static Color MARKER_COLOR = Color.decode("#8CACEA");
    public static Color TICK_COLOR = Color.white;
    public static Size HEIGHT = new Size(Double.valueOf(0.4), SizeUnit.in);
    public static Size EDGE_RADIUS = new Size(Double.valueOf(0.5), SizeUnit.mm);
    public static Size LIP = new Size(Double.valueOf(0.05), SizeUnit.in);
    private Inductance value = null;
    private Resistance resistance = null;
    private boolean folded = false;
    private Size height = HEIGHT;
    private Size lip = LIP;

    public RadialInductor() {
        this.bodyColor = BODY_COLOR;
        this.borderColor = BORDER_COLOR;
        this.labelColor = TICK_COLOR;
        this.leadColor = COPPER_COLOR;
    }

    public String getValueForDisplay() {
        return this.getValue().toString();
    }

    @Override
    protected void decorateComponentBody(Graphics2D g2d, boolean outlineMode) {
        if (!this.getFolded()) {
            return;
        }
        Area body = new Area(this.getBodyShape());
        int leadThickness = (int)this.getLeadThickness();
        double lip = this.getLip().convertToPixels();
        Stroke stroke = ObjectCache.getInstance().fetchBasicStroke((float)(leadThickness / 2));
        Rectangle rect = body.getBounds();
        Area copper = new Area();
        for (double y = lip + (double)(leadThickness / 2); y < (double)rect.height - lip - (double)leadThickness; y += (double)leadThickness * 0.9) {
            double margin = y < (double)leadThickness || y > (double)(rect.height - leadThickness) ? (double)(-leadThickness / 4) : (double)(leadThickness / 4);
            Line2D.Double line = new Line2D.Double(-margin + lip, y - (double)(rect.height / 2), (double)rect.width - lip + margin, y - (double)(rect.height / 2));
            Shape s = stroke.createStrokedShape(line);
            copper.add(new Area(s));
        }
        g2d.setColor(COPPER_COLOR);
        g2d.fill(copper);
        g2d.setColor(COPPER_COLOR.darker());
        g2d.draw(copper);
    }

    @Override
    protected boolean decorateAboveBorder() {
        return true;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(COPPER_COLOR);
        g2d.drawLine(0, height * 2 / 5, width / 2, height * 2 / 5);
        g2d.drawLine(0, height * 3 / 5, width / 2, height * 3 / 5);
        g2d.rotate(1.5707963267948966, width / 2, height / 2);
        g2d.setColor(BODY_COLOR);
        Rectangle2D.Double a = new Rectangle2D.Double(width / 2 - 5, 6.0, 10.0, height - 14);
        g2d.fill(a);
        g2d.setColor(BORDER_COLOR);
        g2d.draw(a);
        g2d.setColor(COPPER_COLOR);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        for (int i = 0; i < 5; ++i) {
            g2d.drawLine(width / 2 - 5, 11 + 2 * i, width / 2 + 5, 11 + 2 * i);
        }
    }

    @Override
    protected Size getDefaultWidth() {
        return null;
    }

    @Override
    public Size getWidth() {
        return super.getWidth();
    }

    @Override
    protected Size getDefaultLength() {
        return DEFAULT_SIZE;
    }

    @Override
    @EditableProperty(name="Diameter")
    public Size getLength() {
        return super.getLength();
    }

    @EditableProperty
    public boolean getFolded() {
        return this.folded;
    }

    public void setFolded(boolean folded) {
        this.folded = folded;
    }

    @EditableProperty
    public Size getHeight() {
        if (this.height == null) {
            this.height = HEIGHT;
        }
        return this.height;
    }

    public void setHeight(Size height) {
        this.height = height;
    }

    @Override
    protected Shape getBodyShape() {
        double height = (int)this.getHeight().convertToPixels();
        double diameter = (int)this.getLength().convertToPixels();
        double lip = this.getLip().convertToPixels();
        if (this.folded) {
            Area body = new Area(new RoundRectangle2D.Double(0.0, -height / 2.0 - LEAD_THICKNESS.convertToPixels() / 2.0, this.getClosestOdd(diameter), this.getClosestOdd(height), EDGE_RADIUS.convertToPixels(), EDGE_RADIUS.convertToPixels()));
            body.subtract(new Area(new Rectangle2D.Double(0.0, -height / 2.0 + lip - LEAD_THICKNESS.convertToPixels() / 2.0, lip, height - 2.0 * lip)));
            body.subtract(new Area(new Rectangle2D.Double(diameter - lip, -height / 2.0 + lip - LEAD_THICKNESS.convertToPixels() / 2.0, lip * 2.0, height - 2.0 * lip)));
            return body;
        }
        return new Ellipse2D.Double(0.0, 0.0, this.getClosestOdd(diameter), this.getClosestOdd(diameter));
    }

    @EditableProperty
    public Inductance getValue() {
        return this.value;
    }

    public void setValue(Inductance value) {
        this.value = value;
    }

    @EditableProperty
    public Resistance getResistance() {
        return this.resistance;
    }

    public void setResistance(Resistance resistance) {
        this.resistance = resistance;
    }

    @EditableProperty
    public Size getLip() {
        return this.lip;
    }

    public void setLip(Size lip) {
        this.lip = lip;
    }
}

