/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.transform;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import org.diylc.common.IComponentTransformer;
import org.diylc.common.Orientation;
import org.diylc.components.semiconductors.TransistorTO1;
import org.diylc.core.IDIYComponent;

public class TO1Transformer
implements IComponentTransformer {
    public boolean canRotate(IDIYComponent<?> component) {
        return component.getClass().equals(TransistorTO1.class);
    }

    public boolean canMirror(IDIYComponent<?> component) {
        return component.getClass().equals(TransistorTO1.class);
    }

    public boolean mirroringChangesCircuit() {
        return true;
    }

    public void rotate(IDIYComponent<?> component, Point center, int direction) {
        AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966 * (double)direction, center.x, center.y);
        for (int index = 0; index < component.getControlPointCount(); ++index) {
            Point p = new Point(component.getControlPoint(index));
            rotate.transform(p, p);
            component.setControlPoint(p, index);
        }
        TransistorTO1 transistor = (TransistorTO1)component;
        Orientation o = transistor.getOrientation();
        int oValue = o.ordinal();
        if ((oValue += direction) < 0) {
            oValue = Orientation.values().length - 1;
        }
        if (oValue >= Orientation.values().length) {
            oValue = 0;
        }
        o = Orientation.values()[oValue];
        transistor.setOrientation(o);
    }

    public void mirror(IDIYComponent<?> component, Point center, int direction) {
        TransistorTO1 transistor = (TransistorTO1)component;
        int dx = center.x - transistor.getControlPoint((int)0).x;
        int dy = center.y - transistor.getControlPoint((int)0).y;
        if (direction == 0) {
            Orientation o = transistor.getOrientation();
            switch (o) {
                case DEFAULT: {
                    o = Orientation._180;
                    break;
                }
                case _90: {
                    dx -= transistor.getControlPoint((int)1).x - transistor.getControlPoint((int)0).x;
                    break;
                }
                case _180: {
                    o = Orientation.DEFAULT;
                    break;
                }
                case _270: {
                    dx -= transistor.getControlPoint((int)1).x - transistor.getControlPoint((int)0).x;
                }
            }
            for (int i = 0; i < transistor.getControlPointCount(); ++i) {
                Point p = transistor.getControlPoint(i);
                transistor.setControlPoint(new Point(p.x + 2 * dx, p.y + (transistor.getControlPoint((int)2).y - transistor.getControlPoint((int)0).y)), i);
            }
            transistor.setOrientation(o);
        } else {
            Orientation o = transistor.getOrientation();
            switch (o) {
                case DEFAULT: {
                    dy -= transistor.getControlPoint((int)1).y - transistor.getControlPoint((int)0).y;
                    break;
                }
                case _90: {
                    o = Orientation._270;
                    break;
                }
                case _180: {
                    dy -= transistor.getControlPoint((int)1).y - transistor.getControlPoint((int)0).y;
                    break;
                }
                case _270: {
                    o = Orientation._90;
                }
            }
            for (int i = 0; i < transistor.getControlPointCount(); ++i) {
                Point p = transistor.getControlPoint(i);
                transistor.setControlPoint(new Point(p.x + (transistor.getControlPoint((int)2).x - transistor.getControlPoint((int)0).x), p.y + 2 * dy), i);
            }
            transistor.setOrientation(o);
        }
    }
}

