/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.gui.editor;

import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.diylc.common.PropertyWrapper;
import org.diylc.core.annotations.DynamicList;
import org.diylc.utils.Constants;

public class StringListEditor
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private Color oldBg = this.getBackground();
    private final PropertyWrapper property;

    public StringListEditor(final PropertyWrapper propertyWrapper) throws Exception {
        this.property = propertyWrapper;
        String string = propertyWrapper.getGetter().getAnnotation(DynamicList.class).availableValueFunction();
        Method method = propertyWrapper.getOwnerObject().getClass().getMethod(string, new Class[0]);
        Object[] objectArray = (Object[])method.invoke(propertyWrapper.getOwnerObject(), new Object[0]);
        this.setModel(new DefaultComboBoxModel<Object>(objectArray));
        this.setSelectedItem(propertyWrapper.getValue());
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    propertyWrapper.setChanged(true);
                    StringListEditor.this.setBackground(StringListEditor.this.oldBg);
                    StringListEditor.this.property.setValue(itemEvent.getItem());
                }
            }
        });
        if (!propertyWrapper.isUnique()) {
            this.setBackground(Constants.MULTI_VALUE_COLOR);
        }
    }
}

