/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.autosave;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.Utils;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.core.IView;

public class AutoSavePlugin
implements IPlugIn {
    private static final String AUTO_SAVE_PATH = Utils.getUserDataDirectory("diylc") + "backup";
    private static final Logger LOG = Logger.getLogger(AutoSavePlugin.class);
    public static long BACKUP_FREQ_MS = 60000L;
    public static int MAX_TOTAL_SIZE_MB = 64;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private IPlugInPort plugInPort;
    private long lastSave = 0L;

    public AutoSavePlugin(IView iView) {
    }

    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
        File file = new File(AUTO_SAVE_PATH);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public EnumSet<EventType> getSubscribedEventTypes() {
        return EnumSet.of(EventType.PROJECT_MODIFIED, EventType.PROJECT_LOADED);
    }

    public void processMessage(EventType eventType, Object ... objectArray) {
        String string;
        if (eventType == EventType.PROJECT_MODIFIED) {
            if (System.currentTimeMillis() - this.lastSave > BACKUP_FREQ_MS) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setPriority(1);
                        AutoSavePlugin.this.lastSave = System.currentTimeMillis();
                        String string = AutoSavePlugin.this.generateBackupFileName(AutoSavePlugin.this.plugInPort.getCurrentFileName());
                        AutoSavePlugin.this.plugInPort.saveProjectToFile(string, true);
                        AutoSavePlugin.this.cleanupExtra();
                    }
                });
            }
        } else if (eventType == EventType.PROJECT_LOADED && (string = (String)objectArray[2]) != null) {
            String string2 = this.generateBackupFileName(string);
            try {
                AutoSavePlugin.copyFileUsingStream(new File(string), new File(string2));
                LOG.info((Object)("Copied loaded file to " + string2));
            }
            catch (IOException iOException) {
                LOG.error((Object)"Could not copy the loaded file to backup", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileUsingStream(File file, File file2) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    private String generateBackupFileName(String string) {
        File file;
        String string2;
        if (string == null) {
            string = "Untitled";
        }
        if ((string2 = (file = new File(string)).getName()).toLowerCase().endsWith(".diy")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        file = new File(AUTO_SAVE_PATH + File.separator + string2 + "." + simpleDateFormat.format(date) + ".diy");
        int n = 2;
        while (file.exists()) {
            file = new File(AUTO_SAVE_PATH + File.separator + string2 + "." + simpleDateFormat.format(date) + "-" + n + ".diy");
            ++n;
        }
        return file.getAbsolutePath();
    }

    private void cleanupExtra() {
        File[] fileArray = new File(AUTO_SAVE_PATH).listFiles();
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return new Long(file.lastModified()).compareTo(file2.lastModified());
            }
        });
        long l = 0L;
        long l2 = MAX_TOTAL_SIZE_MB * 1024 * 1024;
        for (File file : fileArray) {
            l += file.length();
        }
        for (int i = 0; i < fileArray.length && l > l2; l -= fileArray[i].length(), ++i) {
            LOG.info((Object)("Maximum backup size exceeded. Deleteting old backup file: " + fileArray[i].getName()));
            fileArray[i].delete();
        }
    }
}

