/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.cloud.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.diylc.swingframework.ButtonDialog;

public class ChangePasswordDialog
extends ButtonDialog {
    private static final long serialVersionUID = 1L;
    private JPanel mainPanel;
    private JPasswordField oldPasswordField;
    private JPasswordField newPasswordField;
    private JPasswordField confirmPasswordField;
    private String oldPassword;
    private String newPassword;

    public ChangePasswordDialog(JFrame jFrame) {
        super(jFrame, "Change Password", new String[]{"OK", "Cancel"});
        this.setMinimumSize(new Dimension(240, 32));
        this.layoutGui();
        this.refreshState();
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    protected JComponent getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(4, 2, 2, 2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.mainPanel.add((Component)new JLabel("Old Password:"), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.mainPanel.add((Component)new JLabel("New Password:"), gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.mainPanel.add((Component)new JLabel("Confirm Password:"), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 0;
            this.mainPanel.add((Component)this.getOldPasswordField(), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.mainPanel.add((Component)this.getNewPasswordField(), gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.mainPanel.add((Component)this.getConfirmPasswordField(), gridBagConstraints);
        }
        return this.mainPanel;
    }

    private void refreshState() {
        String string;
        this.oldPassword = new String(this.getOldPasswordField().getPassword());
        String string2 = new String(this.getNewPasswordField().getPassword());
        this.newPassword = string2.equals(string = new String(this.getConfirmPasswordField().getPassword())) ? string2 : null;
        JButton jButton = this.getButton("OK");
        jButton.setEnabled(this.newPassword != null && this.newPassword.length() > 0 && this.oldPassword != null && this.oldPassword.length() > 0);
    }

    private JPasswordField getOldPasswordField() {
        if (this.oldPasswordField == null) {
            this.oldPasswordField = new JPasswordField();
            this.oldPasswordField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    ChangePasswordDialog.this.refreshState();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    ChangePasswordDialog.this.refreshState();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    ChangePasswordDialog.this.refreshState();
                }
            });
        }
        return this.oldPasswordField;
    }

    private JPasswordField getNewPasswordField() {
        if (this.newPasswordField == null) {
            this.newPasswordField = new JPasswordField();
            this.newPasswordField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    ChangePasswordDialog.this.refreshState();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    ChangePasswordDialog.this.refreshState();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    ChangePasswordDialog.this.refreshState();
                }
            });
        }
        return this.newPasswordField;
    }

    private JPasswordField getConfirmPasswordField() {
        if (this.confirmPasswordField == null) {
            this.confirmPasswordField = new JPasswordField();
            this.confirmPasswordField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    ChangePasswordDialog.this.refreshState();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    ChangePasswordDialog.this.refreshState();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    ChangePasswordDialog.this.refreshState();
                }
            });
        }
        return this.confirmPasswordField;
    }
}

