/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.EnumSet;
import org.apache.log4j.Logger;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.core.Theme;
import org.diylc.images.IconLoader;
import org.diylc.swing.ActionFactory;
import org.diylc.swing.ISwingUI;

public class ConfigPlugin
implements IPlugIn {
    private static final Logger LOG = Logger.getLogger(ConfigPlugin.class);
    private static final String CONFIG_MENU = "Config";
    private static final String THEME_MENU = "Theme";
    private static final String COMPONENT_BROWSER_MENU = "Toolbox";
    public static final String COMPONENT_BROWSER = "componentBrowser";
    public static final String SEARCHABLE_TREE = "Searchable Tree";
    public static final String TABBED_TOOLBAR = "Tabbed Toolbar";
    private ISwingUI swingUI;

    public ConfigPlugin(ISwingUI iSwingUI) {
        this.swingUI = iSwingUI;
    }

    public void connect(IPlugInPort iPlugInPort) {
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createConfigAction(iPlugInPort, "Anti-Aliasing", "antiAliasing", true), CONFIG_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createConfigAction(iPlugInPort, "Auto-Create Pads", "autoCreatePads", false), CONFIG_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createConfigAction(iPlugInPort, "Auto-Edit Mode", "autoEdit", true), CONFIG_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createConfigAction(iPlugInPort, "Continuous Creation", "continuousCreation", false), CONFIG_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createConfigAction(iPlugInPort, "Export Grid", "exportGrid", false), CONFIG_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createConfigAction(iPlugInPort, "Extra Working Area", "extraSpace", true), CONFIG_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createConfigAction(iPlugInPort, "Hardware Acceleration", "hardwareAcceleration", false), CONFIG_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createConfigAction(iPlugInPort, "Hi-Quality Rendering", "hiQualityRender", false), CONFIG_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createConfigAction(iPlugInPort, "Highlight Connected Areas", "highlightContinuityArea", false), CONFIG_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createConfigAction(iPlugInPort, "Mouse Wheel Zoom", "wheelZoom", false), CONFIG_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createConfigAction(iPlugInPort, "Outline Mode", "outline", false), CONFIG_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createConfigAction(iPlugInPort, "Show Rulers", "showRulers", true), CONFIG_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createConfigAction(iPlugInPort, "Show Grid", "showGrid", true), CONFIG_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createConfigAction(iPlugInPort, "Snap to Grid", "snapToGrid", true), CONFIG_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createConfigAction(iPlugInPort, "Sticky Points", "stickyPoints", true), CONFIG_MENU);
        File file = new File("themes");
        if (file.exists()) {
            XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
            this.swingUI.injectSubmenu(THEME_MENU, IconLoader.Pens.getIcon(), CONFIG_MENU);
            for (File file2 : file.listFiles()) {
                if (!file2.getName().toLowerCase().endsWith(".xml")) continue;
                try {
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    Theme theme = (Theme)xStream.fromXML((InputStream)fileInputStream);
                    LOG.debug((Object)("Found theme: " + theme.getName()));
                    this.swingUI.injectMenuAction(ActionFactory.getInstance().createThemeAction(iPlugInPort, theme), THEME_MENU);
                }
                catch (Exception exception) {
                    LOG.error((Object)("Could not load theme file " + file2.getName()), (Throwable)exception);
                }
            }
        }
        this.swingUI.injectSubmenu(COMPONENT_BROWSER_MENU, IconLoader.Hammer.getIcon(), CONFIG_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createComponentBrowserAction(SEARCHABLE_TREE), COMPONENT_BROWSER_MENU);
        this.swingUI.injectMenuAction(ActionFactory.getInstance().createComponentBrowserAction(TABBED_TOOLBAR), COMPONENT_BROWSER_MENU);
    }

    public EnumSet<EventType> getSubscribedEventTypes() {
        return EnumSet.noneOf(EventType.class);
    }

    public void processMessage(EventType eventType, Object ... objectArray) {
    }
}

