/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import dialogs.DialogUtil;
import globals.Globals;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class DialogExport
extends JDialog
implements ComponentListener,
ActionListener {
    private static final int MIN_WIDTH = 450;
    private static final int MIN_HEIGHT = 400;
    private final JFrame parent;
    private boolean export;
    private static final int PNG_INDEX = 0;
    private static final int JPG_INDEX = 1;
    private static final int SVG_INDEX = 2;
    private static final int EPS_INDEX = 3;
    private static final int PGF_INDEX = 4;
    private static final int PDF_INDEX = 5;
    private static final int SCR_INDEX = 6;
    private static final double EPS = 1.0E-5;
    private JComboBox<String> resolution;
    private JCheckBox antiAlias_CB;
    private JCheckBox blackWhite_CB;
    private final JComboBox<String> fileFormat;
    private JTextField fileName;
    private JTextField multiplySizes;

    public void componentResized(ComponentEvent e) {
        int width = this.getWidth();
        int height = this.getHeight();
        boolean resize = false;
        if (width < 450) {
            resize = true;
            width = 450;
        }
        if (height < 400) {
            resize = true;
            height = 400;
        }
        if (resize) {
            this.setSize(width, height);
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public boolean shouldExport() {
        return this.export;
    }

    public boolean getAntiAlias() {
        return this.antiAlias_CB.isSelected();
    }

    public boolean getBlackWhite() {
        return this.blackWhite_CB.isSelected();
    }

    public String getFormat() {
        switch (this.fileFormat.getSelectedIndex()) {
            case 0: {
                return "png";
            }
            case 1: {
                return "jpg";
            }
            case 2: {
                return "svg";
            }
            case 3: {
                return "eps";
            }
            case 4: {
                return "pgf";
            }
            case 5: {
                return "pdf";
            }
            case 6: {
                return "scr";
            }
        }
        System.out.println("dialogExport.getExportFormat Warning: file format set to png");
        return "png";
    }

    public String getFileName() {
        return this.fileName.getText();
    }

    public void setFileName(String f) {
        this.fileName.setText(f);
    }

    public void setAntiAlias(boolean a) {
        this.antiAlias_CB.setSelected(a);
    }

    public void setBlackWhite(boolean a) {
        this.blackWhite_CB.setSelected(a);
    }

    public void setUnitPerPixel(double d) {
        int index = 0;
        if (Math.abs(d - 0.36) < 1.0E-5) {
            index = 0;
        }
        if (Math.abs(d - 0.75) < 1.0E-5) {
            index = 1;
        }
        if (Math.abs(d - 1.5) < 1.0E-5) {
            index = 2;
        }
        if (Math.abs(d - 3.0) < 1.0E-5) {
            index = 3;
        }
        if (Math.abs(d - 6.0) < 1.0E-5) {
            index = 4;
        }
        this.resolution.setSelectedIndex(index);
    }

    public void setMagnification(double d) {
        this.multiplySizes.setText("" + d);
    }

    public double getMagnification() {
        return Double.parseDouble(this.multiplySizes.getText());
    }

    public double getUnitPerPixel() {
        int index = this.resolution.getSelectedIndex();
        if (index == 0) {
            return 0.36;
        }
        if (index == 1) {
            return 0.75;
        }
        if (index == 2) {
            return 1.5;
        }
        if (index == 3) {
            return 3.0;
        }
        if (index == 4) {
            return 6.0;
        }
        return 0.36;
    }

    public void setFormat(String s) {
        if ("png".equals(s)) {
            this.fileFormat.setSelectedIndex(0);
        } else if ("jpg".equals(s)) {
            this.fileFormat.setSelectedIndex(1);
        } else if ("svg".equals(s)) {
            this.fileFormat.setSelectedIndex(2);
        } else if ("eps".equals(s)) {
            this.fileFormat.setSelectedIndex(3);
        } else if ("pgf".equals(s)) {
            this.fileFormat.setSelectedIndex(4);
        } else if ("pdf".equals(s)) {
            this.fileFormat.setSelectedIndex(5);
        } else if ("scr".equals(s)) {
            this.fileFormat.setSelectedIndex(6);
        } else {
            this.fileFormat.setSelectedIndex(0);
        }
    }

    private JPanel createInterfacePanel() {
        JPanel panel = new JPanel();
        GridBagLayout bgl = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(bgl);
        JLabel resolutionLabel = new JLabel(Globals.messages.getString("Resolution"));
        constraints = DialogUtil.createConst(1, 0, 1, 1, 0, 0, 13, 1, new Insets(6, 40, 6, 6));
        panel.add((Component)resolutionLabel, constraints);
        this.resolution = new JComboBox();
        this.resolution.addItem("72x72 dpi");
        this.resolution.addItem("150x150 dpi");
        this.resolution.addItem("300x300 dpi");
        this.resolution.addItem("600x600 dpi");
        this.resolution.addItem("1200x1200 dpi");
        constraints = DialogUtil.createConst(2, 0, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 0, 0));
        panel.add(this.resolution, constraints);
        this.antiAlias_CB = new JCheckBox(Globals.messages.getString("Anti_aliasing"));
        constraints = DialogUtil.createConst(2, 1, 1, 1, 100, 100, 17, 2, new Insets(6, 0, 0, 0));
        panel.add((Component)this.antiAlias_CB, constraints);
        this.blackWhite_CB = new JCheckBox(Globals.messages.getString("B_W"));
        constraints = DialogUtil.createConst(2, 2, 1, 1, 100, 100, 17, 0, new Insets(6, 0, 0, 0));
        panel.add((Component)this.blackWhite_CB, constraints);
        JLabel multiplySizesLabel = new JLabel(Globals.messages.getString("Multiply_sizes"));
        constraints = DialogUtil.createConst(1, 3, 1, 1, 0, 0, 13, 0, new Insets(6, 40, 0, 0));
        panel.add((Component)multiplySizesLabel, constraints);
        this.multiplySizes = new JTextField();
        constraints = DialogUtil.createConst(2, 3, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 0, 0));
        panel.add((Component)this.multiplySizes, constraints);
        JLabel fileNameLabel = new JLabel(Globals.messages.getString("File_name"));
        constraints = DialogUtil.createConst(1, 4, 1, 1, 0, 0, 13, 0, new Insets(6, 40, 12, 0));
        panel.add((Component)fileNameLabel, constraints);
        this.fileName = new JTextField();
        constraints = DialogUtil.createConst(2, 4, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 12, 0));
        panel.add((Component)this.fileName, constraints);
        JButton browse = new JButton(Globals.messages.getString("Browse"));
        constraints = DialogUtil.createConst(3, 4, 1, 1, 0, 0, 10, 0, new Insets(6, 0, 12, 12));
        panel.add((Component)browse, constraints);
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (Globals.useNativeFileDialogs) {
                    FileDialog fd = new FileDialog((Frame)DialogExport.this.parent, Globals.messages.getString("Select_file_export"), 1);
                    fd.setDirectory(new File(DialogExport.this.fileName.getText()).getPath());
                    fd.setVisible(true);
                    if (fd.getFile() != null) {
                        String filen = Globals.createCompleteFileName(fd.getDirectory(), fd.getFile());
                        DialogExport.this.fileName.setText(filen);
                    }
                } else {
                    JFileChooser fc = new JFileChooser(new File(DialogExport.this.fileName.getText()).getPath());
                    int r = fc.showSaveDialog(null);
                    if (r == 0) {
                        DialogExport.this.fileName.setText(fc.getSelectedFile().toString());
                    }
                }
            }
        });
        return panel;
    }

    public void actionPerformed(ActionEvent evt) {
        JComboBox source = (JComboBox)evt.getSource();
        int idx = source.getSelectedIndex();
        if (idx == 0 || idx == 1) {
            this.resolution.setEnabled(true);
            this.antiAlias_CB.setEnabled(true);
            this.blackWhite_CB.setEnabled(true);
            this.multiplySizes.setEnabled(false);
            this.multiplySizes.setText("1.0");
        } else {
            this.resolution.setEnabled(false);
            this.antiAlias_CB.setEnabled(false);
            this.blackWhite_CB.setEnabled(true);
            this.multiplySizes.setEnabled(true);
        }
    }

    public DialogExport(JFrame p) {
        super(p, Globals.messages.getString("Circ_exp_t"), true);
        this.getRootPane().putClientProperty("apple.awt.documentModalSheet", Boolean.TRUE);
        this.addComponentListener(this);
        this.export = false;
        this.parent = p;
        GridBagLayout bgl = new GridBagLayout();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(bgl);
        JLabel fileFormatLabel = new JLabel(Globals.messages.getString("File_format"));
        GridBagConstraints constraints = DialogUtil.createConst(1, 0, 1, 1, 0, 0, 13, 0, new Insets(12, 40, 0, 0));
        contentPane.add((Component)fileFormatLabel, constraints);
        this.fileFormat = new JComboBox();
        this.fileFormat.addItem("PNG (Bitmap)");
        this.fileFormat.addItem("JPG (Bitmap)");
        this.fileFormat.addItem("SVG (Vector, Scalable Vector Graphic)");
        this.fileFormat.addItem("EPS (Vector, Encapsulated Postscript)");
        this.fileFormat.addItem("PGF (Vector, PGF packet for LaTeX)");
        this.fileFormat.addItem("PDF (Vector, Portable Document File)");
        this.fileFormat.addItem("CadSoft Eagle SCR (Script)");
        this.fileFormat.setSelectedIndex(0);
        constraints = DialogUtil.createConst(2, 0, 1, 1, 100, 100, 17, 2, new Insets(12, 0, 0, 20));
        contentPane.add(this.fileFormat, constraints);
        this.fileFormat.addActionListener(this);
        JPanel panel = this.createInterfacePanel();
        Border etched = BorderFactory.createEtchedBorder();
        TitledBorder titled = BorderFactory.createTitledBorder(etched, Globals.messages.getString("ExportOptions"));
        panel.setBorder(titled);
        JButton ok = new JButton(Globals.messages.getString("Ok_btn"));
        JButton cancel = new JButton(Globals.messages.getString("Cancel_btn"));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        constraints.anchor = 13;
        constraints.insets = new Insets(20, 20, 20, 20);
        contentPane.add((Component)panel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        constraints.anchor = 13;
        constraints.insets = new Insets(20, 20, 20, 20);
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        ok.setPreferredSize(cancel.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            b.add(ok);
            b.add(Box.createHorizontalStrut(12));
            b.add(cancel);
        } else {
            b.add(cancel);
            b.add(Box.createHorizontalStrut(12));
            b.add(ok);
        }
        contentPane.add((Component)b, constraints);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                double mult = Double.parseDouble(DialogExport.this.multiplySizes.getText());
                if (DialogExport.this.multiplySizes.isEnabled() && (mult < 0.01 || mult > 100.0)) {
                    DialogExport.this.export = false;
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("Warning_mul"), Globals.messages.getString("Warning"), 2);
                    return;
                }
                if (DialogExport.this.fileName.getText().trim().equals("")) {
                    DialogExport.this.export = false;
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("Warning_noname"), Globals.messages.getString("Warning"), 2);
                    return;
                }
                boolean selection = false;
                if (!selection) {
                    DialogExport.this.export = true;
                    DialogExport.this.setVisible(false);
                }
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogExport.this.setVisible(false);
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DialogExport.this.setVisible(false);
            }
        };
        DialogUtil.addCancelEscape(this, cancelAction);
        this.pack();
        DialogUtil.center(this);
        this.getRootPane().setDefaultButton(ok);
    }
}

