/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import dialogs.ArrowCellRenderer;
import dialogs.ArrowInfo;
import dialogs.DashCellRenderer;
import dialogs.DashInfo;
import dialogs.DialogUtil;
import dialogs.LayerCellRenderer;
import dialogs.LayerInfo;
import dialogs.OSKeybPanel;
import dialogs.ParameterDescription;
import globals.Globals;
import graphic.FontG;
import graphic.PointG;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import layers.LayerDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogParameters
extends JDialog
implements ComponentListener {
    private int MIN_WIDTH = 450;
    private int MIN_HEIGHT = 350;
    private static final int MAX = 20;
    private static final int MAX_ELEMENTS = 100;
    public boolean active;
    private final JTextField[] jtf;
    private int tc;
    private final JCheckBox[] jcb;
    private int cc;
    private final JComboBox[] jco;
    private int co;
    private final Vector<ParameterDescription> v;
    OSKeybPanel keyb1;
    OSKeybPanel keyb2;
    JTabbedPane keyb = new JTabbedPane();

    public DialogParameters(JFrame parent, Vector<ParameterDescription> vec, boolean strict, Vector<LayerDesc> layers) {
        super(parent, Globals.messages.getString("Param_opt"), true);
        this.keyb1 = new OSKeybPanel(OSKeybPanel.KEYBMODES.GREEK);
        this.keyb2 = new OSKeybPanel(OSKeybPanel.KEYBMODES.MISC);
        this.keyb1.setField(this);
        this.keyb2.setField(this);
        this.keyb.addTab("Greek", this.keyb1);
        this.keyb.addTab("Misc", this.keyb2);
        this.keyb.setVisible(false);
        this.v = vec;
        int ycount = 0;
        this.jtf = new JTextField[100];
        this.jcb = new JCheckBox[100];
        this.jco = new JComboBox[100];
        this.active = false;
        this.addComponentListener(this);
        GridBagLayout bgl = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(bgl);
        boolean extStrict = strict;
        int top = 0;
        this.tc = 0;
        this.cc = 0;
        this.co = 0;
        for (ycount = 0; ycount < this.v.size() && ycount <= 20; ++ycount) {
            ParameterDescription pd = this.v.elementAt(ycount);
            JLabel lab = new JLabel(pd.description);
            constraints.weightx = 100.0;
            constraints.weighty = 100.0;
            constraints.gridx = 1;
            constraints.gridy = ycount;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            top = ycount == 0 ? 10 : 0;
            constraints.insets = new Insets(top, 20, 0, 6);
            constraints.fill = 3;
            constraints.anchor = 13;
            lab.setEnabled(!pd.isExtension || !extStrict);
            if (!(pd.parameter instanceof Boolean)) {
                contentPane.add((Component)lab, constraints);
            }
            constraints.anchor = 17;
            constraints.insets = new Insets(top, 0, 0, 0);
            constraints.fill = 2;
            if (pd.parameter instanceof PointG) {
                this.jtf[this.tc] = new JTextField(10);
                this.jtf[this.tc].setText("" + ((PointG)pd.parameter).x);
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 2;
                constraints.gridy = ycount;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.jtf[this.tc].setEnabled(!pd.isExtension || !extStrict);
                contentPane.add((Component)this.jtf[this.tc++], constraints);
                this.jtf[this.tc] = new JTextField(10);
                this.jtf[this.tc].setText("" + ((PointG)pd.parameter).y);
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 3;
                constraints.gridy = ycount;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.insets = new Insets(top, 6, 0, 20);
                constraints.fill = 2;
                this.jtf[this.tc].setEnabled(!pd.isExtension || !extStrict);
                contentPane.add((Component)this.jtf[this.tc++], constraints);
                continue;
            }
            if (pd.parameter instanceof String) {
                this.jtf[this.tc] = new JTextField(24);
                this.jtf[this.tc].setText((String)pd.parameter);
                if (ycount == 0) {
                    this.jtf[this.tc].selectAll();
                }
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 2;
                constraints.gridy = ycount;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.insets = new Insets(top, 0, 0, 20);
                constraints.fill = 2;
                this.jtf[this.tc].setEnabled(!pd.isExtension || !extStrict);
                contentPane.add((Component)this.jtf[this.tc++], constraints);
                continue;
            }
            if (pd.parameter instanceof Boolean) {
                this.jcb[this.cc] = new JCheckBox(pd.description);
                this.jcb[this.cc].setSelected((Boolean)pd.parameter);
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 2;
                constraints.gridy = ycount;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.insets = new Insets(top, 0, 0, 20);
                constraints.fill = 2;
                this.jcb[this.cc].setEnabled(!pd.isExtension || !extStrict);
                contentPane.add((Component)this.jcb[this.cc++], constraints);
                continue;
            }
            if (pd.parameter instanceof Integer) {
                this.jtf[this.tc] = new JTextField(24);
                this.jtf[this.tc].setText(((Integer)pd.parameter).toString());
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 2;
                constraints.gridy = ycount;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.insets = new Insets(top, 0, 0, 20);
                constraints.fill = 2;
                this.jtf[this.tc].setEnabled(!pd.isExtension || !extStrict);
                contentPane.add((Component)this.jtf[this.tc++], constraints);
                continue;
            }
            if (pd.parameter instanceof Float) {
                this.jtf[this.tc] = new JTextField(24);
                int dummy = Math.round(((Float)pd.parameter).floatValue());
                this.jtf[this.tc].setText("" + dummy);
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 2;
                constraints.gridy = ycount;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.insets = new Insets(top, 0, 0, 20);
                constraints.fill = 2;
                this.jtf[this.tc].setEnabled(!pd.isExtension || !extStrict);
                contentPane.add((Component)this.jtf[this.tc++], constraints);
                continue;
            }
            if (pd.parameter instanceof FontG) {
                GraphicsEnvironment gE = GraphicsEnvironment.getLocalGraphicsEnvironment();
                String[] s = gE.getAvailableFontFamilyNames();
                this.jco[this.co] = new JComboBox();
                for (int i = 0; i < s.length; ++i) {
                    this.jco[this.co].addItem(s[i]);
                    if (!s[i].equals(((FontG)pd.parameter).getFamily())) continue;
                    this.jco[this.co].setSelectedIndex(i);
                }
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 2;
                constraints.gridy = ycount;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.insets = new Insets(top, 0, 0, 20);
                constraints.fill = 2;
                this.jco[this.co].setEnabled(!pd.isExtension || !extStrict);
                contentPane.add((Component)this.jco[this.co++], constraints);
                continue;
            }
            if (pd.parameter instanceof LayerInfo) {
                this.jco[this.co] = new JComboBox<LayerDesc>(new Vector<LayerDesc>(layers));
                this.jco[this.co].setSelectedIndex(((LayerInfo)pd.parameter).layer);
                this.jco[this.co].setRenderer(new LayerCellRenderer());
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 2;
                constraints.gridy = ycount;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.insets = new Insets(top, 0, 0, 20);
                constraints.fill = 2;
                this.jco[this.co].setEnabled(!pd.isExtension || !extStrict);
                contentPane.add((Component)this.jco[this.co++], constraints);
                continue;
            }
            if (pd.parameter instanceof ArrowInfo) {
                this.jco[this.co] = new JComboBox();
                this.jco[this.co].addItem(new ArrowInfo(0));
                this.jco[this.co].addItem(new ArrowInfo(1));
                this.jco[this.co].addItem(new ArrowInfo(2));
                this.jco[this.co].addItem(new ArrowInfo(3));
                this.jco[this.co].setSelectedIndex(((ArrowInfo)pd.parameter).style);
                this.jco[this.co].setRenderer(new ArrowCellRenderer());
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = 2;
                constraints.gridy = ycount;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.insets = new Insets(top, 0, 0, 20);
                constraints.fill = 2;
                this.jco[this.co].setEnabled(!pd.isExtension || !extStrict);
                contentPane.add((Component)this.jco[this.co++], constraints);
                continue;
            }
            if (!(pd.parameter instanceof DashInfo)) continue;
            this.jco[this.co] = new JComboBox();
            for (int k = 0; k < 5; ++k) {
                this.jco[this.co].addItem(new DashInfo(k));
            }
            this.jco[this.co].setSelectedIndex(((DashInfo)pd.parameter).style);
            this.jco[this.co].setRenderer(new DashCellRenderer());
            constraints.weightx = 100.0;
            constraints.weighty = 100.0;
            constraints.gridx = 2;
            constraints.gridy = ycount;
            constraints.gridwidth = 2;
            constraints.gridheight = 1;
            constraints.insets = new Insets(top, 0, 0, 20);
            constraints.fill = 2;
            this.jco[this.co].setEnabled(!pd.isExtension || !extStrict);
            contentPane.add((Component)this.jco[this.co++], constraints);
        }
        JButton ok = new JButton(Globals.messages.getString("Ok_btn"));
        JButton cancel = new JButton(Globals.messages.getString("Cancel_btn"));
        JButton keybd = new JButton("\u00b6\u2211\u221a");
        keybd.setFocusable(false);
        keybd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DialogParameters.this.keyb.isVisible()) {
                    DialogParameters.this.MIN_WIDTH = 400;
                    DialogParameters.this.MIN_HEIGHT = 350;
                } else {
                    DialogParameters.this.MIN_WIDTH = 400;
                    DialogParameters.this.MIN_HEIGHT = 500;
                }
                DialogParameters.this.keyb.setVisible(!DialogParameters.this.keyb.isVisible());
                DialogParameters.this.pack();
            }
        });
        constraints.gridx = 0;
        constraints.gridy = ycount++;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        constraints.anchor = 13;
        constraints.insets = new Insets(6, 20, 20, 20);
        Box b = Box.createHorizontalBox();
        b.add(keybd);
        b.add(Box.createHorizontalGlue());
        ok.setPreferredSize(cancel.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            b.add(ok);
            b.add(Box.createHorizontalStrut(12));
            b.add(cancel);
        } else {
            b.add(cancel);
            b.add(Box.createHorizontalStrut(12));
            b.add(ok);
        }
        contentPane.add((Component)b, constraints);
        constraints.gridx = 0;
        constraints.gridy = ycount;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        constraints.anchor = 13;
        constraints.insets = new Insets(6, 20, 20, 20);
        contentPane.add((Component)this.keyb, constraints);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    DialogParameters.this.tc = 0;
                    DialogParameters.this.cc = 0;
                    DialogParameters.this.co = 0;
                    for (int ycount = 0; ycount < DialogParameters.this.v.size() && ycount <= 20; ++ycount) {
                        ParameterDescription pd = (ParameterDescription)DialogParameters.this.v.elementAt(ycount);
                        if (pd.parameter instanceof PointG) {
                            ((PointG)pd.parameter).x = Integer.parseInt(DialogParameters.this.jtf[DialogParameters.this.tc++].getText());
                            ((PointG)pd.parameter).y = Integer.parseInt(DialogParameters.this.jtf[DialogParameters.this.tc++].getText());
                            continue;
                        }
                        if (pd.parameter instanceof String) {
                            pd.parameter = DialogParameters.this.jtf[DialogParameters.this.tc++].getText();
                            continue;
                        }
                        if (pd.parameter instanceof Boolean) {
                            pd.parameter = DialogParameters.this.jcb[DialogParameters.this.cc++].isSelected();
                            continue;
                        }
                        if (pd.parameter instanceof Integer) {
                            pd.parameter = Integer.parseInt(DialogParameters.this.jtf[DialogParameters.this.tc++].getText());
                            continue;
                        }
                        if (pd.parameter instanceof Float) {
                            pd.parameter = Float.valueOf(Float.parseFloat(DialogParameters.this.jtf[DialogParameters.this.tc++].getText()));
                            continue;
                        }
                        if (pd.parameter instanceof FontG) {
                            pd.parameter = new FontG((String)DialogParameters.this.jco[DialogParameters.this.co++].getSelectedItem());
                            continue;
                        }
                        if (pd.parameter instanceof LayerInfo) {
                            pd.parameter = new LayerInfo(DialogParameters.this.jco[DialogParameters.this.co++].getSelectedIndex());
                            continue;
                        }
                        if (pd.parameter instanceof ArrowInfo) {
                            pd.parameter = new ArrowInfo(DialogParameters.this.jco[DialogParameters.this.co++].getSelectedIndex());
                            continue;
                        }
                        if (!(pd.parameter instanceof DashInfo)) continue;
                        pd.parameter = new DashInfo(DialogParameters.this.jco[DialogParameters.this.co++].getSelectedIndex());
                    }
                }
                catch (NumberFormatException E) {
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("Format_invalid"), "", 1);
                    return;
                }
                DialogParameters.this.active = true;
                DialogParameters.this.setVisible(false);
                DialogParameters.this.keyb.setVisible(false);
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogParameters.this.setVisible(false);
                DialogParameters.this.keyb.setVisible(false);
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DialogParameters.this.setVisible(false);
                DialogParameters.this.keyb.setVisible(false);
            }
        };
        DialogUtil.addCancelEscape(this, cancelAction);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DialogParameters.this.keyb.setVisible(false);
            }
        });
        this.pack();
        DialogUtil.center(this);
        this.getRootPane().setDefaultButton(ok);
    }

    public Vector<ParameterDescription> getCharacteristics() {
        return this.v;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.adjustSize();
    }

    private void adjustSize() {
        this.pack();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

