/*
 * Decompiled with CFR 0.152.
 */
package globals;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;

public class FileUtils {
    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists() && !targetLocation.mkdir()) {
                throw new IOException("Can not create temp. directory.");
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                FileUtils.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            FileUtils.copyFile(sourceLocation, targetLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            return;
        }
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(sourceLocation);
            out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    public static void copyDirectoryNonRecursive(File sourceLocation, File targetLocation, String tcriteria) throws IOException {
        String criteria = tcriteria;
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists() && !targetLocation.mkdir()) {
                throw new IOException("Can not create temp. directory.");
            }
            criteria = criteria.toLowerCase(new Locale("en"));
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].toLowerCase().contains(criteria)) continue;
                FileUtils.copyFile(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        }
    }

    public static boolean deleteDirectory(File directory) throws IOException {
        File[] files;
        if (directory.exists() && null != (files = directory.listFiles())) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtils.deleteDirectory(files[i]);
                    continue;
                }
                if (files[i].delete()) continue;
                throw new IOException("Can not delete file" + files[i]);
            }
        }
        return directory.delete();
    }
}

