/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.macropicker;

import circuit.CircuitPanel;
import export.ExportGraphic;
import geom.MapCoordinates;
import globals.Globals;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import net.sourceforge.fidocadj.layermodel.LayerModel;
import net.sourceforge.fidocadj.librarymodel.Category;
import net.sourceforge.fidocadj.librarymodel.Library;
import net.sourceforge.fidocadj.librarymodel.LibraryModel;
import net.sourceforge.fidocadj.librarymodel.event.LibraryListenerAdapter;
import net.sourceforge.fidocadj.macropicker.ExpandableJTree;
import net.sourceforge.fidocadj.macropicker.MacroTreePopupMenu;
import net.sourceforge.fidocadj.macropicker.SearchField;
import net.sourceforge.fidocadj.macropicker.model.MacroTreeModel;
import net.sourceforge.fidocadj.macropicker.model.MacroTreeNode;
import primitives.MacroDesc;
import toolbars.ChangeSelectionListener;

public class MacroTree
extends JPanel {
    public static final int LIBRARY = 0;
    public static final int CATEGORY = 1;
    public static final int MACRO = 2;
    private ExpandableJTree treeComponent;
    private SearchField searchField;
    private CircuitPanel previewPanel;
    private JScrollPane treeScrollPane;
    private LibraryModel libraryModel;
    private LayerModel layerModel;
    private MacroTreeModel macroTreeModel;
    private ChangeSelectionListener selectionListener;
    private ArrayList<ChangeListener> changeListeners;
    private TreePath copyTarget = null;
    private OperationPermission permissionObject;

    public MacroTree(LibraryModel libraryModel, LayerModel layerModel) {
        this.libraryModel = libraryModel;
        this.layerModel = layerModel;
        this.initComponents();
    }

    private void initComponents() {
        JSplitPane splitPane = new JSplitPane(0);
        Box topBox = Box.createVerticalBox();
        this.setLayout(new GridLayout(1, 0));
        this.createListenerArray();
        this.createTreeView();
        this.createPreviewPanel();
        this.createSearchField();
        this.createPermissionObject();
        this.createPopupMenu();
        this.bindSearchField();
        this.bindLibraryModel();
        this.bindPreviewPanel();
        topBox.add(this.searchField);
        topBox.add(this.treeScrollPane);
        splitPane.setTopComponent(topBox);
        splitPane.setBottomComponent(this.previewPanel);
        splitPane.setResizeWeight(0.9);
        this.add(splitPane);
    }

    private void createListenerArray() {
        this.changeListeners = new ArrayList();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public int getSelectedType() {
        TreePath path = this.treeComponent.getSelectionPath();
        if (path == null) {
            return -1;
        }
        int type = this.macroTreeModel.getNodeType(path);
        switch (type) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    public void remove(Library library) {
        if (library == null) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, Globals.messages.getString("remove_library_confirm") + library.getName() + "?", Globals.messages.getString("remove_library"), 0);
        if (result == 0) {
            try {
                this.libraryModel.remove(library);
            }
            catch (LibraryModel.IllegalLibraryAccessException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), Globals.messages.getString("error"), 0);
            }
        }
    }

    public void remove(Category category) {
        if (category == null) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, Globals.messages.getString("remove_category_confirm") + category.getName() + "?", Globals.messages.getString("remove_category"), 0);
        if (result == 0) {
            try {
                this.libraryModel.remove(category);
            }
            catch (LibraryModel.IllegalLibraryAccessException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), Globals.messages.getString("error"), 0);
            }
        }
    }

    public void remove(MacroDesc macro) {
        if (macro == null) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, Globals.messages.getString("remove_macro_confirm") + macro.name + "?", Globals.messages.getString("remove_macro"), 0);
        if (result == 0) {
            try {
                this.libraryModel.remove(macro);
            }
            catch (LibraryModel.IllegalLibraryAccessException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), Globals.messages.getString("error"), 0);
            }
        }
    }

    public void rename(MacroDesc macro) {
        if (macro == null) {
            return;
        }
        String newName = JOptionPane.showInputDialog(null, Globals.messages.getString("new_macro_name"), macro.name);
        if (newName == null || newName.equals(macro.name)) {
            return;
        }
        try {
            this.libraryModel.rename(macro, newName);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), Globals.messages.getString("error"), 0);
        }
    }

    public void rename(Category category) {
        if (category == null) {
            return;
        }
        String newName = JOptionPane.showInputDialog(null, Globals.messages.getString("new_category_name"), category.getName());
        if (newName == null || newName.equals(category.getName())) {
            return;
        }
        try {
            this.libraryModel.rename(category, newName);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), Globals.messages.getString("error"), 0);
        }
    }

    public void rename(Library library) {
        if (library == null) {
            return;
        }
        String newName = JOptionPane.showInputDialog(null, Globals.messages.getString("new_library_name"), library.getName());
        if (newName == null || newName.equals(library.getName())) {
            return;
        }
        try {
            this.libraryModel.rename(library, newName);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), Globals.messages.getString("error"), 0);
        }
    }

    public void changeKey(MacroDesc macro) {
        if (macro == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, Globals.messages.getString("ChangeKeyWarning"), Globals.messages.getString("RenKey"), 0);
        if (n == 1) {
            return;
        }
        String oldKey = LibraryModel.getPlainMacroKey(macro);
        String newKey = JOptionPane.showInputDialog(null, Globals.messages.getString("Key"), oldKey);
        if (newKey == null || newKey.equals(oldKey)) {
            return;
        }
        try {
            this.libraryModel.changeKey(macro, newKey);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), Globals.messages.getString("error"), 0);
        }
    }

    public void setSelectedNodeToCopyTarget() {
        this.copyTarget = this.treeComponent.getSelectionPath();
    }

    public void pasteIntoSelectedNode() {
        if (this.copyTarget == null) {
            return;
        }
        int copyTargetType = this.macroTreeModel.getNodeType(this.copyTarget);
        int selectedNodeType = this.getSelectedType();
        if (copyTargetType == 2 && selectedNodeType == 0) {
            this.copyCategoryIntoLibrary();
        } else if (copyTargetType == 3 && selectedNodeType == 1) {
            this.copyMacroIntoCategory();
        }
        this.copyTarget = null;
        this.updateOperationPermission();
    }

    private void copyCategoryIntoLibrary() {
        Library destLibrary = this.getSelectedLibrary();
        Category targetCategory = this.macroTreeModel.getCategory(this.copyTarget);
        this.libraryModel.copy(targetCategory, destLibrary);
    }

    private void copyMacroIntoCategory() {
        Category destCategory = this.getSelectedCategory();
        MacroDesc targetMacro = this.macroTreeModel.getMacro(this.copyTarget);
        this.libraryModel.copy(targetMacro, destCategory);
    }

    private void createPermissionObject() {
        this.permissionObject = new OperationPermission();
    }

    public OperationPermission getOperationPermission() {
        return this.permissionObject;
    }

    private void updateOperationPermission() {
        Library lib = this.getSelectedLibrary();
        Category cat = this.getSelectedCategory();
        MacroDesc macro = this.getSelectedMacro();
        TreePath selectedPath = this.treeComponent.getSelectionPath();
        this.permissionObject.disableAll();
        int selectedType = this.getSelectedType();
        if (selectedType == 1 || selectedType == 2) {
            this.permissionObject.copyAvailable = true;
        }
        if (!this.macroTreeModel.isSearchMode()) {
            if (this.copyTarget != null && lib != null && !lib.isStdLib()) {
                int copyTargetType = this.macroTreeModel.getNodeType(this.copyTarget);
                if (copyTargetType == 2 && selectedType == 0) {
                    this.permissionObject.pasteAvailable = true;
                } else if (copyTargetType == 3 && selectedType == 1) {
                    this.permissionObject.pasteAvailable = true;
                }
            }
            if (lib != null && !lib.isStdLib()) {
                this.permissionObject.renameAvailable = true;
                this.permissionObject.removeAvailable = true;
                if (selectedType == 2) {
                    this.permissionObject.renKeyAvailable = true;
                }
            }
        }
    }

    private void createPopupMenu() {
        MacroTreePopupMenu popupMenu = new MacroTreePopupMenu(this);
        this.treeComponent.setComponentPopupMenu(popupMenu);
        this.addChangeListener(popupMenu);
    }

    private void bindPreviewPanel() {
        this.treeComponent.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                MacroDesc md = MacroTree.this.macroTreeModel.getMacro(e.getPath());
                if (md != null) {
                    MacroTree.this.previewPanel.setCirc(new StringBuffer(md.description));
                    MapCoordinates m = ExportGraphic.calculateZoomToFit(((MacroTree)MacroTree.this).previewPanel.P, ((MacroTree)MacroTree.this).previewPanel.getSize().width * 85 / 100, ((MacroTree)MacroTree.this).previewPanel.getSize().height * 85 / 100, true);
                    m.setXCenter(-m.getXCenter() + 10.0);
                    m.setYCenter(-m.getYCenter() + 10.0);
                    MacroTree.this.previewPanel.setMapCoordinates(m);
                    MacroTree.this.previewPanel.repaint();
                }
            }
        });
        LibraryListenerAdapter l = new LibraryListenerAdapter(){

            public void libraryLoaded() {
                ((MacroTree)MacroTree.this).previewPanel.P.setLibrary(MacroTree.this.libraryModel.getAllMacros());
            }
        };
        this.libraryModel.addLibraryListener(l);
    }

    public void setSelectionListener(ChangeSelectionListener l) {
        this.selectionListener = l;
        this.treeComponent.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                if (MacroTree.this.selectionListener != null) {
                    MacroDesc md = MacroTree.this.macroTreeModel.getMacro(e.getPath());
                    if (md != null) {
                        MacroTree.this.selectionListener.setSelectionState(13, md.key);
                    } else {
                        MacroTree.this.selectionListener.setSelectionState(1, "");
                    }
                }
            }
        });
    }

    private void bindLibraryModel() {
        this.macroTreeModel = new MacroTreeModel(this.libraryModel);
        this.treeComponent.setModel(this.macroTreeModel);
        this.libraryModel.addLibraryListener(this.macroTreeModel);
    }

    private void createTreeView() {
        this.treeComponent = new ExpandableJTree();
        this.treeComponent.setCellRenderer(new MacroTreeCellRenderer());
        this.treeComponent.getSelectionModel().setSelectionMode(1);
        this.treeScrollPane = new JScrollPane(this.treeComponent);
        this.treeScrollPane.setMinimumSize(new Dimension(150, 100));
        this.treeScrollPane.setPreferredSize(new Dimension(350, 600));
        this.treeComponent.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                MacroTree.this.updateOperationPermission();
                for (ChangeListener l : MacroTree.this.changeListeners) {
                    l.stateChanged(new ChangeEvent(this));
                }
            }
        });
    }

    private void createSearchField() {
        this.searchField = new SearchField();
    }

    private void createPreviewPanel() {
        this.previewPanel = new CircuitPanel(false);
        this.previewPanel.P.setLayers(this.layerModel.getAllLayers());
        this.previewPanel.P.setLibrary(this.libraryModel.getAllMacros());
        this.previewPanel.setGridVisibility(false);
        this.previewPanel.setMinimumSize(new Dimension(150, 100));
        this.previewPanel.setPreferredSize(new Dimension(350, 300));
    }

    private void bindSearchField() {
        DocumentListener searchFieldListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void removeUpdate(DocumentEvent e) {
                this.setWord(e);
            }

            public void insertUpdate(DocumentEvent e) {
                this.setWord(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void setWord(DocumentEvent e) {
                String word = null;
                Document d = e.getDocument();
                try {
                    word = d.getText(0, d.getLength());
                }
                catch (BadLocationException ex) {
                    word = "";
                    System.out.println("[SearchFieldListener] BadLocationException");
                }
                finally {
                    if ("".equals(word)) {
                        MacroTree.this.treeComponent.collapseOnce();
                    } else {
                        MacroTree.this.treeComponent.expandOnce();
                    }
                    MacroTree.this.macroTreeModel.setFilterWord(word);
                }
            }
        };
        this.searchField.getDocument().addDocumentListener(searchFieldListener);
        this.searchField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (e.isShiftDown()) {
                        MacroTree.this.treeComponent.selectPrevLeaf();
                    } else {
                        MacroTree.this.treeComponent.selectNextLeaf();
                    }
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public void setLibraryModel(LibraryModel libraryModel) {
        this.libraryModel = libraryModel;
        this.previewPanel.P.setLibrary(libraryModel.getAllMacros());
        this.bindSearchField();
    }

    public void setLayerModel(LayerModel layerModel) {
        this.layerModel = layerModel;
        this.previewPanel.P.setLayers(layerModel.getAllLayers());
    }

    public MacroDesc getSelectedMacro() {
        TreePath path = this.treeComponent.getSelectionPath();
        if (path == null) {
            return null;
        }
        return this.macroTreeModel.getMacro(path);
    }

    public Category getSelectedCategory() {
        TreePath path = this.treeComponent.getSelectionPath();
        if (path == null) {
            return null;
        }
        return this.macroTreeModel.getCategory(path);
    }

    public Library getSelectedLibrary() {
        TreePath path = this.treeComponent.getSelectionPath();
        if (path == null) {
            return null;
        }
        return this.macroTreeModel.getLibrary(path);
    }

    private class MacroTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MacroTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof MacroTreeNode) {
                Icon icon = ((MacroTreeNode)value).getIcon();
                if (icon == null) {
                    return c;
                }
                this.setIcon(icon);
            }
            return this;
        }
    }

    public class OperationPermission {
        private boolean copyAvailable;
        private boolean pasteAvailable;
        private boolean renameAvailable;
        private boolean removeAvailable;
        private boolean renKeyAvailable;

        public boolean isCopyAvailable() {
            return this.copyAvailable;
        }

        public boolean isPasteAvailable() {
            return this.pasteAvailable;
        }

        public boolean isRenameAvailable() {
            return this.renameAvailable;
        }

        public boolean isRemoveAvailable() {
            return this.removeAvailable;
        }

        public boolean isRenKeyAvailable() {
            return this.renKeyAvailable;
        }

        public void disableAll() {
            this.copyAvailable = false;
            this.pasteAvailable = false;
            this.renameAvailable = false;
            this.removeAvailable = false;
            this.renKeyAvailable = false;
        }
    }
}

