/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import graphic.GraphicsInterface;
import graphic.PointG;
import graphic.PolygonInterface;

public final class Arrow {
    public static final int flagLimiter = 1;
    public static final int flagEmpty = 2;

    private Arrow() {
    }

    public static PointG drawArrow(GraphicsInterface g, int x, int y, int xc, int yc, int l, int h, int style) {
        double alpha = x == xc ? 1.5707963267948966 + ((double)(y - yc) < 0.0 ? 0.0 : Math.PI) : Math.atan((double)(y - yc) / (double)(x - xc));
        double x0 = (double)x - (double)l * Math.cos(alpha += (double)(x - xc) > 0.0 ? 0.0 : Math.PI);
        double y0 = (double)y - (double)l * Math.sin(alpha);
        double x1 = x0 - (double)h * Math.sin(alpha);
        double y1 = y0 + (double)h * Math.cos(alpha);
        double x2 = x0 + (double)h * Math.sin(alpha);
        double y2 = y0 - (double)h * Math.cos(alpha);
        PolygonInterface p = g.createPolygon();
        p.addPoint((int)((double)x + 0.5), (int)((double)y + 0.5));
        p.addPoint((int)(x1 + 0.5), (int)(y1 + 0.5));
        p.addPoint((int)(x2 + 0.5), (int)(y2 + 0.5));
        if ((style & 2) == 0) {
            g.fillPolygon(p);
        } else {
            g.drawPolygon(p);
        }
        if ((style & 1) != 0) {
            double x3 = (double)x - (double)h * Math.sin(alpha);
            double y3 = (double)y + (double)h * Math.cos(alpha);
            double x4 = (double)x + (double)h * Math.sin(alpha);
            double y4 = (double)y - (double)h * Math.cos(alpha);
            g.drawLine((int)x3, (int)y3, (int)x4, (int)y4);
        }
        return new PointG((int)x0, (int)y0);
    }
}

