/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import dialogs.LayerInfo;
import dialogs.ParameterDescription;
import export.ExportInterface;
import geom.GeometricDistances;
import geom.MapCoordinates;
import globals.Globals;
import graphic.DimensionG;
import graphic.GraphicsInterface;
import graphic.PointG;
import java.io.IOException;
import java.util.Vector;
import layers.LayerDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphicPrimitive {
    public static final int NO_DRAG = -1;
    public static final int DRAG_PRIMITIVE = -2;
    public static final int RECT_SELECTION = -3;
    private static final int HANDLE_WIDTH = 10;
    private static final int MAX_TOKENS = 120;
    public boolean selectedState;
    protected static final float D_MIN = 0.5f;
    public int layer;
    public PointG[] virtualPoint;
    protected boolean changed;
    private int macroFontSize;
    protected String macroFont;
    protected String name;
    protected String value;
    private LayerDesc l;
    private float alpha;
    private static float oldalpha = 1.0f;
    private int old_layer = -1;
    private int xa;
    private int ya;
    private int xb;
    private int yb;
    private int h;
    private int th;
    private int w1;
    private int w2;
    private int t_th;
    private int t_w1;
    private int t_w2;
    private int x2;
    private int y2;
    private int x3;
    private int y3;

    public void GraphicPrimitive(String f, int size) {
        this.selectedState = false;
        this.layer = 0;
        this.changed = true;
        this.name = "";
        this.value = "";
        this.setMacroFontSize(size);
        this.macroFont = f;
    }

    public void setMacroFont(String f, int size) {
        this.macroFont = f;
        this.setMacroFontSize(size);
        this.changed = true;
    }

    public void initPrimitive(int number, String font, int size) {
        this.setMacroFontSize(size);
        this.macroFont = font;
        this.name = "";
        this.value = "";
        int npoints = number;
        if (npoints < 0) {
            npoints = this.getControlPointNumber();
        }
        this.virtualPoint = new PointG[npoints];
        for (int i = 0; i < npoints; ++i) {
            this.virtualPoint[i] = new PointG();
        }
    }

    public String getMacroFont() {
        return this.macroFont;
    }

    public int getMacroFontSize() {
        return this.macroFontSize;
    }

    public void setMacroFontSize(int size) {
        this.macroFontSize = size;
        if (this.macroFontSize <= 0) {
            this.macroFontSize = 1;
        }
    }

    protected void drawText(GraphicsInterface g, MapCoordinates coordSys, Vector layerV, int drawOnlyLayer) {
        if (this.value == null && this.name == null) {
            return;
        }
        if ("".equals(this.value) && "".equals(this.name)) {
            return;
        }
        if (drawOnlyLayer >= 0 && drawOnlyLayer != this.getLayer()) {
            return;
        }
        if (this.changed) {
            this.x2 = this.virtualPoint[this.getNameVirtualPointNumber()].x;
            this.y2 = this.virtualPoint[this.getNameVirtualPointNumber()].y;
            this.x3 = this.virtualPoint[this.getValueVirtualPointNumber()].x;
            this.y3 = this.virtualPoint[this.getValueVirtualPointNumber()].y;
            this.xa = coordSys.mapX(this.x2, this.y2);
            this.ya = coordSys.mapY(this.x2, this.y2);
            this.xb = coordSys.mapX(this.x3, this.y3);
            this.yb = coordSys.mapY(this.x3, this.y3);
            g.setFont(this.macroFont, (int)((double)(this.macroFontSize * 12) * coordSys.getYMagnitude() / 7.0 + 0.5));
            this.h = g.getFontAscent();
            this.th = this.h + g.getFontDescent();
            this.w1 = this.name == null ? 0 : g.getStringWidth(this.name);
            this.w2 = this.value == null ? 0 : g.getStringWidth(this.value);
            this.t_w1 = (int)((double)this.w1 / coordSys.getXMagnitude());
            this.t_w2 = (int)((double)this.w2 / coordSys.getXMagnitude());
            this.t_th = (int)((double)this.th / coordSys.getYMagnitude());
            coordSys.trackPoint(this.xa, this.ya);
            coordSys.trackPoint(this.xa + this.w1, this.ya + this.th);
            coordSys.trackPoint(this.xb, this.yb);
            coordSys.trackPoint(this.xb + this.w2, this.yb + this.th);
        }
        if (!g.hitClip(this.xa, this.ya, this.w1, this.th) && !g.hitClip(this.xb, this.yb, this.w2, this.th)) {
            return;
        }
        if (this.th < 4) {
            g.drawLine(this.xa, this.ya, this.xa + this.w1 - 1, this.ya);
            g.drawLine(this.xb, this.yb, this.xb + this.w2 - 1, this.yb);
            return;
        }
        if (!this.changed) {
            g.setFont(this.macroFont, (int)((double)(this.macroFontSize * 12) * coordSys.getYMagnitude() / 7.0 + 0.5));
        }
        if (this.name != null && this.name.length() != 0) {
            g.drawString(this.name, this.xa, this.ya + this.h);
        }
        if (this.value != null && this.value.length() != 0) {
            g.drawString(this.value, this.xb, this.yb + this.h);
        }
    }

    public String saveText(boolean extensions) {
        String subsFont;
        StringBuffer s2 = new StringBuffer();
        if (this.macroFont.equals("Courier New")) {
            subsFont = "*";
        } else {
            StringBuffer s1 = new StringBuffer("");
            for (int i = 0; i < this.macroFont.length(); ++i) {
                if (this.macroFont.charAt(i) == ' ') {
                    s1.append("++");
                    continue;
                }
                s1.append(this.macroFont.charAt(i));
            }
            subsFont = s1.toString();
        }
        if (this.name != null && !"".equals(this.name) || this.value != null && !"".equals(this.value)) {
            if (extensions) {
                s2.append("FCJ\n");
            }
            s2.append("TY ");
            s2.append(this.virtualPoint[this.getNameVirtualPointNumber()].x);
            s2.append(" ");
            s2.append(this.virtualPoint[this.getNameVirtualPointNumber()].y);
            s2.append(" ");
            s2.append(this.macroFontSize * 4 / 3);
            s2.append(" ");
            s2.append(this.macroFontSize);
            s2.append(" 0 0 ");
            s2.append(this.getLayer());
            s2.append(" ");
            s2.append(subsFont);
            s2.append(" ");
            s2.append(this.name == null ? "" : this.name);
            s2.append("\n");
            s2.append("TY ");
            s2.append(this.virtualPoint[this.getValueVirtualPointNumber()].x);
            s2.append(" ");
            s2.append(this.virtualPoint[this.getValueVirtualPointNumber()].y);
            s2.append(" ");
            s2.append(this.macroFontSize * 4 / 3);
            s2.append(" ");
            s2.append(this.macroFontSize);
            s2.append(" 0 0 ");
            s2.append(this.getLayer());
            s2.append(" ");
            s2.append(subsFont);
            s2.append(" ");
            s2.append(this.value == null ? "" : this.value);
            s2.append("\n");
        }
        return s2.toString();
    }

    public void exportText(ExportInterface exp, MapCoordinates cs, int drawOnlyLayer) throws IOException {
        double size = Math.abs(cs.mapXr(this.macroFontSize, this.macroFontSize) - cs.mapXr(0.0, 0.0));
        if (drawOnlyLayer < 0 || drawOnlyLayer == this.getLayer()) {
            if (this.name != null && !this.name.equals("")) {
                exp.exportAdvText(cs.mapX(this.virtualPoint[this.getNameVirtualPointNumber()].x, this.virtualPoint[this.getNameVirtualPointNumber()].y), cs.mapY(this.virtualPoint[this.getNameVirtualPointNumber()].x, this.virtualPoint[this.getNameVirtualPointNumber()].y), (int)size, (int)(size * 12.0 / 7.0 + 0.5), this.macroFont, false, false, false, 0, this.getLayer(), this.name);
            }
            if (this.value != null && !this.value.equals("")) {
                exp.exportAdvText(cs.mapX(this.virtualPoint[this.getValueVirtualPointNumber()].x, this.virtualPoint[this.getValueVirtualPointNumber()].y), cs.mapY(this.virtualPoint[this.getValueVirtualPointNumber()].x, this.virtualPoint[this.getValueVirtualPointNumber()].y), (int)size, (int)(size * 12.0 / 7.0 + 0.5), this.macroFont, false, false, false, 0, this.getLayer(), this.value);
            }
        }
    }

    public boolean checkText(int px, int py) {
        if (!"".equals(this.name) && GeometricDistances.pointInRectangle(this.virtualPoint[this.getNameVirtualPointNumber()].x, this.virtualPoint[this.getNameVirtualPointNumber()].y, this.t_w1, this.t_th, px, py)) {
            return true;
        }
        return !"".equals(this.value) && GeometricDistances.pointInRectangle(this.virtualPoint[this.getValueVirtualPointNumber()].x, this.virtualPoint[this.getValueVirtualPointNumber()].y, this.t_w2, this.t_th, px, py);
    }

    public void setValue(String[] tokens, int N) throws IOException {
        StringBuffer txtb = new StringBuffer();
        int j = 8;
        this.changed = true;
        if (tokens[0].equals("TY")) {
            if (N < 9) {
                IOException E = new IOException("bad arguments on TY");
                throw E;
            }
            this.virtualPoint[this.getValueVirtualPointNumber()].x = Integer.parseInt(tokens[1]);
            this.virtualPoint[this.getValueVirtualPointNumber()].y = Integer.parseInt(tokens[2]);
            this.macroFont = tokens[8].equals("*") ? "Courier New" : tokens[8].replaceAll("\\+\\+", " ");
            this.setMacroFontSize(Integer.parseInt(tokens[4]));
            while (j < N - 1) {
                txtb.append(tokens[++j]);
                if (j >= N - 1) continue;
                txtb.append(" ");
            }
        } else {
            IOException E = new IOException("Invalid primitive: " + tokens[0] + " programming error?");
            throw E;
        }
        this.value = txtb.toString();
    }

    public void setName(String[] tokens, int N) throws IOException {
        StringBuffer txtb = new StringBuffer();
        int j = 8;
        this.changed = true;
        if (tokens[0].equals("TY")) {
            if (N < 9) {
                IOException E = new IOException("bad arguments on TY");
                throw E;
            }
            this.virtualPoint[this.getNameVirtualPointNumber()].x = Integer.parseInt(tokens[1]);
            this.virtualPoint[this.getNameVirtualPointNumber()].y = Integer.parseInt(tokens[2]);
            while (j < N - 1) {
                txtb.append(tokens[++j]);
                if (j >= N - 1) continue;
                txtb.append(" ");
            }
        } else {
            IOException E = new IOException("Invalid primitive:" + tokens[0] + " programming error?");
            throw E;
        }
        this.name = txtb.toString();
    }

    public void setChanged(boolean c) {
        this.changed = c;
    }

    public PointG getFirstPoint() {
        return this.virtualPoint[0];
    }

    public void movePrimitive(int dx, int dy) {
        int n = this.getControlPointNumber();
        for (int a = 0; a < n; ++a) {
            this.virtualPoint[a].x += dx;
            this.virtualPoint[a].y += dy;
        }
        this.changed = true;
    }

    public void mirrorPrimitive(int xPos) {
        int n = this.getControlPointNumber();
        for (int a = 0; a < n; ++a) {
            int xtmp = this.virtualPoint[a].x;
            this.virtualPoint[a].x = 2 * xPos - xtmp;
        }
        this.changed = true;
    }

    public void rotatePrimitive(boolean bCounterClockWise, int ix, int iy) {
        int m = this.getControlPointNumber();
        PointG ptTmp = new PointG();
        PointG pt = new PointG();
        pt.x = ix;
        pt.y = iy;
        for (int b = 0; b < m; ++b) {
            ptTmp.x = this.virtualPoint[b].x;
            ptTmp.y = this.virtualPoint[b].y;
            if (bCounterClockWise) {
                this.virtualPoint[b].x = pt.x + ptTmp.y - pt.y;
                this.virtualPoint[b].y = pt.y - (ptTmp.x - pt.x);
                continue;
            }
            this.virtualPoint[b].x = pt.x - (ptTmp.y - pt.y);
            this.virtualPoint[b].y = pt.y + ptTmp.x - pt.x;
        }
        this.changed = true;
    }

    public void setDrawOnlyLayer(int i) {
    }

    public boolean containsLayer(int l) {
        return l == this.layer;
    }

    public int getMaxLayer() {
        return this.layer;
    }

    public final void setSelected(boolean s) {
        this.selectedState = s;
    }

    public final boolean getSelected() {
        return this.selectedState;
    }

    public final int getLayer() {
        return this.layer;
    }

    public void parseLayer(String token) {
        int l;
        try {
            l = Integer.parseInt(token);
        }
        catch (NumberFormatException E) {
            l = 0;
        }
        this.layer = this.layer < 0 || this.layer >= 16 ? 0 : l;
        this.changed = true;
    }

    public final void setLayer(int l) {
        this.layer = l < 0 || l >= 16 ? 0 : l;
        this.changed = true;
    }

    protected final boolean selectLayer(GraphicsInterface g, Vector layerV) {
        if (this.old_layer != this.layer || this.changed) {
            this.l = this.layer < layerV.size() ? (LayerDesc)layerV.get(this.layer) : (LayerDesc)layerV.get(0);
            this.old_layer = this.layer;
        }
        if (!this.l.isVisible) {
            return false;
        }
        if (this.selectedState) {
            g.activateSelectColor(this.l);
        } else if (g.getColor() != this.l.getColor() || oldalpha != this.alpha) {
            g.setColor(this.l.getColor());
            oldalpha = this.alpha = this.l.getAlpha();
            g.setAlpha(this.alpha);
        }
        return true;
    }

    public void drawHandles(GraphicsInterface g, MapCoordinates cs) {
        g.setColor(g.getColor().red());
        g.applyStroke(2.0f, 0);
        for (int i = 0; i < this.getControlPointNumber(); ++i) {
            int ya;
            int xa;
            if (!this.testIfValidHandle(i) || !g.hitClip((xa = cs.mapX(this.virtualPoint[i].x, this.virtualPoint[i].y)) - 5, (ya = cs.mapY(this.virtualPoint[i].x, this.virtualPoint[i].y)) - 5, 10, 10)) continue;
            g.fillRect(xa - 5, ya - 5, 10, 10);
        }
    }

    public int onHandle(MapCoordinates cs, int px, int py) {
        int increase = 2;
        int hw2 = 5;
        int hl2 = 5;
        for (int i = 0; i < this.getControlPointNumber(); ++i) {
            int ya;
            int xa;
            if (!this.testIfValidHandle(i) || !GeometricDistances.pointInRectangle((xa = cs.mapX(this.virtualPoint[i].x, this.virtualPoint[i].y)) - hw2 - increase, (ya = cs.mapY(this.virtualPoint[i].x, this.virtualPoint[i].y)) - hl2 - increase, 10 + 2 * increase, 10 + 2 * increase, px, py)) continue;
            return i;
        }
        return -1;
    }

    public boolean selectRect(int px, int py, int w, int h) {
        for (int i = 0; i < this.getControlPointNumber(); ++i) {
            if (!this.testIfValidHandle(i)) continue;
            int xa = this.virtualPoint[i].x;
            int ya = this.virtualPoint[i].y;
            if (px > xa || xa >= px + w || py > ya || ya >= py + h) continue;
            this.setSelected(true);
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null && this.name.length() != 0;
    }

    public boolean hasValue() {
        return this.value != null && this.value.length() != 0;
    }

    protected boolean testIfValidHandle(int i) {
        if (i == this.getNameVirtualPointNumber()) {
            if (this.name == null) {
                return false;
            }
            if (this.name.length() == 0) {
                return false;
            }
        }
        if (i == this.getValueVirtualPointNumber()) {
            if (this.value == null) {
                return false;
            }
            if (this.value.length() == 0) {
                return false;
            }
        }
        return true;
    }

    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> v = new Vector<ParameterDescription>(10);
        ParameterDescription pd = new ParameterDescription();
        pd.parameter = this.name == null ? "" : this.name;
        pd.description = Globals.messages.getString("ctrl_name");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.value == null ? "" : this.value;
        pd.description = Globals.messages.getString("ctrl_value");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new LayerInfo(this.layer);
        pd.description = Globals.messages.getString("ctrl_layer");
        v.add(pd);
        return v;
    }

    public int setControls(Vector<ParameterDescription> v) {
        int i = 0;
        this.changed = true;
        ParameterDescription pd = v.get(i);
        ++i;
        if (pd.parameter instanceof String) {
            this.name = (String)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i);
        ++i;
        if (pd.parameter instanceof String) {
            this.value = (String)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i);
        if (pd.parameter instanceof LayerInfo) {
            this.layer = ((LayerInfo)pd.parameter).getLayer();
        } else {
            System.out.println("Warning: unexpected parameter! (layer)");
        }
        return ++i;
    }

    public boolean needsHoles() {
        return false;
    }

    public void setDrawOnlyPads(boolean t) {
    }

    public abstract void draw(GraphicsInterface var1, MapCoordinates var2, Vector var3);

    public abstract void parseTokens(String[] var1, int var2) throws IOException;

    public abstract int getDistanceToPoint(int var1, int var2);

    public abstract int getControlPointNumber();

    public abstract String toString(boolean var1);

    public abstract void export(ExportInterface var1, MapCoordinates var2) throws IOException;

    public abstract int getNameVirtualPointNumber();

    public abstract int getValueVirtualPointNumber();

    public DimensionG getSize() {
        GraphicPrimitive p = this;
        int qx = 0;
        int qy = 0;
        for (int i = 0; i < p.getControlPointNumber(); ++i) {
            if (i == p.getNameVirtualPointNumber() || i == p.getValueVirtualPointNumber()) continue;
            for (int j = i + 1; j < p.getControlPointNumber(); ++j) {
                if (j == p.getNameVirtualPointNumber() || j == p.getValueVirtualPointNumber()) continue;
                qx = Math.abs(p.virtualPoint[i].x - p.virtualPoint[j].x);
                qy = Math.abs(p.virtualPoint[i].y - p.virtualPoint[j].y);
            }
        }
        return new DimensionG(qx, qy);
    }

    public PointG getPosition() {
        GraphicPrimitive p = this;
        int qx = Integer.MAX_VALUE;
        int qy = Integer.MAX_VALUE;
        for (int i = 0; i < p.getControlPointNumber(); ++i) {
            if (i == p.getNameVirtualPointNumber() || i == p.getValueVirtualPointNumber()) continue;
            if (p.virtualPoint[i].x < qx) {
                qx = p.virtualPoint[i].x;
            }
            if (p.virtualPoint[i].y >= qy) continue;
            qy = p.virtualPoint[i].y;
        }
        return new PointG(qx, qy);
    }
}

