/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import dialogs.ArrowInfo;
import dialogs.DashInfo;
import dialogs.ParameterDescription;
import export.ExportInterface;
import geom.GeometricDistances;
import geom.MapCoordinates;
import globals.Globals;
import graphic.GraphicsInterface;
import graphic.PointDouble;
import graphic.PointG;
import graphic.PolygonInterface;
import graphic.ShapeInterface;
import java.io.IOException;
import java.util.Vector;
import primitives.Arrow;
import primitives.Cubic;
import primitives.CurveStorage;
import primitives.GraphicPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitiveComplexCurve
extends GraphicPrimitive {
    private int nPoints;
    private boolean isFilled;
    private boolean isClosed;
    private boolean arrowStart;
    private boolean arrowEnd;
    private int arrowLength;
    private int arrowHalfWidth;
    private int arrowStyle;
    private int dashStyle;
    private PolygonInterface p;
    private PolygonInterface q;
    int N_POINTS = 5;
    static final int STEPS = 24;
    private int xmin;
    private int ymin;
    private int width;
    private int height;
    private float w;
    private ShapeInterface gp;

    @Override
    public int getControlPointNumber() {
        return this.nPoints + 2;
    }

    public PrimitiveComplexCurve(String f, int size) {
        this.isFilled = false;
        this.nPoints = 0;
        this.p = null;
        this.initPrimitive(this.N_POINTS, f, size);
    }

    public PrimitiveComplexCurve(boolean f, boolean c, int layer, boolean arrowS, boolean arrowE, int arrowSt, int arrowLe, int arrowWi, int dashSt, String font, int size) {
        this.arrowLength = arrowLe;
        this.arrowHalfWidth = arrowWi;
        this.arrowStart = arrowS;
        this.arrowEnd = arrowE;
        this.arrowStyle = arrowSt;
        this.dashStyle = dashSt;
        this.p = null;
        this.initPrimitive(this.N_POINTS, font, size);
        this.nPoints = 0;
        this.isFilled = f;
        this.isClosed = c;
        this.dashStyle = dashSt;
        this.setLayer(layer);
    }

    public void addPointClosest(int px, int py) {
        int[] xp = new int[this.N_POINTS];
        int[] yp = new int[this.N_POINTS];
        for (int k = 0; k < this.nPoints; ++k) {
            xp[k] = this.virtualPoint[k].x;
            yp[k] = this.virtualPoint[k].y;
        }
        int distance = (int)Math.sqrt((px - xp[0]) * (px - xp[0]) + (py - yp[0]) * (py - yp[0]));
        int minv = 0;
        for (int i = 0; i < this.q.getNpoints() - 1; ++i) {
            int d = GeometricDistances.pointToSegment(this.q.getXpoints()[i], this.q.getYpoints()[i], this.q.getXpoints()[i + 1], this.q.getYpoints()[i + 1], px, py);
            if (d >= distance) continue;
            distance = d;
            minv = i - 1;
        }
        minv /= 24;
        if (++minv < 0) {
            minv = this.nPoints - 1;
        }
        this.addPoint(px, py);
        for (int i = this.nPoints - 1; i > minv; --i) {
            this.virtualPoint[i].x = this.virtualPoint[i - 1].x;
            this.virtualPoint[i].y = this.virtualPoint[i - 1].y;
        }
        this.virtualPoint[minv].x = px;
        this.virtualPoint[minv].y = py;
        this.changed = true;
    }

    public void addPoint(int x, int y) {
        if (this.nPoints + 2 >= this.N_POINTS) {
            int i;
            int o_n = this.N_POINTS;
            this.N_POINTS += 10;
            PointG[] nv = new PointG[this.N_POINTS];
            for (i = 0; i < o_n; ++i) {
                nv[i] = this.virtualPoint[i];
            }
            while (i < this.N_POINTS) {
                nv[i] = new PointG();
                ++i;
            }
            this.virtualPoint = nv;
        }
        this.virtualPoint[this.nPoints].x = x;
        ++this.nPoints;
        this.virtualPoint[this.nPoints].y = y;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = x + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = y + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = x + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = y + 10;
        this.changed = true;
    }

    public CurveStorage createComplexCurve(MapCoordinates coordSys) {
        Cubic[] Y;
        Cubic[] X;
        int i;
        int np = this.nPoints;
        double[] xPoints = new double[np];
        double[] yPoints = new double[np];
        for (i = 0; i < this.nPoints; ++i) {
            xPoints[i] = coordSys.mapXr(this.virtualPoint[i].x, this.virtualPoint[i].y);
            yPoints[i] = coordSys.mapYr(this.virtualPoint[i].x, this.virtualPoint[i].y);
        }
        if (this.isClosed) {
            X = this.calcNaturalCubicClosed(np - 1, xPoints);
            Y = this.calcNaturalCubicClosed(np - 1, yPoints);
        } else {
            X = this.calcNaturalCubic(np - 1, xPoints);
            Y = this.calcNaturalCubic(np - 1, yPoints);
        }
        if (X == null || Y == null) {
            return null;
        }
        CurveStorage c = new CurveStorage();
        c.pp.add(new PointDouble(X[0].eval(0.0), Y[0].eval(0.0)));
        for (i = 0; i < X.length; ++i) {
            c.dd.add(new PointDouble(X[i].d1, Y[i].d1));
            for (int j = 1; j <= 24; ++j) {
                double u = (double)j / 24.0;
                c.pp.add(new PointDouble(X[i].eval(u), Y[i].eval(u)));
            }
        }
        c.dd.add(new PointDouble(X[X.length - 1].d2, Y[X.length - 1].d2));
        return c;
    }

    public PolygonInterface createComplexCurvePoly(MapCoordinates coordSys, PolygonInterface poly) {
        this.xmin = Integer.MAX_VALUE;
        this.ymin = Integer.MAX_VALUE;
        int xmax = -2147483647;
        int ymax = -2147483647;
        CurveStorage c = this.createComplexCurve(coordSys);
        if (c == null) {
            return null;
        }
        Vector<PointDouble> pp = c.pp;
        if (pp == null) {
            return null;
        }
        for (int i = 0; i < pp.size(); ++i) {
            int x = (int)Math.round(pp.get((int)i).x);
            int y = (int)Math.round(pp.get((int)i).y);
            poly.addPoint(x, y);
            coordSys.trackPoint(x, y);
            if (x < this.xmin) {
                this.xmin = x;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (y < this.ymin) {
                this.ymin = y;
            }
            if (y <= ymax) continue;
            ymax = y;
        }
        this.width = xmax - this.xmin;
        this.height = ymax - this.ymin;
        return poly;
    }

    Cubic[] calcNaturalCubic(int n, double[] x) {
        int i;
        if (n < 1) {
            return null;
        }
        double[] gamma = new double[n + 1];
        double[] delta = new double[n + 1];
        double[] D = new double[n + 1];
        gamma[0] = 0.5;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0 / (4.0 - gamma[i - 1]);
        }
        gamma[n] = 1.0 / (2.0 - gamma[n - 1]);
        delta[0] = 3.0 * (x[1] - x[0]) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = (3.0 * (x[i + 1] - x[i - 1]) - delta[i - 1]) * gamma[i];
        }
        delta[n] = (3.0 * (x[n] - x[n - 1]) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Cubic(x[i], D[i], 3.0 * (x[i + 1] - x[i]) - 2.0 * D[i] - D[i + 1], 2.0 * (x[i] - x[i + 1]) + D[i] + D[i + 1]);
            C[i].d1 = D[i];
            C[i].d2 = D[i + 1];
        }
        return C;
    }

    Cubic[] calcNaturalCubicClosed(int n, double[] x) {
        int k;
        if (n < 1) {
            return null;
        }
        double[] w = new double[n + 1];
        double[] v = new double[n + 1];
        double[] y = new double[n + 1];
        double[] D = new double[n + 1];
        double z = 0.25;
        v[1] = 0.25;
        w[1] = 0.25;
        y[0] = z * 3.0 * (x[1] - x[n]);
        double H = 4.0;
        double F = 3.0 * (x[0] - x[n - 1]);
        double G = 1.0;
        for (k = 1; k < n; ++k) {
            v[k + 1] = z = 1.0 / (4.0 - v[k]);
            w[k + 1] = -z * w[k];
            y[k] = z * (3.0 * (x[k + 1] - x[k - 1]) - y[k - 1]);
            H -= G * w[k];
            F -= G * y[k - 1];
            G = -v[k] * G;
        }
        y[n] = F - (G + 1.0) * y[n - 1];
        D[n] = y[n] / (H -= (G + 1.0) * (v[n] + w[n]));
        D[n - 1] = y[n - 1] - (v[n] + w[n]) * D[n];
        for (k = n - 2; k >= 0; --k) {
            D[k] = y[k] - v[k + 1] * D[k + 1] - w[k + 1] * D[n];
        }
        Cubic[] C = new Cubic[n + 1];
        for (k = 0; k < n; ++k) {
            C[k] = new Cubic((float)x[k], D[k], 3.0 * (x[k + 1] - x[k]) - 2.0 * D[k] - D[k + 1], 2.0 * (x[k] - x[k + 1]) + D[k] + D[k + 1]);
            C[k].d1 = D[k];
            C[k].d2 = D[k + 1];
        }
        C[n] = new Cubic((float)x[n], D[n], 3.0 * (x[0] - x[n]) - 2.0 * D[n] - D[0], 2.0 * (x[n] - x[0]) + D[n] + D[0]);
        C[n].d1 = D[n];
        C[n].d2 = D[0];
        return C;
    }

    public void removePoint(int x, int y, double tolerance) {
        int i;
        if (this.nPoints <= 3) {
            return;
        }
        double min_distance = GeometricDistances.pointToPoint(this.virtualPoint[0].x, this.virtualPoint[0].y, x, y);
        int sel_i = -1;
        for (i = 1; i < this.nPoints; ++i) {
            double distance = GeometricDistances.pointToPoint(this.virtualPoint[i].x, this.virtualPoint[i].y, x, y);
            if (!(distance < min_distance)) continue;
            min_distance = distance;
            sel_i = i;
        }
        if (min_distance <= tolerance) {
            --this.nPoints;
            for (i = 0; i < this.nPoints; ++i) {
                if (i >= sel_i) {
                    this.virtualPoint[i].x = this.virtualPoint[i + 1].x;
                    this.virtualPoint[i].y = this.virtualPoint[i + 1].y;
                }
                this.changed = true;
            }
        }
    }

    @Override
    public void draw(GraphicsInterface g, MapCoordinates coordSys, Vector layerV) {
        if (!this.selectLayer(g, layerV)) {
            return;
        }
        this.drawText(g, coordSys, layerV, -1);
        if (this.changed) {
            this.changed = false;
            this.q = this.createComplexCurvePoly(new MapCoordinates(), g.createPolygon());
            this.p = this.createComplexCurvePoly(coordSys, g.createPolygon());
            CurveStorage c = this.createComplexCurve(coordSys);
            if (c == null) {
                return;
            }
            Vector<PointDouble> dd = c.dd;
            Vector<PointDouble> pp = c.pp;
            if (this.q == null) {
                return;
            }
            this.gp = g.createShape();
            this.gp.createGeneralPath(this.q.getNpoints());
            this.gp.moveTo((float)pp.get((int)0).x, (float)pp.get((int)0).y);
            int increment = 24;
            double derX1 = 0.0;
            double derX2 = 0.0;
            double derY1 = 0.0;
            double derY2 = 0.0;
            double w1 = 0.666667;
            double w2 = 0.666667;
            int j = 0;
            for (int i = 0; i < pp.size() - increment; i += increment) {
                derX1 = dd.get((int)j).x / 2.0 * w1;
                derY1 = dd.get((int)j).y / 2.0 * w1;
                derX2 = dd.get((int)(j + 1)).x / 2.0 * w2;
                derY2 = dd.get((int)(j + 1)).y / 2.0 * w2;
                ++j;
                this.gp.curveTo((float)(pp.get((int)i).x + derX1), (float)(pp.get((int)i).y + derY1), (float)(pp.get((int)(i + increment)).x - derX2), (float)(pp.get((int)(i + increment)).y - derY2), (float)pp.get((int)(i + increment)).x, (float)pp.get((int)(i + increment)).y);
            }
            if (this.isClosed) {
                this.gp.closePath();
            }
            this.w = (float)(Globals.lineWidth * coordSys.getXMagnitude());
            if (this.w < 0.5f) {
                this.w = 0.5f;
            }
        }
        if (this.p == null || this.gp == null) {
            return;
        }
        if (!g.hitClip(this.xmin, this.ymin, this.width, this.height)) {
            return;
        }
        g.applyStroke(this.w, this.dashStyle);
        if (this.isFilled) {
            g.fill(this.gp);
        }
        g.draw(this.gp);
        if (this.p.getNpoints() < 2) {
            return;
        }
        if (this.arrowStart || this.arrowEnd) {
            int h = coordSys.mapXi(this.arrowHalfWidth, this.arrowHalfWidth, false) - coordSys.mapXi(0.0, 0.0, false);
            int l = coordSys.mapXi(this.arrowLength, this.arrowLength, false) - coordSys.mapXi(0.0, 0.0, false);
            if (this.arrowStart && !this.isClosed) {
                Arrow.drawArrow(g, this.p.getXpoints()[0], this.p.getYpoints()[0], this.p.getXpoints()[1], this.p.getYpoints()[1], l, h, this.arrowStyle);
            }
            if (this.arrowEnd && !this.isClosed) {
                Arrow.drawArrow(g, this.p.getXpoints()[this.p.getNpoints() - 1], this.p.getYpoints()[this.p.getNpoints() - 1], this.p.getXpoints()[this.p.getNpoints() - 2], this.p.getYpoints()[this.p.getNpoints() - 2], l, h, this.arrowStyle);
            }
        }
    }

    @Override
    public void parseTokens(String[] tokens, int N) throws IOException {
        this.changed = true;
        if (tokens[0].equals("CP") || tokens[0].equals("CV")) {
            if (N < 6) {
                IOException E = new IOException("bad arguments on CP/CV");
                throw E;
            }
            int j = 1;
            int i = 0;
            int x1 = 0;
            int y1 = 0;
            this.isClosed = tokens[j++].equals("1");
            while (!(j >= N - 1 || j + 1 < N - 1 && tokens[j + 1].equals("FCJ"))) {
                x1 = Integer.parseInt(tokens[j++]);
                y1 = Integer.parseInt(tokens[j++]);
                ++i;
                this.addPoint(x1, y1);
            }
            this.nPoints = i;
            this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
            if (N > j) {
                this.parseLayer(tokens[j++]);
                if (N > j && tokens[j++].equals("FCJ")) {
                    int arrows;
                    this.arrowStart = ((arrows = Integer.parseInt(tokens[j++])) & 1) != 0;
                    this.arrowEnd = (arrows & 2) != 0;
                    this.arrowStyle = Integer.parseInt(tokens[j++]);
                    this.arrowLength = Integer.parseInt(tokens[j++]);
                    this.arrowHalfWidth = Integer.parseInt(tokens[j++]);
                    this.dashStyle = Integer.parseInt(tokens[j++]);
                    if (this.dashStyle >= 5) {
                        this.dashStyle = 4;
                    }
                    if (this.dashStyle < 0) {
                        this.dashStyle = 0;
                    }
                }
            }
            this.isFilled = tokens[0].equals("CP");
        } else {
            IOException E = new IOException("CP/CV: Invalid primitive:" + tokens[0] + " programming error?");
            throw E;
        }
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> v = super.getControls();
        ParameterDescription pd = new ParameterDescription();
        pd.parameter = this.isFilled;
        pd.description = Globals.messages.getString("ctrl_filled");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.isClosed;
        pd.description = Globals.messages.getString("ctrl_closed_curve");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.arrowStart;
        pd.description = Globals.messages.getString("ctrl_arrow_start");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.arrowEnd;
        pd.description = Globals.messages.getString("ctrl_arrow_end");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.arrowLength;
        pd.description = Globals.messages.getString("ctrl_arrow_length");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.arrowHalfWidth;
        pd.description = Globals.messages.getString("ctrl_arrow_half_width");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new ArrowInfo(this.arrowStyle);
        pd.description = Globals.messages.getString("ctrl_arrow_style");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new DashInfo(this.dashStyle);
        pd.description = Globals.messages.getString("ctrl_dash_style");
        pd.isExtension = true;
        v.add(pd);
        return v;
    }

    @Override
    public int setControls(Vector<ParameterDescription> v) {
        int i = super.setControls(v);
        ParameterDescription pd = v.get(i);
        ++i;
        if (pd.parameter instanceof Boolean) {
            this.isFilled = (Boolean)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.isClosed = (Boolean)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.arrowStart = (Boolean)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter 1!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.arrowEnd = (Boolean)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter 2!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Integer) {
            this.arrowLength = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter 3!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Integer) {
            this.arrowHalfWidth = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter 4!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof ArrowInfo) {
            this.arrowStyle = ((ArrowInfo)pd.parameter).style;
        } else {
            System.out.println("Warning: unexpected parameter 5!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof DashInfo) {
            this.dashStyle = ((DashInfo)pd.parameter).style;
        } else {
            System.out.println("Warning: unexpected parameter 6!" + pd);
        }
        if (this.dashStyle >= 5) {
            this.dashStyle = 4;
        }
        if (this.dashStyle < 0) {
            this.dashStyle = 0;
        }
        return i;
    }

    @Override
    public int getDistanceToPoint(int px, int py) {
        if (this.checkText(px, py)) {
            return 0;
        }
        int distance = 100;
        if (this.p == null) {
            return GeometricDistances.pointToPoint(this.virtualPoint[0].x, this.virtualPoint[0].y, px, py);
        }
        if (this.isFilled && this.q.contains(px, py)) {
            return 1;
        }
        for (int i = 0; i < this.q.getNpoints() - 1; ++i) {
            int d = GeometricDistances.pointToSegment(this.q.getXpoints()[i], this.q.getYpoints()[i], this.q.getXpoints()[i + 1], this.q.getYpoints()[i + 1], px, py);
            if (d >= distance) continue;
            distance = d;
        }
        return distance;
    }

    @Override
    public String toString(boolean extensions) {
        int arrows;
        StringBuffer temp = new StringBuffer(25);
        if (this.isFilled) {
            temp.append("CP ");
        } else {
            temp.append("CV ");
        }
        if (this.isClosed) {
            temp.append("1 ");
        } else {
            temp.append("0 ");
        }
        for (int i = 0; i < this.nPoints; ++i) {
            temp.append(this.virtualPoint[i].x);
            temp.append(" ");
            temp.append(this.virtualPoint[i].y);
            temp.append(" ");
        }
        temp.append(this.getLayer());
        temp.append("\n");
        String cmd = temp.toString();
        if (extensions && ((arrows = (this.arrowStart ? 1 : 0) | (this.arrowEnd ? 2 : 0)) > 0 || this.dashStyle > 0 || this.hasName() || this.hasValue())) {
            String text = "0";
            if (this.name.length() != 0 || this.value.length() != 0) {
                text = "1";
            }
            cmd = cmd + "FCJ " + arrows + " " + this.arrowStyle + " " + this.arrowLength + " " + this.arrowHalfWidth + " " + this.dashStyle + " " + text + "\n";
        }
        cmd = cmd + this.saveText(false);
        return cmd;
    }

    @Override
    public void export(ExportInterface exp, MapCoordinates cs) throws IOException {
        double[] xPoints = new double[this.nPoints];
        double[] yPoints = new double[this.nPoints];
        PointDouble[] vertices = new PointDouble[this.nPoints * 24 + 1];
        for (int i = 0; i < this.nPoints; ++i) {
            xPoints[i] = cs.mapXr(this.virtualPoint[i].x, this.virtualPoint[i].y);
            yPoints[i] = cs.mapYr(this.virtualPoint[i].x, this.virtualPoint[i].y);
            vertices[i] = new PointDouble();
            vertices[i].x = xPoints[i];
            vertices[i].y = yPoints[i];
        }
        if (!exp.exportCurve(vertices, this.nPoints, this.isFilled, this.isClosed, this.getLayer(), this.arrowStart, this.arrowEnd, this.arrowStyle, (int)((double)this.arrowLength * cs.getXMagnitude()), (int)((double)this.arrowHalfWidth * cs.getXMagnitude()), this.dashStyle, Globals.lineWidth * cs.getXMagnitude())) {
            this.exportAsPolygonInterface(xPoints, yPoints, vertices, exp, cs);
            int totalnP = this.q.getNpoints();
            if (this.q.getNpoints() > 2) {
                if (this.arrowStart && !this.isClosed) {
                    exp.exportArrow(vertices[0].x, vertices[0].y, vertices[1].x, vertices[1].y, (double)this.arrowLength * cs.getXMagnitude(), (double)this.arrowHalfWidth * cs.getXMagnitude(), this.arrowStyle);
                }
                if (this.arrowEnd && !this.isClosed) {
                    exp.exportArrow(vertices[totalnP - 1].x, vertices[totalnP - 1].y, vertices[totalnP - 2].x, vertices[totalnP - 2].y, (double)this.arrowLength * cs.getXMagnitude(), (double)this.arrowHalfWidth * cs.getXMagnitude(), this.arrowStyle);
                }
            }
        }
        this.exportText(exp, cs, -1);
    }

    private void exportAsPolygonInterface(double[] xPoints, double[] yPoints, PointDouble[] vertices, ExportInterface exp, MapCoordinates cs) throws IOException {
        int i;
        Cubic[] Y;
        Cubic[] X;
        if (this.isClosed) {
            X = this.calcNaturalCubicClosed(this.nPoints - 1, xPoints);
            Y = this.calcNaturalCubicClosed(this.nPoints - 1, yPoints);
        } else {
            X = this.calcNaturalCubic(this.nPoints - 1, xPoints);
            Y = this.calcNaturalCubic(this.nPoints - 1, yPoints);
        }
        if (X == null || Y == null) {
            return;
        }
        vertices[0] = new PointDouble();
        vertices[0].x = X[0].eval(0.0);
        vertices[0].y = Y[0].eval(0.0);
        for (i = 0; i < X.length; ++i) {
            for (int j = 1; j <= 24; ++j) {
                double u = (double)j / 24.0;
                vertices[i * 24 + j] = new PointDouble();
                vertices[i * 24 + j].x = X[i].eval(u);
                vertices[i * 24 + j].y = Y[i].eval(u);
            }
        }
        vertices[X.length * 24] = new PointDouble();
        vertices[X.length * 24].x = X[X.length - 1].eval(1.0);
        vertices[X.length * 24].y = Y[X.length - 1].eval(1.0);
        if (this.isClosed) {
            exp.exportPolygon(vertices, X.length * 24 + 1, this.isFilled, this.getLayer(), this.dashStyle, Globals.lineWidth * cs.getXMagnitude());
        } else {
            for (i = 1; i < X.length * 24 + 1; ++i) {
                exp.exportLine(vertices[i - 1].x, vertices[i - 1].y, vertices[i].x, vertices[i].y, this.getLayer(), false, false, 0, 0, 0, this.dashStyle, Globals.lineWidth * cs.getXMagnitude());
            }
        }
    }

    @Override
    public int getNameVirtualPointNumber() {
        return this.nPoints;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return this.nPoints + 1;
    }
}

