/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import circuit.controllers.EditorActions;
import circuit.controllers.ParserActions;
import circuit.model.DrawingModel;
import circuit.views.Drawing;
import circuit.views.Export;
import dialogs.ParameterDescription;
import export.ExportInterface;
import geom.MapCoordinates;
import globals.Globals;
import graphic.GraphicsInterface;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import layers.LayerDesc;
import primitives.GraphicPrimitive;
import primitives.MacroDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitiveMacro
extends GraphicPrimitive {
    static final int N_POINTS = 3;
    private final Map<String, MacroDesc> library;
    private final Vector<LayerDesc> layers;
    private int o;
    private boolean m;
    private boolean drawOnlyPads;
    private int drawOnlyLayer;
    private boolean alreadyExported;
    private DrawingModel macro;
    private final MapCoordinates macroCoord;
    private boolean selected;
    private String macroName;
    private String macroDesc;
    private boolean exportInvisible;
    private Drawing drawingAgent;
    private int x1;
    private int y1;

    public void setExportInvisible(boolean s) {
        this.exportInvisible = s;
    }

    @Override
    public int getControlPointNumber() {
        return 3;
    }

    public PrimitiveMacro(Map<String, MacroDesc> lib, Vector<LayerDesc> l, String f, int size) {
        this.library = lib;
        this.layers = l;
        this.drawOnlyPads = false;
        this.drawOnlyLayer = -1;
        this.macro = new DrawingModel();
        this.macroCoord = new MapCoordinates();
        this.changed = true;
        this.initPrimitive(-1, f, size);
        this.macroStore(this.layers);
    }

    public PrimitiveMacro(Map<String, MacroDesc> lib, Vector<LayerDesc> l, int x, int y, String key_t, String na, int xa, int ya, String va, int xv, int yv, String macroF, int macroS, int oo, boolean mm) throws IOException {
        this.initPrimitive(-1, macroF, macroS);
        this.library = lib;
        this.layers = l;
        String key = key_t.toLowerCase(new Locale("en"));
        this.macro = new DrawingModel();
        this.macroCoord = new MapCoordinates();
        this.changed = true;
        this.setMacroFontSize(macroS);
        this.o = oo;
        this.m = mm;
        this.virtualPoint[0].x = x;
        this.virtualPoint[0].y = y;
        this.virtualPoint[1].x = xa;
        this.virtualPoint[1].y = ya;
        this.virtualPoint[2].x = xv;
        this.virtualPoint[2].y = yv;
        this.name = na;
        this.value = va;
        MacroDesc macro = this.library.get(key);
        if (macro == null) {
            IOException G = new IOException("Unrecognized macro " + key);
            throw G;
        }
        this.macroDesc = macro.description;
        this.macroName = key;
        this.macroFont = macroF;
        this.macroStore(this.layers);
    }

    @Override
    public boolean containsLayer(int l) {
        return this.macro.containsLayer(l);
    }

    private void drawMacroContents(GraphicsInterface g, MapCoordinates coordSys, Vector layerV) {
        if (this.changed) {
            this.changed = false;
            this.x1 = this.virtualPoint[0].x;
            this.y1 = this.virtualPoint[0].y;
            this.macroCoord.setXMagnitude(coordSys.getXMagnitude());
            this.macroCoord.setYMagnitude(coordSys.getYMagnitude());
            this.macroCoord.setXCenter(coordSys.mapXr(this.x1, this.y1));
            this.macroCoord.setYCenter(coordSys.mapYr(this.x1, this.y1));
            this.macroCoord.setOrientation((this.o + coordSys.getOrientation()) % 4);
            this.macroCoord.mirror = this.m ^ coordSys.mirror;
            this.macroCoord.isMacro = true;
            this.macroCoord.resetMinMax();
            this.macro.setChanged(true);
        }
        EditorActions edt = new EditorActions(this.macro, null);
        if (this.getSelected()) {
            edt.setSelectionAll(true);
            this.selected = true;
        } else if (this.selected) {
            edt.setSelectionAll(false);
            this.selected = false;
        }
        this.macro.setDrawOnlyLayer(this.drawOnlyLayer);
        this.macro.setDrawOnlyPads(this.drawOnlyPads);
        this.drawingAgent = new Drawing(this.macro);
        this.drawingAgent.draw(g, this.macroCoord);
        if (this.macroCoord.getXMax() > this.macroCoord.getXMin() && this.macroCoord.getYMax() > this.macroCoord.getYMin()) {
            coordSys.trackPoint(this.macroCoord.getXMax(), this.macroCoord.getYMax());
            coordSys.trackPoint(this.macroCoord.getXMin(), this.macroCoord.getYMin());
        }
    }

    @Override
    public void setChanged(boolean c) {
        super.setChanged(c);
        this.macro.setChanged(c);
    }

    private void macroStore(Vector<LayerDesc> layerV) {
        this.macro.setLibrary(this.library);
        this.macro.setLayers(layerV);
        this.changed = true;
        if (this.macroDesc != null) {
            ParserActions pa = new ParserActions(this.macro);
            pa.parseString(new StringBuffer(this.macroDesc));
        }
    }

    public void setLayers(Vector<LayerDesc> layerV) {
        this.macro.setLayers(layerV);
    }

    @Override
    public void draw(GraphicsInterface g, MapCoordinates coordSys, Vector layerV) {
        this.setLayer(0);
        if (this.selectLayer(g, layerV)) {
            this.drawText(g, coordSys, layerV, this.drawOnlyLayer);
        }
        this.drawMacroContents(g, coordSys, layerV);
    }

    @Override
    public void setDrawOnlyPads(boolean pd) {
        this.drawOnlyPads = pd;
    }

    @Override
    public void setDrawOnlyLayer(int la) {
        this.drawOnlyLayer = la;
    }

    @Override
    public int getMaxLayer() {
        return this.macro.getMaxLayer();
    }

    @Override
    public void parseTokens(String[] tokens, int N) throws IOException {
        MacroDesc macro;
        this.changed = true;
        if (tokens[0].equals("MC")) {
            if (N < 6) {
                IOException E = new IOException("bad arguments on MC");
                throw E;
            }
            this.virtualPoint[0].x = Integer.parseInt(tokens[1]);
            this.virtualPoint[0].y = Integer.parseInt(tokens[2]);
            this.virtualPoint[1].x = this.virtualPoint[0].x + 10;
            this.virtualPoint[1].y = this.virtualPoint[0].y + 10;
            this.virtualPoint[2].x = this.virtualPoint[0].x + 10;
            this.virtualPoint[2].y = this.virtualPoint[0].y + 5;
            this.o = Integer.parseInt(tokens[3]);
            this.m = Integer.parseInt(tokens[4]) == 1;
            this.macroName = tokens[5];
            for (int i = 6; i < N; ++i) {
                this.macroName = this.macroName + " " + tokens[i];
            }
            this.macroName = this.macroName.toLowerCase(new Locale("en"));
            macro = this.library.get(this.macroName);
            if (macro == null) {
                IOException G = new IOException("Unrecognized macro '" + this.macroName + "'");
                throw G;
            }
        } else {
            IOException E = new IOException("MC: Invalid primitive:" + tokens[0] + " programming error?");
            throw E;
        }
        this.macroDesc = macro.description;
        this.macroStore(this.layers);
    }

    @Override
    public boolean needsHoles() {
        return this.drawingAgent.getNeedHoles();
    }

    @Override
    public int getDistanceToPoint(int px, int py) {
        int x1 = this.virtualPoint[0].x;
        int y1 = this.virtualPoint[0].y;
        int dt = Integer.MAX_VALUE;
        if (this.checkText(px, py)) {
            return 0;
        }
        int vx = px - x1 + 100;
        int vy = py - y1 + 100;
        if (this.m) {
            switch (this.o) {
                case 1: {
                    vx = py - y1 + 100;
                    vy = px - x1 + 100;
                    break;
                }
                case 2: {
                    vx = px - x1 + 100;
                    vy = -(py - y1) + 100;
                    break;
                }
                case 3: {
                    vx = -(py - y1) + 100;
                    vy = -(px - x1) + 100;
                    break;
                }
                case 0: {
                    vx = -(px - x1) + 100;
                    vy = py - y1 + 100;
                    break;
                }
                default: {
                    vx = 0;
                    vy = 0;
                    break;
                }
            }
        } else {
            switch (this.o) {
                case 1: {
                    vx = py - y1 + 100;
                    vy = -(px - x1) + 100;
                    break;
                }
                case 2: {
                    vx = -(px - x1) + 100;
                    vy = -(py - y1) + 100;
                    break;
                }
                case 3: {
                    vx = -(py - y1) + 100;
                    vy = px - x1 + 100;
                    break;
                }
                case 0: {
                    vx = px - x1 + 100;
                    vy = py - y1 + 100;
                    break;
                }
                default: {
                    vx = 0;
                    vy = 0;
                }
            }
        }
        if (this.macroDesc != null) {
            EditorActions edt = new EditorActions(this.macro, null);
            return Math.min(edt.distancePrimitive(vx, vy), dt);
        }
        System.out.println("1-Unrecognized macro WARNING this can be a programming problem...");
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean selectRect(int px, int py, int w, int h) {
        EditorActions edt = new EditorActions(this.macro, null);
        if (edt.distancePrimitive(0, 0) < Integer.MAX_VALUE) {
            return super.selectRect(px, py, w, h);
        }
        return false;
    }

    public int getOrientation() {
        return this.o;
    }

    public boolean isMirrored() {
        return this.m;
    }

    @Override
    public void rotatePrimitive(boolean bCounterClockWise, int ix, int iy) {
        super.rotatePrimitive(bCounterClockWise, ix, iy);
        if (bCounterClockWise) {
            this.o = (this.o + 3) % 4;
        } else {
            ++this.o;
            this.o %= 4;
        }
        this.changed = true;
    }

    @Override
    public void mirrorPrimitive(int xpos) {
        super.mirrorPrimitive(xpos);
        this.m ^= true;
        this.changed = true;
    }

    @Override
    public String toString(boolean extensions) {
        String mirror = "0";
        if (this.m) {
            mirror = "1";
        }
        String s = "MC " + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.o + " " + mirror + " " + this.macroName + "\n";
        s = s + this.saveText(extensions);
        return s;
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> v = new Vector<ParameterDescription>(10);
        ParameterDescription pd = new ParameterDescription();
        pd.parameter = this.name;
        pd.description = Globals.messages.getString("ctrl_name");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.value;
        pd.description = Globals.messages.getString("ctrl_value");
        pd.isExtension = true;
        v.add(pd);
        return v;
    }

    @Override
    public int setControls(Vector<ParameterDescription> v) {
        int i = 0;
        this.changed = true;
        ParameterDescription pd = v.get(i);
        ++i;
        if (pd.parameter instanceof String) {
            this.name = (String)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i);
        ++i;
        if (pd.parameter instanceof String) {
            this.value = (String)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        return i;
    }

    public void resetExport() {
        this.alreadyExported = false;
    }

    @Override
    public void export(ExportInterface exp, MapCoordinates cs) throws IOException {
        if (this.alreadyExported) {
            return;
        }
        if (exp.exportMacro(cs.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), cs.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), this.m, this.o * 90, this.macroName, this.macroDesc, this.name, cs.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y), cs.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y), this.value, cs.mapX(this.virtualPoint[2].x, this.virtualPoint[2].y), cs.mapY(this.virtualPoint[2].x, this.virtualPoint[2].y), this.macroFont, (int)(cs.mapYr(this.getMacroFontSize(), this.getMacroFontSize()) - cs.mapYr(0.0, 0.0)), this.library)) {
            this.alreadyExported = true;
            return;
        }
        int x1 = this.virtualPoint[0].x;
        int y1 = this.virtualPoint[0].y;
        MapCoordinates macroCoord = new MapCoordinates();
        macroCoord.setXMagnitude(cs.getXMagnitude());
        macroCoord.setYMagnitude(cs.getYMagnitude());
        macroCoord.setXCenter(cs.mapXr(x1, y1));
        macroCoord.setYCenter(cs.mapYr(x1, y1));
        macroCoord.setOrientation((this.o + cs.getOrientation()) % 4);
        macroCoord.mirror = this.m ^ cs.mirror;
        macroCoord.isMacro = true;
        this.macro.setDrawOnlyLayer(this.drawOnlyLayer);
        EditorActions edt = new EditorActions(this.macro, null);
        if (this.getSelected()) {
            edt.setSelectionAll(true);
        }
        this.macro.setDrawOnlyPads(this.drawOnlyPads);
        new Export(this.macro).exportDrawing(exp, false, this.exportInvisible, macroCoord);
        this.exportText(exp, cs, this.drawOnlyLayer);
    }

    @Override
    public int getNameVirtualPointNumber() {
        return 1;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return 2;
    }

    public String getMacroDesc() {
        return this.macroDesc;
    }

    public void setMacroDesc(String macroDesc) {
        this.macroDesc = macroDesc;
    }
}

