/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.graph;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.jaxodraw.graph.JaxoSaveGraph;
import net.sf.jaxodraw.object.JaxoHandle;
import net.sf.jaxodraw.object.JaxoList;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectList;
import net.sf.jaxodraw.object.group.JaxoGroup;
import net.sf.jaxodraw.object.text.JaxoLatexText;
import net.sf.jaxodraw.object.text.JaxoPSText;
import net.sf.jaxodraw.util.JaxoGeometry;
import net.sf.jaxodraw.util.JaxoInfo;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxoGraph {
    private final JaxoSaveGraph saveGraph;
    private String saveFileName;
    private boolean graphIsSaved = true;

    public JaxoGraph() {
        this(new JaxoSaveGraph(), "");
    }

    public JaxoGraph(JaxoList<JaxoObject> list) {
        this(new JaxoSaveGraph(list), "");
    }

    public JaxoGraph(JaxoList<JaxoObject> list, String describe) {
        this(new JaxoSaveGraph(list, describe), "");
    }

    public JaxoGraph(JaxoList<JaxoObject> list, String describe, String saveFile) {
        this(new JaxoSaveGraph(list, describe), saveFile);
    }

    private JaxoGraph(JaxoSaveGraph graph, String name) {
        if (name == null) {
            throw new IllegalArgumentException("filename cannot be null!");
        }
        this.saveGraph = graph;
        this.saveGraph.setJaxoDrawVersion(JaxoInfo.VERSION_NUMBER);
        this.saveFileName = name;
    }

    public final JaxoSaveGraph getSaveGraph() {
        return this.saveGraph;
    }

    public final void setSaveGraph(JaxoSaveGraph newSaveGraph) {
        this.saveGraph.clearAll();
        this.saveGraph.setPackageList(newSaveGraph.getPackageList());
        this.saveGraph.setDescription(newSaveGraph.getDescription());
        this.saveGraph.setObjectList(newSaveGraph.getObjectList());
    }

    public final JaxoList<JaxoObject> getObjectList() {
        return this.saveGraph.getObjectList();
    }

    public final void setObjectList(JaxoList<JaxoObject> list) {
        this.saveGraph.setObjectList(list);
        this.setSaved(false);
    }

    public final List<String> getPackageList() {
        return this.saveGraph.getPackageList();
    }

    public final void setPackageList(List<String> list) {
        this.saveGraph.setPackageList(list);
        this.setSaved(false);
    }

    public final void setDescription(String describe) {
        boolean equal;
        String old = this.saveGraph.getDescription();
        boolean bl = old == null ? describe == null : (equal = old.equals(describe));
        if (!equal) {
            this.saveGraph.setDescription(describe);
            this.setSaved(false);
        }
    }

    public final String getDescription() {
        return this.saveGraph.getDescription();
    }

    public final boolean isSaved() {
        return this.graphIsSaved;
    }

    public final void setSaved(boolean isSaved) {
        this.graphIsSaved = isSaved;
    }

    public final void setSaveFileName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("filename cannot be null!");
        }
        this.saveFileName = fileName;
    }

    public final String getSaveFileName() {
        return this.saveFileName;
    }

    public final JaxoObject listElementAt(int i) {
        return this.saveGraph.listElementAt(i);
    }

    public final int listSize() {
        return this.saveGraph.listSize();
    }

    public final void foreground(JaxoObject object) {
        boolean isLastElement = this.saveGraph.foreground(object);
        if (!isLastElement) {
            this.setSaved(false);
        }
    }

    public final void move(int index, int newIndex) {
        this.saveGraph.move(index, newIndex);
        if (index != newIndex) {
            this.setSaved(false);
        }
    }

    public final void replace(JaxoObject old, JaxoObject o) {
        int index;
        if (!o.isCopy(old) && (index = this.saveGraph.getObjectList().indexOf(old)) != -1) {
            this.saveGraph.getObjectList().set(index, o);
            this.setSaved(false);
        }
    }

    public final void background(JaxoObject object) {
        boolean isFirstElement = this.saveGraph.background(object);
        if (!isFirstElement) {
            this.setSaved(false);
        }
    }

    public final void delete(JaxoObject object) {
        boolean modified = this.saveGraph.delete(object);
        if (modified) {
            this.setSaved(false);
        }
    }

    public final void deleteMarkedObjects() {
        boolean modified = this.saveGraph.deleteMarkedObjects();
        if (modified) {
            this.setSaved(false);
        }
    }

    public final void deleteAll(Collection<JaxoObject> objects) {
        boolean modified = this.saveGraph.deleteAll(objects);
        if (modified) {
            this.setSaved(false);
        }
    }

    public final void addObject(JaxoObject object) {
        boolean modified = this.saveGraph.addObject(object);
        if (modified) {
            this.setSaved(false);
        }
    }

    public final void addObject(int index, JaxoObject object) {
        boolean modified = this.saveGraph.addObject(index, object);
        if (modified) {
            this.setSaved(false);
        }
    }

    public final void clear() {
        boolean listIsEmpty = this.saveGraph.clear();
        if (!listIsEmpty) {
            this.setSaved(false);
        }
    }

    public final void clearAll() {
        boolean fileNameEmpty;
        boolean graphNotModified = this.saveGraph.clearAll();
        boolean bl = fileNameEmpty = this.saveFileName.length() == 0;
        if (!graphNotModified || !fileNameEmpty) {
            this.setSaveFileName("");
            this.setSaved(false);
        }
    }

    public final Rectangle getBounds() {
        return this.saveGraph.getBounds();
    }

    public final Rectangle getBoundsExcept(Collection<JaxoObject> except) {
        return this.saveGraph.getBoundsExcept(except);
    }

    public final Rectangle getBounds(Rectangle inside) {
        return this.saveGraph.getBounds(inside);
    }

    public static final JaxoList<JaxoObject> copyFrom(JaxoList<JaxoObject> v) {
        JaxoObjectList<JaxoObject> temp = new JaxoObjectList<JaxoObject>(v.size());
        for (int i = 0; i < v.size(); ++i) {
            JaxoObject cur = (JaxoObject)v.get(i);
            temp.add(cur.copy());
        }
        return temp;
    }

    public final boolean containsPSText() {
        return this.containsInstanceOf(JaxoPSText.class);
    }

    public final boolean containsLatexText() {
        return this.containsInstanceOf(JaxoLatexText.class);
    }

    public final boolean containsInstanceOf(Class<?> clazz) {
        boolean contains = false;
        JaxoList<JaxoObject> templist = this.getObjectList();
        for (int j = 0; j < templist.size(); ++j) {
            JaxoObject ob = (JaxoObject)templist.get(j);
            if (clazz.isInstance(ob)) {
                contains = true;
                break;
            }
            if (ob instanceof JaxoGroup && (contains = ((JaxoGroup)ob).containsInstanceOf(clazz))) break;
        }
        return contains;
    }

    public final boolean containsMarkedGroups() {
        boolean contains = false;
        JaxoList<JaxoObject> templist = this.getObjectList();
        for (int j = 0; j < templist.size(); ++j) {
            JaxoObject ob = (JaxoObject)templist.get(j);
            if (!(ob instanceof JaxoGroup) || !ob.isMarked()) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public final boolean containsGroups() {
        boolean contains = false;
        JaxoList<JaxoObject> templist = this.getObjectList();
        for (int j = 0; j < templist.size(); ++j) {
            JaxoObject ob = (JaxoObject)templist.get(j);
            if (!(ob instanceof JaxoGroup)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public final boolean containsMarkedObjects() {
        JaxoList<JaxoObject> templist = this.getObjectList();
        for (int j = 0; j < templist.size(); ++j) {
            JaxoObject ob = (JaxoObject)templist.get(j);
            if (!ob.isMarked()) continue;
            return true;
        }
        return false;
    }

    public JaxoList<JaxoObject> getMarkedObjects() {
        JaxoObjectList<JaxoObject> result = new JaxoObjectList<JaxoObject>(5);
        for (JaxoObject o : this.getObjectList()) {
            if (!o.isMarked()) continue;
            result.add(o);
        }
        return result;
    }

    public JaxoList<JaxoObject> getCopyOfMarkedObjects() {
        JaxoObjectList<JaxoObject> result = new JaxoObjectList<JaxoObject>(5);
        for (JaxoObject o : this.getObjectList()) {
            if (!o.isMarked()) continue;
            result.add(o.copy());
        }
        return result;
    }

    public boolean hasMoreMarkedObjectsThan(int less) {
        int count = 0;
        for (JaxoObject o : this.getObjectList()) {
            if (!o.isMarked() || ++count <= less) continue;
            return true;
        }
        return false;
    }

    public void paint(JaxoGraphics2D g) {
        this.getObjectList().paint(g);
    }

    public void paintClipped(JaxoGraphics2D g) {
        this.getObjectList().paintClipped(g);
    }

    public final void paintHandles(JaxoGraphics2D g2, JaxoHandle h, int editMode) {
        for (int j = 0; j < this.listSize(); ++j) {
            JaxoObject jaxoOb = this.listElementAt(j);
            jaxoOb.paintHandles(g2, h, editMode);
        }
    }

    public final void setAsMarked(boolean marked) {
        for (int i = 0; i < this.listSize(); ++i) {
            JaxoObject ob = this.listElementAt(i);
            ob.setAsMarked(marked);
        }
    }

    public final JaxoGraph copyOf() {
        JaxoGraph newGraph = new JaxoGraph();
        JaxoSaveGraph newSaveGraph = this.saveGraph.copyOf();
        newGraph.setSaveGraph(newSaveGraph);
        newGraph.setSaved(this.isSaved());
        newGraph.setSaveFileName(this.getSaveFileName());
        return newGraph;
    }

    public final void breakAllGroups() {
        boolean wasSaved = this.isSaved();
        for (int j = 0; j < this.listSize(); ++j) {
            JaxoObject ob = this.listElementAt(j);
            if (!(ob instanceof JaxoGroup)) continue;
            JaxoGroup tempg = (JaxoGroup)ob;
            for (int i = 0; i < tempg.size(); ++i) {
                JaxoObject tempob = (JaxoObject)tempg.getObjectList().get(i);
                tempob.setAsMarked(false);
                this.addObject(j + i, tempob);
            }
            this.delete(tempg);
        }
        if (this.containsGroups()) {
            this.breakAllGroups();
        }
        this.setSaved(wasSaved);
    }

    public final void objectsToForeground() {
        int marked = this.listSize() - 1;
        for (int j = this.listSize() - 1; j > -1; --j) {
            JaxoObject ob = this.listElementAt(j);
            if (!ob.isMarked()) continue;
            this.move(j, marked);
            --marked;
        }
    }

    public final void objectsToBackground() {
        int marked = 0;
        for (int j = 0; j < this.listSize(); ++j) {
            JaxoObject ob = this.listElementAt(j);
            if (!ob.isMarked()) continue;
            this.move(j, marked);
            ++marked;
        }
    }

    public final JaxoObject getNearestObject(int x, int y) {
        int element = -1;
        if (this.listSize() != 0) {
            float distance = 0.0f;
            float smallest = 0.0f;
            for (int j = 0; j < this.listSize(); ++j) {
                JaxoObject ob = this.listElementAt(j);
                distance = ob.smallestDistanceTo(x, y);
                if (j == 0) {
                    smallest = distance;
                    element = j;
                    continue;
                }
                if (!(distance < smallest)) continue;
                smallest = distance;
                element = j;
            }
        }
        return this.listElementAt(element);
    }

    public boolean ungroupMarkedObjects() {
        boolean modified = false;
        ListIterator i = this.getObjectList().listIterator();
        while (i.hasNext()) {
            JaxoObject o = (JaxoObject)i.next();
            if (!o.isMarked() || !(o instanceof JaxoGroup)) continue;
            modified = true;
            i.remove();
            Iterator j = ((JaxoGroup)o).getObjectList().iterator();
            while (j.hasNext()) {
                i.add(j.next());
            }
        }
        return modified;
    }

    public boolean groupMarkedObjects() {
        boolean modified = false;
        JaxoList<JaxoObject> groupObjects = this.getMarkedObjects();
        if (groupObjects.size() > 1) {
            Rectangle groupBounds = JaxoGeometry.getBounds(groupObjects);
            JaxoGroup newGroup = new JaxoGroup();
            newGroup.setObjectList(groupObjects);
            newGroup.setX(groupBounds.x);
            newGroup.setY(groupBounds.y);
            newGroup.setX2(groupBounds.x + groupBounds.width);
            newGroup.setY2(groupBounds.y + groupBounds.height);
            this.deleteAll(groupObjects);
            this.addObject(newGroup);
            modified = true;
        }
        return modified;
    }

    public boolean ungroup(JaxoObject ob) {
        boolean modified = false;
        if (ob instanceof JaxoGroup && this.getObjectList().contains(ob)) {
            JaxoGroup g = (JaxoGroup)ob;
            for (JaxoObject o : g.getObjectList()) {
                o.setAsMarked(false);
                this.addObject(o);
            }
            this.delete(g);
            modified = true;
        }
        return modified;
    }
}

