/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sf.jaxodraw.gui.JaxoCanvas;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoCanvasEventListener
implements MouseListener,
MouseMotionListener,
PropertyChangeListener {
    private final JaxoCanvas theCanvas;
    private final PropertyChangeListenerProxy mouseLocationListener;
    private int currentMode;
    private Point mouseLocation;
    private final Timer scrollTimer;
    private final Point last = new Point();
    private final Point lastOnScreen = new Point();
    private transient MouseEvent lastDraggedEvent;

    public void setMode(int mode) {
        this.currentMode = mode;
    }

    public JaxoCanvasEventListener(JaxoCanvas canvas) {
        this.theCanvas = canvas;
        this.mouseLocationListener = new PropertyChangeListenerProxy("Jaxo.mouseLocation", this.theCanvas);
        this.scrollTimer = new Timer(250, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JaxoCanvasEventListener.this.theCanvas.revalidateCanvasFast();
                JaxoCanvasEventListener.this.theCanvas.scrollRectToVisible(JaxoCanvasEventListener.this.toComponentCoordinates(new Rectangle(((JaxoCanvasEventListener)JaxoCanvasEventListener.this).last.x - 10, ((JaxoCanvasEventListener)JaxoCanvasEventListener.this).last.y - 10, 20, 20)));
                if (JaxoCanvasEventListener.this.lastDraggedEvent != null) {
                    Point p = JaxoCanvasEventListener.this.theCanvas.getLocationOnScreen();
                    JaxoCanvasEventListener.this.mouseDragged(new MouseEvent(JaxoCanvasEventListener.this.lastDraggedEvent.getComponent(), JaxoCanvasEventListener.this.lastDraggedEvent.getID(), JaxoCanvasEventListener.this.lastDraggedEvent.getWhen(), JaxoCanvasEventListener.this.lastDraggedEvent.getModifiers(), ((JaxoCanvasEventListener)JaxoCanvasEventListener.this).lastOnScreen.x - p.x, ((JaxoCanvasEventListener)JaxoCanvasEventListener.this).lastOnScreen.y - p.y, JaxoCanvasEventListener.this.lastDraggedEvent.getClickCount(), JaxoCanvasEventListener.this.lastDraggedEvent.isPopupTrigger(), JaxoCanvasEventListener.this.lastDraggedEvent.getButton()));
                }
            }
        });
        this.scrollTimer.setInitialDelay(0);
    }

    public void mouseClicked(MouseEvent e) {
        if (this.currentMode == 460 && JaxoUtils.isButton2(e)) {
            if (!this.theCanvas.unMarkGraph()) {
                this.theCanvas.repaint();
            }
        } else if (JaxoUtils.isButton3(e) && JaxoUtils.isDoubleClick(e)) {
            this.theCanvas.editNearestObject(this.toGraphCoordinates(e.getPoint()));
        }
    }

    public void mousePressed(MouseEvent e) {
        this.scrollTimer.start();
        if (this.currentMode == 3162) {
            return;
        }
        Point p = this.toGraphCoordinates(e.getPoint());
        if (JaxoUtils.isButton3(e)) {
            this.theCanvas.initiateSelect(p);
        } else if (JaxoUtils.isButton1(e)) {
            this.theCanvas.initiateEdit(p);
        }
        this.last.setLocation(p);
        this.lastOnScreen.setLocation(e.getPoint());
        SwingUtilities.convertPointToScreen(this.lastOnScreen, this.theCanvas.asComponent());
    }

    public void mouseReleased(MouseEvent e) {
        this.lastDraggedEvent = null;
        this.scrollTimer.stop();
        if (this.currentMode == 3162) {
            return;
        }
        Point p = this.toGraphCoordinates(e.getPoint());
        if (JaxoUtils.isButton3(e)) {
            this.theCanvas.finalizeSelect(p);
        } else if (JaxoUtils.isButton1(e)) {
            this.theCanvas.finalizeEdit();
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.setMouseLocation(this.toGraphCoordinates(e.getPoint()), true);
    }

    public void mouseExited(MouseEvent e) {
        this.setMouseLocation(null, true);
    }

    public void mouseDragged(MouseEvent e) {
        Point p = this.toGraphCoordinates(e.getPoint());
        this.setMouseLocation(p, true);
        this.lastDraggedEvent = e;
        if (this.currentMode == 3162) {
            return;
        }
        if (JaxoUtils.isButton3(e)) {
            this.theCanvas.continueSelect(p);
        } else if (JaxoUtils.isButton1(e)) {
            this.theCanvas.continueEdit(p, this.last);
        }
        this.last.setLocation(p);
        this.lastOnScreen.setLocation(e.getPoint());
        SwingUtilities.convertPointToScreen(this.lastOnScreen, this.theCanvas.asComponent());
    }

    public void mouseMoved(MouseEvent e) {
        Point p = this.toGraphCoordinates(e.getPoint());
        this.setMouseLocation(p, true);
        this.theCanvas.updatePointsAid(p);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("Jaxo.mode".equals(evt.getPropertyName())) {
            this.currentMode = (Integer)evt.getNewValue();
        } else if ("Jaxo.mouseLocation".equals(evt.getPropertyName())) {
            this.setMouseLocation((Point)evt.getNewValue(), false);
        }
    }

    private Point toGraphCoordinates(Point p) {
        return this.theCanvas.toGraphCoordinates(p);
    }

    private Rectangle toComponentCoordinates(Rectangle r) {
        return this.theCanvas.toComponentCoordinates(r);
    }

    private void setMouseLocation(Point value, boolean notify) {
        if (value == null ? this.mouseLocation != null : !value.equals(this.mouseLocation)) {
            Point old = this.mouseLocation;
            Point point = this.mouseLocation = value == null ? null : (Point)value.clone();
            if (notify) {
                this.mouseLocationListener.propertyChange(new PropertyChangeEvent(this, "Jaxo.mouseLocation", old, this.mouseLocation == null ? null : this.mouseLocation.clone()));
            }
        }
    }
}

