/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.menu;

import java.beans.PropertyChangeEvent;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import net.sf.jaxodraw.gui.menu.JaxoMenu;
import net.sf.jaxodraw.gui.menu.JaxoMenuUtils;
import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoPrefs;

public class DefaultMenu
extends JaxoMenu {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final int NOF_DEFAULTS = JaxoConstants.defaultModes().length;
    private final JMenuItem[] defMIs = new JMenuItem[NOF_DEFAULTS];

    public DefaultMenu(int initValue) {
        ButtonGroup g = new ButtonGroup();
        for (int i = 0; i < NOF_DEFAULTS; ++i) {
            this.defMIs[i] = new JRadioButtonMenuItem(JaxoLanguage.translate(JaxoConstants.defaultActionKeys()[i]));
            g.add(this.defMIs[i]);
            JaxoMenuUtils.setActionCommand(this.defMIs[i], JaxoConstants.defaultModes()[i]);
            this.add(this.defMIs[i]);
            if (i != this.getDefIndex(6201) && i != this.getDefIndex(6222)) continue;
            this.addSeparator();
        }
        this.updateDefaultAction(initValue);
        this.updateLanguage();
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if ("Jaxo.defaultAction".equals(name)) {
            this.updateDefaultAction((Integer)e.getNewValue());
        }
    }

    public final void updateLanguage() {
        int j = this.getDefIndex(JaxoPrefs.getIntPref("prefDEFAULTACTION"));
        this.setText(JaxoLanguage.message("JaxoOptionsMenu.defaultAction%0", JaxoLanguage.translate(JaxoConstants.defaultActionKeys()[j])));
        for (int i = 0; i < NOF_DEFAULTS; ++i) {
            this.defMIs[i].setText(JaxoLanguage.translate(JaxoConstants.defaultActionKeys()[i]));
        }
    }

    private void updateDefaultAction(int value) {
        int newValue = value;
        if (!JaxoConstants.isDefaultMode(value)) {
            newValue = 6201;
        }
        int i = this.getDefIndex(newValue);
        this.setText(JaxoLanguage.message("JaxoOptionsMenu.defaultAction%0", JaxoLanguage.translate(JaxoConstants.defaultActionKeys()[i])));
        this.defMIs[i].setSelected(true);
    }

    private int getDefIndex(int value) {
        int j = NOF_DEFAULTS + 1;
        for (int jj = 0; jj < NOF_DEFAULTS; ++jj) {
            if (value != JaxoConstants.defaultModes()[jj]) continue;
            j = jj;
            break;
        }
        return j;
    }
}

