/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.util.JaxoDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxoLatexPackage
implements ListSelectionListener {
    private final JaxoDictionary language = new JaxoDictionary(JaxoLatexPackage.class);
    private final List<String> listVector;
    private JList list;
    private final DefaultListModel listModel;
    private JButton removeButton;
    private JTextField packageName;
    private JDialog dialog;
    private boolean cancelled;

    public JaxoLatexPackage(Component parent, List<String> vector) {
        this.listVector = vector;
        this.listModel = new DefaultListModel();
        for (int i = 0; i < this.listVector.size(); ++i) {
            this.listModel.add(i, this.listVector.get(i));
        }
        this.initComponents(parent);
    }

    private void initComponents(Component parent) {
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(0);
        this.list.addListSelectionListener(this);
        JScrollPane listScrollPane = new JScrollPane(this.list);
        ActionListener addPackage = new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                if (!JaxoLatexPackage.this.listModel.contains(JaxoLatexPackage.this.packageName.getText())) {
                    JaxoLatexPackage.this.listModel.addElement(JaxoLatexPackage.this.packageName.getText());
                    JaxoLatexPackage.this.list.setSelectedIndex(JaxoLatexPackage.this.listModel.getSize() - 1);
                }
            }
        };
        final JButton addButton = new JButton(this.language.value("/Add"));
        addButton.setEnabled(false);
        addButton.addActionListener(addPackage);
        this.removeButton = new JButton(this.language.value("/Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                JaxoLatexPackage.this.removeButtonClicked();
            }
        });
        this.removeButton.setEnabled(false);
        JButton okButton = new JButton(this.language.value("/OK"));
        okButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                JaxoLatexPackage.this.okButtonClicked();
            }
        });
        JButton cancelButton = new JButton(this.language.value("/Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                JaxoLatexPackage.this.cancelButtonClicked();
            }
        });
        this.packageName = new JTextField(10);
        this.packageName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            public void changedUpdate(DocumentEvent e) {
            }

            private void update() {
                addButton.setEnabled(JaxoLatexPackage.this.packageName.getDocument().getLength() > 0);
            }
        });
        this.packageName.addActionListener(addPackage);
        JPanel buttonPane = new JPanel();
        buttonPane.add(this.packageName);
        buttonPane.add(addButton);
        buttonPane.add(this.removeButton);
        buttonPane.add(okButton);
        buttonPane.add(cancelButton);
        this.dialog = JaxoDialogs.newDialog(parent, JaxoDialogs.translatedWindowTitle(this.language.value("title")), true);
        this.dialog.getContentPane().add((Component)listScrollPane, "Center");
        this.dialog.getContentPane().add((Component)buttonPane, "Last");
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
        this.cancelled = true;
        this.dialog.setVisible(true);
    }

    private void removeButtonClicked() {
        int index = this.list.getSelectedIndex();
        if (index == 0 || index == 1 || index == 2) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.listModel.remove(index);
        int size = this.listModel.getSize();
        if (size == 3) {
            this.removeButton.setEnabled(false);
        } else {
            if (index == size) {
                --index;
            }
            this.list.setSelectedIndex(index);
        }
    }

    @Override
    public final void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            int index = this.list.getSelectedIndex();
            if (index == -1) {
                this.removeButton.setEnabled(false);
                this.packageName.setText("");
            } else if (index == 0 || index == 1 || index == 2) {
                this.removeButton.setEnabled(false);
                this.packageName.setText("");
            } else {
                this.removeButton.setEnabled(true);
                String name = this.list.getSelectedValue().toString();
                this.packageName.setText(name);
            }
        }
    }

    public final boolean wasCancelled() {
        return this.cancelled;
    }

    public final List<String> getPackageList() {
        return this.listVector;
    }

    private void okButtonClicked() {
        this.cancelled = false;
        this.listVector.clear();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            this.listVector.add((String)this.listModel.getElementAt(i));
        }
        this.dialog.dispose();
    }

    private void cancelButtonClicked() {
        this.dialog.dispose();
    }
}

