/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.gui.panel.JaxoProgressDialog;
import net.sf.jaxodraw.io.JaxoPreview;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoInfo;
import net.sf.jaxodraw.util.JaxoLog;
import net.sf.jaxodraw.util.JaxoXsltTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxoUserGuide {
    private static final JaxoDictionary LANGUAGE = new JaxoDictionary(JaxoUserGuide.class);
    private static final String USER_GUIDE_DIR = JaxoInfo.SETTINGS_DIR + "usrGuide/";
    private static final String WEB_URL = "http://jaxodraw.sourceforge.net/userguide.html";
    private static final String USER_GUIDE_SOURCES_DIR = "resources/usrGuide/";
    private final File lockFile;
    private final File indexFile;
    private final File userGuideDir;
    private final Component parent;
    private boolean inJar;

    public JaxoUserGuide(Component parentc) {
        this(USER_GUIDE_DIR, parentc);
    }

    public JaxoUserGuide(String targetDir, Component parentc) {
        this.parent = parentc;
        this.userGuideDir = new File(targetDir);
        this.lockFile = new File(targetDir, ".lock");
        this.indexFile = new File(targetDir, "index.html");
    }

    public static void main(String[] args) {
        String targetDir = args.length > 0 ? args[0] : JaxoInfo.USER_HOME + "/usrGuide/";
        JaxoLog.info("Creating user guide in: " + targetDir);
        File target = new File(targetDir);
        JaxoUserGuide guide = new JaxoUserGuide(targetDir, null);
        if (!guide.prepareTargetDir(target)) {
            throw new RuntimeException("Failed to create target directory!");
        }
        if (!guide.createHtml(target)) {
            throw new RuntimeException(LANGUAGE.message("installErrorVisit%0", WEB_URL));
        }
    }

    public void show(JaxoPreview p) {
        URL indexPage = this.localIndexPage();
        if (indexPage == null) {
            String msg = LANGUAGE.message("installErrorVisit%0", WEB_URL);
            JaxoDialogs.showErrorDialog(this.parent, msg);
        } else {
            p.setParentComponent(this.parent);
            p.browseURL(indexPage);
        }
    }

    public boolean isLocallyBrowsable() {
        boolean ready = false;
        if (this.userGuideDir.isDirectory()) {
            if (this.lockFile.exists()) {
                JaxoLog.info("Lock file detected, re-creating User Guide!");
                JaxoUserGuide.deleteDir(this.userGuideDir);
                ready = this.createHtml(this.userGuideDir);
            } else if (this.indexFile.exists()) {
                ready = true;
            } else {
                JaxoLog.info("No index file found, re-creating User Guide!");
                JaxoUserGuide.deleteDir(this.userGuideDir);
                ready = this.createHtml(this.userGuideDir);
            }
        } else {
            ready = this.createHtml(this.userGuideDir);
        }
        return ready;
    }

    public URL localIndexPage() {
        URL indexPage = null;
        try {
            if (this.isLocallyBrowsable()) {
                indexPage = this.indexFile.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            JaxoLog.debug(e);
        }
        return indexPage;
    }

    private boolean createHtml(File targetDir) {
        JaxoProgressDialog progress = new JaxoProgressDialog(this.parent, 0, 100, LANGUAGE.value("creatingUserGuide"));
        progress.setValue(0);
        progress.pack();
        progress.setVisible(this.parent != null);
        int value = 10;
        progress.setValue(value);
        File sourceDir = null;
        try {
            sourceDir = this.getSourcesDir(targetDir);
        }
        catch (IOException e) {
            JaxoLog.warn("Failed to copy usrGuide sources: " + e.getMessage());
            JaxoLog.debug(e);
            return false;
        }
        File xslFile = new File(sourceDir, "xslt/style.xsl");
        File xdocDir = new File(sourceDir, "xdocs/");
        File[] xmlFiles = xdocDir.listFiles();
        int nof = xmlFiles.length;
        int step = Math.round(90.0f / (float)nof);
        try {
            for (int j = 0; j < nof; ++j) {
                File xmlFile = xmlFiles[j];
                String filename = xmlFile.getName();
                File outFile = new File(targetDir, filename.replace(".xml", ".html"));
                JaxoXsltTransformer.transform(xmlFile, outFile, xslFile, JaxoUserGuide.getHtmlParameters(), JaxoUserGuide.getHtmlOutputProperties());
                progress.setValue(value += step);
            }
            JaxoUserGuide.copyDirectory(new File(sourceDir, "resources/"), targetDir);
        }
        catch (IOException e) {
            JaxoLog.warn("Failed to transform usrGuide sources: " + e.getMessage());
            JaxoLog.debug(e);
            return false;
        }
        if (this.inJar && !JaxoUserGuide.deleteDir(sourceDir)) {
            JaxoLog.warn("Could not delete temporary file: " + sourceDir.getAbsolutePath());
        }
        progress.setValue(100);
        if (!this.lockFile.delete()) {
            JaxoLog.warn("Could not delete lock file: " + this.lockFile.getAbsolutePath());
        }
        progress.dispose();
        return true;
    }

    private boolean prepareTargetDir(File targetDir) {
        boolean succeed = false;
        try {
            if (targetDir.exists()) {
                JaxoLog.info("Directory " + targetDir + " will be recreated!");
                succeed = JaxoUserGuide.deleteDir(targetDir);
                if (!succeed) {
                    JaxoLog.warn(targetDir.getAbsolutePath() + " could not be deleted!");
                    return false;
                }
            }
            if (!(succeed = targetDir.mkdirs())) {
                JaxoLog.warn(targetDir.getAbsolutePath() + " could not be created!");
                return false;
            }
            succeed = this.lockFile.createNewFile();
            if (!succeed) {
                JaxoLog.warn("Lock file could not be created!");
                return false;
            }
        }
        catch (SecurityException e) {
            JaxoLog.warn(targetDir.getAbsolutePath() + " could not be created!");
            JaxoLog.debug(e);
            return false;
        }
        catch (IOException e) {
            JaxoLog.warn(targetDir.getAbsolutePath() + " could not be created!");
            JaxoLog.debug(e);
            return false;
        }
        return true;
    }

    private File getSourcesDir(File targetDir) throws IOException {
        File sourceDir = new File(Thread.currentThread().getContextClassLoader().getResource(USER_GUIDE_SOURCES_DIR).getFile());
        String sourceDirPath = sourceDir.getPath();
        try {
            sourceDirPath = URLDecoder.decode(sourceDirPath, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            JaxoLog.debug("utf-8 not supported?", e);
        }
        int bang = sourceDirPath.indexOf(".jar!");
        boolean bl = this.inJar = bang != -1;
        if (this.inJar) {
            String jarName = sourceDirPath.substring(5, bang + 4);
            sourceDir = new File(targetDir, "src/");
            JaxoUserGuide.copyFolderFromJar(new JarFile(jarName), USER_GUIDE_SOURCES_DIR, sourceDir);
        }
        return sourceDir;
    }

    private static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists() && !dstDir.mkdir()) {
                throw new IOException("Failed to create target directory: " + dstDir.getAbsolutePath());
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                JaxoUserGuide.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            JaxoUserGuide.copyFile(srcDir, dstDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File src, File dst) throws IOException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = JaxoUserGuide.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private static void copyFolderFromJar(JarFile jar, String folderName, File fDest) throws IOException {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith(folderName)) continue;
            File f = new File(fDest, entryName.substring(folderName.length(), entryName.length()));
            if (entry.isDirectory()) {
                if (f.exists() || f.mkdirs()) continue;
                throw new IOException("could not create directory: " + f.getAbsolutePath() + " for jar entry " + entryName);
            }
            if (f.exists() || JaxoUserGuide.copyFileFromJar(entryName, f)) continue;
            throw new IOException("copyFileFromJar failed: " + f.getAbsolutePath() + " for jar entry " + entryName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFileFromJar(String sResource, File fDest) throws IOException {
        if (sResource == null || fDest == null) {
            return false;
        }
        InputStream sIn = null;
        OutputStream sOut = null;
        try {
            int nLen = 0;
            sIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(sResource);
            if (sIn == null) {
                throw new IOException("Error copying from jar(" + sResource + " to " + fDest.getPath() + ")");
            }
            sOut = new FileOutputStream(fDest);
            byte[] bBuffer = new byte[1024];
            while ((nLen = sIn.read(bBuffer)) > 0) {
                sOut.write(bBuffer, 0, nLen);
            }
            sOut.flush();
        }
        finally {
            try {
                if (sIn != null) {
                    sIn.close();
                }
            }
            finally {
                if (sOut != null) {
                    sOut.close();
                }
            }
        }
        return fDest.exists();
    }

    private static Map<String, String> getHtmlParameters() {
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("JDtitle", "JaxoDraw");
        params.put("JDversion", JaxoInfo.VERSION_NUMBER);
        return params;
    }

    private static Map<String, String> getHtmlOutputProperties() {
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("doctype-public", "-//W3C//DTD XHTML 1.0 Transitional//EN");
        params.put("doctype-system", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
        return params;
    }
}

