/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel.button;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.sf.jaxodraw.gui.menu.popup.JaxoVertexPopupMenu;
import net.sf.jaxodraw.gui.panel.button.JaxoButtonPanel;
import net.sf.jaxodraw.gui.panel.button.JaxoPanelButton;
import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLocalized;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoMiscButtons
extends JPanel
implements PropertyChangeListener,
JaxoLocalized {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final String[] MISC_BUTTON_ICONS = new String[]{"zigzag.png", "box.png", "blob.png", "vertexT1.png", "font_truetype.png", "latex.png", "empty.png", "empty.png"};
    private static final String[] VERTEX_BUTTON_ICONS = new String[]{"vertexT1.png", "vertexT2.png", "vertexT3.png", "vertexT4.png", "vertexT5.png", "vertexT6.png"};
    private static final int[] MISC_MODES = new int[]{233, 230, 231, 232, 234, 235, 10000, 10000};
    private static final int NOF_BUTTONS = MISC_MODES.length;
    private static final int VERTEX_BUTTON = 3;
    private static final String[] TOOLTIP_KEYS = new String[]{"Draw_a_zigzag_line", "Draw_a_box", "Draw_a_blob", "Draw_a_vertex", "Draw_a_text_string", "Draw_a_LaTex_text", "", ""};
    private final JaxoVertexPopupMenu vertexPopup;
    private final JaxoPanelButton[] miscButtons = new JaxoPanelButton[NOF_BUTTONS];

    public JaxoMiscButtons() {
        super(new GridBagLayout());
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.miscButtons[i] = new JaxoPanelButton();
            this.miscButtons[i].setIcon(JaxoUtils.newImageIcon(MISC_BUTTON_ICONS[i]));
            this.miscButtons[i].setToolTipText(JaxoLanguage.translate(TOOLTIP_KEYS[i]));
            this.miscButtons[i].setId(JaxoConstants.getModeAsString(MISC_MODES[i]));
        }
        GridBagConstraints c = (GridBagConstraints)JaxoButtonPanel.BUTTON_CONSTRAINTS.clone();
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 4; ++x) {
                c.gridx = x;
                c.gridy = y;
                this.add((Component)this.miscButtons[x + 4 * y], c);
            }
        }
        this.vertexPopup = new JaxoVertexPopupMenu();
        this.miscButtons[3].setIcon(this.getImageIcon(336));
        this.miscButtons[3].addMouseListener(new MouseAdapter(){

            public final void mousePressed(MouseEvent e) {
                if (JaxoUtils.isButton3(e)) {
                    JaxoMiscButtons.this.vertexPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.miscButtons[6].setEnabled(false);
        this.miscButtons[7].setEnabled(false);
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.updateVertexType((Integer)e.getNewValue());
    }

    public final void addActionListener(ActionListener l) {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.miscButtons[i].addActionListener(l);
        }
        this.vertexPopup.addActionListener(l);
    }

    private void unsetButtons() {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.miscButtons[i].setSelected(false);
        }
    }

    private int getIndex(int i) {
        int j = NOF_BUTTONS + 1;
        for (int jj = 0; jj < NOF_BUTTONS; ++jj) {
            if (i != MISC_MODES[jj]) continue;
            j = jj;
        }
        return j;
    }

    public final void pressButton(int mode) {
        this.unsetButtons();
        if (JaxoConstants.isMiscMode(mode)) {
            int j = this.getIndex(mode);
            this.miscButtons[j].setSelected(true);
        } else if (JaxoConstants.isVertexMode(mode)) {
            this.miscButtons[3].setSelected(true);
        }
    }

    public final void setDefault(int mode) {
        this.resetDefault();
        if (JaxoConstants.isMiscMode(mode)) {
            int j = this.getIndex(mode);
            this.miscButtons[j].setDefault(true);
        }
    }

    private void resetDefault() {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.miscButtons[i].setDefault(false);
        }
    }

    public final void updateLanguage() {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.miscButtons[i].setToolTipText(JaxoLanguage.translate(TOOLTIP_KEYS[i]));
        }
        this.vertexPopup.updateLanguage();
    }

    private void updateVertexType(int value) {
        this.miscButtons[3].setIcon(this.getImageIcon(value));
        this.miscButtons[3].doClick(0);
        this.vertexPopup.updateVertexType(value);
    }

    private ImageIcon getImageIcon(int mode) {
        return JaxoUtils.newImageIcon(VERTEX_BUTTON_ICONS[this.getVertexIndex(mode)]);
    }

    private int getVertexIndex(int mode) {
        int index = -1;
        switch (mode) {
            case 336: {
                index = 0;
                break;
            }
            case 337: {
                index = 1;
                break;
            }
            case 338: {
                index = 2;
                break;
            }
            case 339: {
                index = 3;
                break;
            }
            case 340: {
                index = 4;
                break;
            }
            case 341: {
                index = 5;
                break;
            }
        }
        return index;
    }
}

