/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel.button;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.border.Border;

public class JaxoPanelButton
extends JButton {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final Color PRESSED_BACKGROUND;
    private static final Border UNPRESSED_BORDER;
    private static final Border PRESSED_BORDER;
    private static final Border UNPRESSED_DEFAULT_BORDER;
    private static final Border PRESSED_DEFAULT_BORDER;
    private static final Dimension BUTTON_MINIMUM_SIZE;
    private static final Dimension BUTTON_PREFERRED_SIZE;
    private Color unpressedBackground;
    private boolean isDefault;

    public JaxoPanelButton() {
        this.setFocusPainted(false);
        this.setRolloverEnabled(true);
        this.setMinimumSize(BUTTON_MINIMUM_SIZE);
        this.setPreferredSize(BUTTON_PREFERRED_SIZE);
    }

    public static final int getButtonHeight() {
        return JaxoPanelButton.BUTTON_PREFERRED_SIZE.height;
    }

    public void updateUI() {
        this.setBackground(null);
        super.updateUI();
        this.unpressedBackground = this.getBackground();
        this.updateState();
    }

    public final boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean value) {
        if (this.isDefault != value) {
            this.isDefault = value;
            this.updateState();
        }
    }

    public void setSelected(boolean value) {
        if (value != this.isSelected()) {
            super.setSelected(value);
            this.updateState();
        }
    }

    private void updateState() {
        this.setBackground(this.isSelected() ? PRESSED_BACKGROUND : this.unpressedBackground);
        this.setBorder(this.isDefault() ? (this.isSelected() ? PRESSED_DEFAULT_BORDER : UNPRESSED_DEFAULT_BORDER) : (this.isSelected() ? PRESSED_BORDER : UNPRESSED_BORDER));
    }

    public void setId(String name) {
        this.setName(name);
        this.setActionCommand(name);
    }

    static {
        BUTTON_MINIMUM_SIZE = new Dimension(40, 40);
        BUTTON_PREFERRED_SIZE = new Dimension(40, 40);
        PRESSED_BACKGROUND = new Color(170, 170, 180);
        UNPRESSED_BORDER = BorderFactory.createRaisedBevelBorder();
        PRESSED_BORDER = BorderFactory.createLoweredBevelBorder();
        Border b = BorderFactory.createLineBorder(Color.GRAY, 2);
        UNPRESSED_DEFAULT_BORDER = BorderFactory.createCompoundBorder(UNPRESSED_BORDER, b);
        PRESSED_DEFAULT_BORDER = BorderFactory.createCompoundBorder(PRESSED_BORDER, b);
    }
}

