/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.swing.spinner;

import java.text.NumberFormat;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import net.sf.jaxodraw.gui.swing.spinner.JaxoFixedJSpinner;

public class JaxoSpinnerRotationModel
extends SpinnerNumberModel {
    private static final long serialVersionUID = 7526471155622776147L;

    public JaxoSpinnerRotationModel() {
        this(0);
    }

    public JaxoSpinnerRotationModel(int value) {
        super(0, -179, 180, 1);
        this.setRotationValue(value);
    }

    public final int getRotationValue() {
        return this.getNumber().intValue();
    }

    public void setValue(Object value) {
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        this.setRotationValue((Integer)value);
    }

    public final void setRotationValue(int newValue) {
        int value = newValue % 360;
        if (value < -180) {
            value += 360;
        } else if (value > 180) {
            value -= 360;
        }
        super.setValue(value);
    }

    public Object getPreviousValue() {
        Comparable<?> result = super.getPreviousValue();
        if (result == null) {
            result = super.getMaximum();
        }
        return result;
    }

    public Object getNextValue() {
        Comparable<?> result = super.getNextValue();
        if (result == null) {
            result = super.getMinimum();
        }
        return result;
    }

    public JSpinner newSpinner() {
        JaxoFixedJSpinner result = new JaxoFixedJSpinner(this);
        ((JSpinner)result).setEditor(new RotationEditor(result));
        return result;
    }

    private static class RotationEditor
    extends JSpinner.NumberEditor {
        private static final long serialVersionUID = 7526471155622776147L;

        RotationEditor(JSpinner s) {
            super(s);
            DefaultFormatterFactory f = (DefaultFormatterFactory)this.getTextField().getFormatterFactory();
            NumberFormatter n = (NumberFormatter)f.getDefaultFormatter();
            n = new NumberFormatter((NumberFormat)n.getFormat());
            n.setValueClass(Integer.class);
            this.getTextField().setFormatterFactory(new DefaultFormatterFactory(n));
            this.getTextField().setColumns(4);
        }
    }
}

