/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.io.exports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.gui.swing.JaxoTitledBorder;
import net.sf.jaxodraw.io.JaxoPreview;
import net.sf.jaxodraw.io.exports.JaxoExport;
import net.sf.jaxodraw.io.exports.JaxoExportLatex;
import net.sf.jaxodraw.plugin.JaxoPluginExecutionException;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLog;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoExportLatexPS
extends JaxoExport {
    private JPanel panel;
    private JLabel scaleLabel;
    private boolean scaleToFitPage = false;
    private static final String TMP_BASENAME = "Jaxo_tmp";
    private static final String PREVIEW_FILENAME = "Jaxo_tmp.eps";
    private static final float MARGIN_IN_INCH = 2.0f;
    private static final String PLUGIN_ID = JaxoExportLatexPS.class.getName();

    public final String getFormatName() {
        return JaxoLanguage.translate("JaxoExportLatexPS.formatName");
    }

    public final String getFileExtension() {
        return "eps";
    }

    public final String getFileExtensionDescription() {
        return JaxoLanguage.translate("JaxoExportLatexPS.fileDescription");
    }

    public String description() {
        return JaxoLanguage.translate("JaxoExportLatexPS.description");
    }

    public String pluginId() {
        return PLUGIN_ID;
    }

    public String getShortName() {
        return "latex-ps-export";
    }

    public String getWarningForGraph() {
        String warning = null;
        if (this.getGraph().containsPSText()) {
            warning = this.getPSTextWarningForLaTeX();
        }
        if (JaxoPrefs.getIntPref("prefCOLORSPACE") == 2) {
            warning = warning == null ? this.getColorSpaceWarningForLaTeX() : warning + "<p></p>" + this.getColorSpaceWarningForLaTeX();
        }
        return warning;
    }

    protected final void exportTo(String fileName) throws JaxoPluginExecutionException {
        int status = this.exportToWithStatus(fileName);
        if (status != 0) {
            JaxoLog.warn("Status in JaxoExportLatexPS: " + status);
        }
    }

    public final int exportToWithStatus(String fileName) {
        int status = 0;
        String folder = new File(fileName).getParent();
        String latexFileName = "Jaxo_tmp.tex";
        String dviFileName = "Jaxo_tmp.dvi";
        String logFileName = "Jaxo_tmp.log";
        String auxFileName = "Jaxo_tmp.aux";
        File latexFile = new File(folder, "Jaxo_tmp.tex");
        latexFile.deleteOnExit();
        File dviFile = new File(folder, "Jaxo_tmp.dvi");
        dviFile.deleteOnExit();
        File logFile = new File(folder, "Jaxo_tmp.log");
        logFile.deleteOnExit();
        File auxFile = new File(folder, "Jaxo_tmp.aux");
        auxFile.deleteOnExit();
        JaxoExportLatex lat = new JaxoExportLatex();
        lat.setParentComponent(this.getParentComponent());
        lat.setGraph(this.getGraph());
        try {
            lat.exportTo(latexFile.getAbsolutePath(), this.scaleToFitPage);
        }
        catch (JaxoPluginExecutionException e) {
            this.setFailure(lat.getFailure());
            JaxoLog.debug("Latex export failed: ", e);
            return 1;
        }
        if (lat.hasFailed()) {
            this.setFailure(lat.getFailure());
            return 1;
        }
        String latexExe = JaxoPrefs.getStringPref("prefLATEXPATH");
        String dvipsExe = JaxoPrefs.getStringPref("prefDVIPSPATH");
        String latexCommand = latexExe + " --interaction nonstopmode " + latexFile.getAbsolutePath();
        String[] dvipsCommand = new String[]{dvipsExe, "-E", "-o", fileName, dviFile.getAbsolutePath()};
        int texStatus = 0;
        int dviStatus = 0;
        try {
            texStatus = JaxoExportLatexPS.executeCommand(latexCommand, folder);
            if (texStatus == 0) {
                dviStatus = JaxoExportLatexPS.executeCommand(dvipsCommand, folder);
            }
        }
        catch (IOException anIOException) {
            String message = JaxoLanguage.translate("Cannot_execute_command!") + JaxoLanguage.translate("Please_try_'Export_LaTeX'_and_run_latex_manually.");
            JaxoLog.debug(anIOException);
            JaxoDialogs.showErrorDialog(this.getParentComponent(), message);
        }
        catch (InterruptedException intexc) {
            String message = JaxoLanguage.translate("Cannot_execute_command!") + JaxoLanguage.translate("Please_try_'Export_LaTeX'_and_run_latex_manually.");
            JaxoLog.debug(intexc);
            JaxoDialogs.showErrorDialog(this.getParentComponent(), message);
        }
        status = texStatus + dviStatus;
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int executeCommand(String command, String workingDir) throws IOException, InterruptedException {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(command, null, new File(workingDir));
        int exit = 0;
        JTextArea area = new JTextArea(20, 80);
        area.setMargin(new Insets(5, 5, 5, 5));
        JScrollPane areaScrollPane = new JScrollPane(area);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(new JaxoTitledBorder(JaxoLanguage.translate("LaTeX_output")), BorderFactory.createEmptyBorder(5, 5, 5, 5)), areaScrollPane.getBorder()));
        JFrame frame = new JFrame();
        frame.setIconImage(JaxoUtils.newImage("frame.png"));
        frame.getContentPane().add((Component)areaScrollPane, "Center");
        frame.setDefaultCloseOperation(2);
        frame.setTitle(command);
        frame.pack();
        frame.setVisible(true);
        BufferedReader lsIn = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            String lsStr;
            while ((lsStr = lsIn.readLine()) != null) {
                area.append(lsStr + JaxoUtils.LINE_SEPARATOR);
            }
        }
        catch (IOException e) {
            JaxoLog.debug(e);
        }
        finally {
            if (lsIn != null) {
                lsIn.close();
            }
        }
        exit = process.waitFor();
        if (exit == 0) {
            frame.dispose();
        } else {
            JaxoDialogs.showErrorDialog(null, JaxoLanguage.translate("Error:_Execution_of_LaTeX_failed!") + JaxoLanguage.translate("Please_check_the_output_window_for_further_information."));
            process.destroy();
        }
        return exit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int executeCommand(String[] command, String workingDir) throws IOException, InterruptedException {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(command, null, new File(workingDir));
        int exit = 0;
        if (JaxoLog.isLoggable(JaxoLog.INFO)) {
            BufferedReader lsIn = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            try {
                String lsStr;
                while ((lsStr = lsIn.readLine()) != null) {
                    JaxoLog.info(lsStr);
                }
            }
            catch (IOException e) {
                JaxoLog.debug(e);
            }
            finally {
                if (lsIn != null) {
                    lsIn.close();
                }
            }
        }
        if ((exit = process.waitFor()) != 0) {
            JaxoLog.warn("Error executing command: " + JaxoUtils.toString(command));
            JaxoDialogs.showErrorDialog(null, "Error:_Execution_of_dvips_failed!");
            process.destroy();
        }
        return exit;
    }

    public void preview(JaxoPreview p, boolean sameWindow) {
        if (p.canShowPostscript()) {
            boolean newWindow;
            File previewFile = new File(JaxoPreview.TMP_DIR, PREVIEW_FILENAME);
            boolean previewFileExists = previewFile.exists();
            previewFile.deleteOnExit();
            int status = this.exportToWithStatus(previewFile.getAbsolutePath());
            boolean bl = newWindow = !sameWindow || !previewFileExists;
            if (status == 0 && newWindow) {
                p.showPostscript(previewFile);
            }
        } else {
            p.showMessageForPostscriptViewer();
        }
    }

    public void commitConfiguration() {
    }

    public JComponent getConfigurationPanel() {
        if (this.panel == null && this.isRescalingNeeded()) {
            this.panel = new JPanel(new GridBagLayout(), false);
            GridBagConstraints labels = new GridBagConstraints();
            GridBagConstraints components = new GridBagConstraints();
            labels.anchor = 22;
            labels.gridx = 0;
            labels.gridy = 0;
            components.anchor = 21;
            components.gridx = 1;
            components.gridy = 0;
            components.weightx = 1.0;
            this.scaleLabel = new JLabel(JaxoLanguage.translate("JaxoExportLatex.rescaleLabel"));
            this.panel.add((Component)this.scaleLabel, labels);
            final JCheckBox scaleBox = new JCheckBox();
            scaleBox.setSelected(this.scaleToFitPage);
            scaleBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JaxoExportLatexPS.this.scaleToFitPage = scaleBox.isSelected();
                }
            });
            this.panel.add((Component)scaleBox, components);
            ++labels.gridy;
            ++components.gridy;
        }
        return this.panel;
    }

    public final void updateLanguage() {
        if (this.scaleLabel != null) {
            this.scaleLabel.setText(JaxoLanguage.translate("JaxoExportLatex.rescaleLabel"));
        }
    }

    private boolean isRescalingNeeded() {
        boolean rneeded = false;
        Rectangle bBox = this.getGraph().getBounds();
        if (bBox == null) {
            return false;
        }
        int bBoxWidth = bBox.width;
        int bBoxHeight = bBox.height;
        float boxWidthInInch = (float)bBoxWidth / 72.0f;
        float boxHeightInInch = (float)bBoxHeight / 72.0f;
        float paperWidthInInch = 6.2677164f;
        float paperHeightInInch = 9.692914f;
        float scaleX = boxWidthInInch / 6.2677164f;
        float scaleY = boxHeightInInch / 9.692914f;
        if (scaleX > 1.0f || scaleY > 1.0f) {
            rneeded = true;
        }
        return rneeded;
    }
}

