/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.io.exports;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.NoSuchElementException;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.io.JaxoPreview;
import net.sf.jaxodraw.io.exports.JaxoExport;
import net.sf.jaxodraw.plugin.JaxoPluginExecutionException;
import net.sf.jaxodraw.util.JaxoInfo;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLog;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoExportPS
extends JaxoExport
implements Printable {
    private Format mode;
    private final Rectangle psbBox = new Rectangle();
    private boolean landscape;
    private JPanel panel;
    private JLabel orientationLabel;
    private JComboBox orientation;
    private static final String PLUGIN_ID = JaxoExportPS.class.getName();
    private static final String TMP_PS_FILENAME = ".temp.ps";
    private static final String TMP_EPS_FILENAME = ".temp.eps";
    private static final String PS_FIRST_LINE = "%!PS-Adobe-3.0";
    private static final String EPS_FIRST_LINE = "%!PS-Adobe-3.0 EPSF-3.0";
    private static final String CREATOR_LINE = "%%Creator: " + JaxoInfo.USER_NAME + " with " + JaxoInfo.VERSION;
    private static final String SETPAGEDEVICE = "setpagedevice";

    public JaxoExportPS(Format psmode) {
        this.setMode(psmode);
    }

    public final boolean isLandscape() {
        return this.landscape;
    }

    public void setLandscape(boolean value) {
        this.landscape = value;
    }

    public final void setMode(Format value) {
        this.mode = value;
    }

    public final Format getMode() {
        return this.mode;
    }

    public final String getFormatName() {
        return JaxoLanguage.translate("JaxoExportPS.formatName." + this.getFileExtension());
    }

    public final String getFileExtension() {
        return this.getMode().equals((Object)Format.EPS) ? "eps" : "ps";
    }

    public final String getFileExtensionDescription() {
        return JaxoLanguage.translate("JaxoExportPS.fileDescription." + this.getFileExtension());
    }

    public String description() {
        return JaxoLanguage.translate("JaxoExportPS.description." + this.getFileExtension());
    }

    public String pluginId() {
        return PLUGIN_ID;
    }

    public String getShortName() {
        return "ps-export";
    }

    protected void exportTo(String fileName) throws JaxoPluginExecutionException {
        try {
            if (this.getMode().equals((Object)Format.EPS)) {
                this.doExportEPS(fileName);
            } else {
                this.doExportPS(fileName);
            }
        }
        catch (IOException ie) {
            throw new JaxoPluginExecutionException(this.errorDialogMessage(fileName), ie, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExportPS(String fileName) throws IOException {
        File tempFile = new File(JaxoPreview.TMP_DIR, TMP_PS_FILENAME);
        tempFile.deleteOnExit();
        this.writePS(tempFile);
        BufferedReader inbr = null;
        BufferedWriter outbr = null;
        try {
            String str;
            inbr = new BufferedReader(new FileReader(tempFile));
            outbr = new BufferedWriter(new FileWriter(fileName));
            Calendar rightNow = Calendar.getInstance();
            String forthLine = "%%Title: " + this.getGraph().getDescription();
            String fifthLine = "%%CreationDate: " + rightNow.get(5) + "/" + (rightNow.get(2) + 1) + "/" + rightNow.get(1);
            boolean isFirstLine = true;
            while ((str = inbr.readLine()) != null) {
                if (isFirstLine) {
                    outbr.write(PS_FIRST_LINE, 0, PS_FIRST_LINE.length());
                    outbr.newLine();
                    outbr.write(CREATOR_LINE, 0, CREATOR_LINE.length());
                    outbr.newLine();
                    outbr.write(forthLine, 0, forthLine.length());
                    outbr.newLine();
                    outbr.write(fifthLine, 0, fifthLine.length());
                    outbr.newLine();
                    isFirstLine = false;
                    continue;
                }
                outbr.write(str, 0, str.length());
                outbr.newLine();
            }
        }
        catch (Throwable throwable) {
            this.close(inbr);
            this.close(outbr);
            throw throwable;
        }
        this.close(inbr);
        this.close(outbr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExportEPS(String fileName) throws IOException {
        File tempFile = new File(JaxoPreview.TMP_DIR, TMP_EPS_FILENAME);
        tempFile.deleteOnExit();
        this.writePS(tempFile);
        BufferedReader inbr = null;
        BufferedWriter outbr = null;
        try {
            String str;
            inbr = new BufferedReader(new FileReader(tempFile));
            outbr = new BufferedWriter(new FileWriter(fileName));
            Rectangle bb = this.psbBox.getBounds();
            Calendar rightNow = Calendar.getInstance();
            String secondLine = "%%BoundingBox: " + Math.round((float)Math.floor(bb.getMinX())) + " " + Math.round((float)Math.floor(bb.getMinY())) + " " + Math.round((float)Math.ceil(bb.getMaxX())) + " " + Math.round((float)Math.ceil(bb.getMaxY()));
            String forthLine = "%%Title: " + this.getGraph().getDescription();
            String fifthLine = "%%CreationDate: " + rightNow.get(5) + "/" + (rightNow.get(2) + 1) + "/" + rightNow.get(1);
            boolean isFirstLine = true;
            while ((str = inbr.readLine()) != null) {
                if (isFirstLine) {
                    outbr.write(EPS_FIRST_LINE, 0, EPS_FIRST_LINE.length());
                    outbr.newLine();
                    outbr.write(secondLine, 0, secondLine.length());
                    outbr.newLine();
                    outbr.write(CREATOR_LINE, 0, CREATOR_LINE.length());
                    outbr.newLine();
                    outbr.write(forthLine, 0, forthLine.length());
                    outbr.newLine();
                    outbr.write(fifthLine, 0, fifthLine.length());
                    outbr.newLine();
                    isFirstLine = false;
                    continue;
                }
                if (str.indexOf(SETPAGEDEVICE) != -1) {
                    str = str.replaceAll(SETPAGEDEVICE, "pop");
                }
                outbr.write(str, 0, str.length());
                outbr.newLine();
            }
        }
        catch (Throwable throwable) {
            this.close(inbr);
            this.close(outbr);
            throw throwable;
        }
        this.close(inbr);
        this.close(outbr);
    }

    public final int print(Graphics g, PageFormat pf, int pageIndex) {
        double transX = pf.getImageableX();
        double transY = pf.getImageableY();
        double paperHeight = pf.getHeight();
        Rectangle graphBB = this.getGraph().getBounds();
        if (graphBB == null) {
            graphBB = new Rectangle(1, 1);
        }
        double scaleX = pf.getImageableWidth() / graphBB.getWidth();
        double scaleY = pf.getImageableHeight() / graphBB.getHeight();
        if (pageIndex == 0) {
            JaxoGraphics2D g2 = new JaxoGraphics2D((Graphics2D)g);
            g2.setPrinting(true);
            double right = transX + pf.getImageableWidth() - graphBB.getX() - graphBB.getWidth();
            double bottom = transY + pf.getImageableHeight() - graphBB.getY() - graphBB.getHeight();
            double scale = scaleX;
            if (scaleY < scaleX) {
                scale = scaleY;
            }
            if (scale > 1.0) {
                scale = 1.0;
            }
            g2.translate(transX, transY);
            if (scale < 1.0) {
                g2.scale(scale, scale);
                g2.translate(-graphBB.getX(), -graphBB.getY());
            } else {
                if (right < 0.0) {
                    g2.translate(right - transX, 0.0);
                    transX = right;
                }
                if (bottom < 0.0) {
                    g2.translate(0.0, bottom - transY);
                    transY = bottom;
                }
            }
            if (this.getMode().equals((Object)Format.EPS)) {
                this.setEPSBoundingBox(transX, transY, scale, paperHeight, graphBB);
            }
            this.getGraph().paint(g2);
            return 0;
        }
        return 1;
    }

    private void setEPSBoundingBox(double transX, double transY, double scale, double paperHeight, Rectangle bBox) {
        double shiftX = bBox.getX();
        double shiftY = bBox.getY();
        if (scale < 1.0) {
            shiftX = 0.0;
            shiftY = 0.0;
        }
        if (this.landscape) {
            this.psbBox.setFrameFromDiagonal(shiftY * scale + transX, shiftX * scale + transX, (shiftY + (double)bBox.height) * scale + transX, (shiftX + (double)bBox.width) * scale + transX);
        } else {
            this.psbBox.setFrameFromDiagonal(shiftX * scale + transX, paperHeight - ((shiftY + (double)bBox.height) * scale + transY), (shiftX + (double)bBox.width) * scale + transX, paperHeight - (shiftY * scale + transY));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writePS(File file) {
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        String psMimeType = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
        StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, psMimeType);
        if (factories.length == 0) {
            this.setFailure(new NoSuchElementException("StreamPrintServiceFactory"));
            this.showErrorDialog(JaxoLanguage.translate("No_suitable_factories_found!"));
        } else {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                StreamPrintService sps = factories[0].getPrintService(fos);
                DocPrintJob job = sps.createPrintJob();
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                aset.add(this.landscape ? OrientationRequested.LANDSCAPE : OrientationRequested.PORTRAIT);
                SimpleDoc doc = new SimpleDoc(this, flavor, null);
                PrintJobWatcher pjDone = new PrintJobWatcher(job);
                job.print(doc, aset);
                pjDone.waitForDone();
            }
            catch (PrintException pe) {
                this.setFailure(pe);
                this.showErrorDialog(this.errorDialogMessage(file.getName()));
            }
            catch (IOException ie) {
                this.setFailure(ie);
                this.showErrorDialog(this.errorDialogMessage(file.getName()));
            }
            finally {
                this.close(fos);
            }
        }
    }

    public void preview(JaxoPreview p, boolean sameWindow) {
        if (p.canShowPostscript()) {
            boolean newWindow;
            String previewFileName = this.getMode().equals((Object)Format.EPS) ? "Jaxo_tmp.eps" : "Jaxo_tmp.ps";
            File previewFile = new File(JaxoPreview.TMP_DIR, previewFileName);
            boolean previewFileExists = previewFile.exists();
            previewFile.deleteOnExit();
            try {
                this.exportTo(previewFile.getAbsolutePath());
            }
            catch (JaxoPluginExecutionException e) {
                this.setFailure(e);
                if (e.getMessage() != null) {
                    this.showErrorDialog(e.getMessage());
                }
                return;
            }
            boolean bl = newWindow = !sameWindow || !previewFileExists;
            if (newWindow) {
                p.showPostscript(previewFile);
            }
        } else {
            p.showMessageForPostscriptViewer();
        }
    }

    public void commitConfiguration() {
    }

    public JComponent getConfigurationPanel() {
        if (this.panel == null) {
            this.panel = new JPanel(new GridBagLayout(), false);
            GridBagConstraints labels = new GridBagConstraints();
            GridBagConstraints components = new GridBagConstraints();
            labels.anchor = 22;
            labels.gridx = 0;
            labels.gridy = 0;
            components.anchor = 21;
            components.gridx = 1;
            components.gridy = 0;
            components.weightx = 1.0;
            this.orientationLabel = new JLabel(JaxoLanguage.label("JaxoExportPS.orientation"));
            this.panel.add((Component)this.orientationLabel, labels);
            this.orientation = new JComboBox<Object>(new Object[]{JaxoLanguage.translate("JaxoExportPS.orientation.portrait"), JaxoLanguage.translate("JaxoExportPS.orientation.landscape")});
            this.orientation.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JaxoExportPS.this.landscape = JaxoExportPS.this.orientation.getSelectedIndex() == 1;
                }
            });
            this.panel.add((Component)this.orientation, components);
            ++labels.gridy;
            ++components.gridy;
        }
        return this.panel;
    }

    public final void updateLanguage() {
        if (this.orientationLabel != null) {
            this.orientationLabel.setText(JaxoLanguage.label("JaxoExportPS.orientation"));
            this.orientation = new JComboBox<Object>(new Object[]{JaxoLanguage.translate("JaxoExportPS.orientation.portrait"), JaxoLanguage.translate("JaxoExportPS.orientation.landscape")});
        }
    }

    private class PrintJobWatcher {
        private boolean done;

        PrintJobWatcher(DocPrintJob job) {
            job.addPrintJobListener(new PrintJobAdapter(){

                public final void printJobCanceled(PrintJobEvent pje) {
                    this.allDone();
                }

                public final void printJobCompleted(PrintJobEvent pje) {
                    this.allDone();
                }

                public final void printJobFailed(PrintJobEvent pje) {
                    this.allDone();
                }

                public final void printJobNoMoreEvents(PrintJobEvent pje) {
                    this.allDone();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void allDone() {
                    PrintJobWatcher printJobWatcher = PrintJobWatcher.this;
                    synchronized (printJobWatcher) {
                        PrintJobWatcher.this.done = true;
                        PrintJobWatcher.this.notifyAll();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void waitForDone() {
            PrintJobWatcher printJobWatcher = this;
            synchronized (printJobWatcher) {
                try {
                    while (!this.done) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    JaxoExportPS.this.setFailure(e);
                    JaxoLog.debug(e);
                    JaxoDialogs.showI18NErrorDialog(null, "Print_job_aborted!");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        PS,
        EPS;

    }
}

