/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object;

import java.awt.geom.Point2D;
import net.sf.jaxodraw.object.JaxoHandle;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoParticleObject;
import net.sf.jaxodraw.util.JaxoGeometry;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public abstract class Jaxo3PointObject
extends JaxoParticleObject {
    public static final int SELECT_P3 = 2;
    private static final long serialVersionUID = 2L;
    private static final int POINT_COUNT = 3;
    private int x3;
    private int y3;

    public int getPointCount() {
        return 3;
    }

    public int getX(int index) {
        if (index == 2) {
            return this.x3;
        }
        return super.getX(index);
    }

    public int getY(int index) {
        if (index == 2) {
            return this.y3;
        }
        return super.getY(index);
    }

    public void setX(int index, int value) {
        if (index == 2) {
            this.x3 = value;
        } else {
            super.setX(index, value);
        }
    }

    public void setY(int index, int value) {
        if (index == 2) {
            this.y3 = value;
        } else {
            super.setY(index, value);
        }
    }

    public final void setX3(int newx3) {
        this.setX(2, newx3);
    }

    public final int getX3() {
        return this.getX(2);
    }

    public final void setY3(int newy3) {
        this.setY(2, newy3);
    }

    public final int getY3() {
        return this.getY(2);
    }

    public final void set3Pts(int x1, int y1, int x2, int y2, int p3, int q3) {
        this.setLocation(x1, y1, x2, y2, p3, q3);
    }

    public final void setLocation(int x1, int y1, int x2, int y2, int p3, int q3) {
        this.setLocation(x1, y1, x2, y2);
        this.setX3(p3);
        this.setY3(q3);
    }

    public void copyFrom(Jaxo3PointObject temp) {
        super.copyFrom(temp);
        this.setX3(temp.getX3());
        this.setY3(temp.getY3());
    }

    public boolean isCopy(JaxoObject comp) {
        Jaxo3PointObject tmp;
        boolean isCopy = false;
        if (comp instanceof Jaxo3PointObject && (tmp = (Jaxo3PointObject)comp).getX3() == this.getX3() && tmp.getY3() == this.getY3() && super.isCopy(tmp)) {
            isCopy = true;
        }
        return isCopy;
    }

    public void paintHandles(JaxoGraphics2D g2, JaxoHandle h, int editMode) {
        if (editMode == 459) {
            return;
        }
        h.paint(g2, this.getX(), this.getY(), this.isMarked(), !this.canBeSelected(0, editMode));
        h.paint(g2, this.getX2(), this.getY2(), this.isMarked(), !this.canBeSelected(1, editMode));
        h.paint(g2, this.getX3(), this.getY3(), this.isMarked(), !this.canBeSelected(2, editMode));
    }

    public float smallestDistanceTo(int px, int py) {
        int distY;
        int distX;
        float dist2;
        float dist1 = super.smallestDistanceTo(px, py);
        return dist1 < (dist2 = (float)Math.sqrt((distX = px - this.getX3()) * distX + (distY = py - this.getY3()) * distY)) ? dist1 : dist2;
    }

    public boolean canBeSelected(int handle, int mode) {
        return handle == 0 || handle == 1 || handle == 2;
    }

    public int getGrabbedHandle(int clickX, int clickY, JaxoHandle h) {
        int selected = super.getGrabbedHandle(clickX, clickY, h);
        if (this.isAround(2, clickX, clickY, h)) {
            selected = 2;
        }
        return selected;
    }

    public void moveBy(int deltaX, int deltaY) {
        if (deltaX != 0 || deltaY != 0) {
            this.setX3(this.getX3() + deltaX);
            this.setY3(this.getY3() + deltaY);
            super.moveBy(deltaX, deltaY);
        }
    }

    public void rescaleObject(int orx, int ory, float scale) {
        Point2D p1 = JaxoGeometry.scaledPoint(orx, ory, scale, this.getX(), this.getY());
        Point2D p2 = JaxoGeometry.scaledPoint(orx, ory, scale, this.getX2(), this.getY2());
        Point2D p3 = JaxoGeometry.scaledPoint(orx, ory, scale, this.getX3(), this.getY3());
        this.setLocation((int)Math.round(p1.getX()), (int)Math.round(p1.getY()), (int)Math.round(p2.getX()), (int)Math.round(p2.getY()), (int)Math.round(p3.getX()), (int)Math.round(p3.getY()));
        this.setAmp(Math.round((float)this.getAmp() * scale));
        this.setWiggles(Math.round((float)this.getWiggles() * scale));
    }

    protected boolean isOneLine() {
        int area = (this.getX2() - this.getX()) * (this.getY3() - this.getY()) - (this.getY2() - this.getY()) * (this.getX3() - this.getX());
        return area == 0;
    }

    static {
        Jaxo3PointObject.setTransient(Jaxo3PointObject.class, new String[]{"x3", "y3"});
    }
}

