/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.arc;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.arc.JaxoArcObject;
import net.sf.jaxodraw.object.line.JaxoSLine;
import net.sf.jaxodraw.util.JaxoUtils;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public abstract class JaxoDashArc
extends JaxoArcObject {
    private static final long serialVersionUID = 314159L;
    private transient BasicStroke innerStroke;
    private transient BasicStroke outerStroke;
    private transient Arc2D arc = new Arc2D.Double();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.arc = new Arc2D.Double();
        this.resetStroke();
    }

    public final void paint(JaxoGraphics2D g2) {
        if (this.tooSingular(0.02)) {
            return;
        }
        if (this.isOneLine()) {
            g2.setColor(this.getColor());
            g2.setStroke(this.getStroke());
            g2.draw(this.dashLine());
            if (this.isPaintArrow()) {
                this.paintArrow(g2);
            }
            return;
        }
        double[] par = this.getArcParameters();
        g2.setColor(this.getColor());
        if (this.isDoubleLine()) {
            this.resetStroke();
            g2.setStroke(this.innerStroke);
            g2.draw(this.getInnerPath(par));
            g2.setStroke(this.outerStroke);
            g2.draw(this.getOuterPath(par));
        } else {
            g2.setStroke(this.getStroke());
            g2.draw(this.getObjectPath(par));
        }
        if (this.isPaintArrow()) {
            this.paintArrow(g2);
        }
    }

    private GeneralPath dashLine() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        if (this.isDoubleLine()) {
            float length = (float)Math.sqrt((this.getX3() - this.getX()) * (this.getX3() - this.getX()) + (this.getY3() - this.getY()) * (this.getY3() - this.getY()));
            float sepx = (float)(this.getY3() - this.getY()) / length * this.getDLSeparation() / 2.0f;
            float sepy = (float)(this.getX3() - this.getX()) / length * this.getDLSeparation() / 2.0f;
            gp.moveTo((float)this.getX() - sepx, (float)this.getY() + sepy);
            gp.lineTo((float)this.getX3() - sepx, (float)this.getY3() + sepy);
            gp.moveTo((float)this.getX() + sepx, (float)this.getY() - sepy);
            gp.lineTo((float)this.getX3() + sepx, (float)this.getY3() - sepy);
        } else {
            gp.moveTo(this.getX(), this.getY());
            gp.lineTo(this.getX3(), this.getY3());
        }
        return gp;
    }

    private GeneralPath getObjectPath(double[] par) {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        this.arc.setArcByCenter(par[0], par[1], par[2], par[4], par[3], 0);
        gp.append(this.arc, false);
        return gp;
    }

    private GeneralPath getInnerPath(double[] par) {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        this.arc.setArcByCenter(par[0], par[1], par[2] - (double)(this.getDLSeparation() / 2.0f), par[4], par[3], 0);
        gp.append(this.arc, false);
        return gp;
    }

    private GeneralPath getOuterPath(double[] par) {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        this.arc.setArcByCenter(par[0], par[1], par[2] + (double)(this.getDLSeparation() / 2.0f), par[4], par[3], 0);
        gp.append(this.arc, false);
        return gp;
    }

    public Rectangle getBounds() {
        Rectangle bb;
        if (this.isSingular()) {
            Rectangle bb2 = new Rectangle(this.getX(), this.getY(), 0, 0);
            bb2.add(this.getX2(), this.getY2());
            bb2.add(this.getX3(), this.getY3());
            return bb2;
        }
        if (this.isOneLine()) {
            Rectangle bb3 = this.getStroke().createStrokedShape(this.dashLine()).getBounds();
            if (this.isPaintArrow()) {
                bb3.add(this.getArrow().getBounds(this.arrowCoordinates()));
            }
            return bb3;
        }
        double[] par = this.getArcParameters();
        if (this.isDoubleLine()) {
            bb = this.innerStroke.createStrokedShape(this.getInnerPath(par)).getBounds();
            bb.add(this.outerStroke.createStrokedShape(this.getOuterPath(par)).getBounds());
        } else {
            bb = this.getStroke().createStrokedShape(this.getObjectPath(par)).getBounds();
        }
        if (this.isPaintArrow()) {
            bb.add(this.getArrow().getBounds(this.arrowCoordinates()));
        }
        return bb;
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        if (this.isSingular()) {
            return "% Singular DashArc, ignored!" + JaxoUtils.LINE_SEPARATOR;
        }
        if (this.isOneLine()) {
            JaxoSLine line = new JaxoSLine();
            line.setLocation(this.getX(), this.getY(), this.getX3(), this.getY3());
            line.setStrokeWidth(this.getStrokeWidth());
            line.setDash(this.getDash());
            line.setArrow(this.getArrow().copy());
            line.setArrowPosition(this.getArrowPosition());
            line.setPaintArrow(this.isPaintArrow());
            line.setFlip(this.isFlip());
            line.setDoubleLine(this.isDoubleLine());
            line.setDLSeparation(this.getDLSeparation());
            return line.latexCommand(scale, canvasDim);
        }
        double[] par = this.getArcParameters();
        double cx = par[0] / (double)scale;
        double cy = ((double)canvasDim.height - par[1]) / (double)scale;
        double r = par[2] / (double)scale;
        double sa = par[4];
        double ea = par[3] + par[4];
        boolean clockwise = par[3] < 0.0;
        String options = this.getOptionsCommand(scale, clockwise);
        return "\\Arc" + options + "(" + D_FORMAT.format(cx) + "," + D_FORMAT.format(cy) + ")" + "(" + D_FORMAT.format(r) + "," + D_FORMAT.format(sa) + "," + D_FORMAT.format(ea) + ")";
    }

    protected void resetStroke() {
        if (JaxoUtils.zero(this.getStrokeWidth()) || JaxoUtils.zero(this.getDash())) {
            return;
        }
        if (this.isSingular()) {
            return;
        }
        if (this.isOneLine()) {
            this.setStroke(new BasicStroke(this.getStrokeWidth(), 1, 0, 10.0f, this.strokeDashes(), 0.0f));
            this.innerStroke = new BasicStroke(this.getStrokeWidth(), 1, 0, 10.0f, this.strokeDashes(), 0.0f);
            this.outerStroke = new BasicStroke(this.getStrokeWidth(), 1, 0, 10.0f, this.strokeDashes(), 0.0f);
            return;
        }
        double radius = this.getRadius();
        if (JaxoUtils.zero(radius)) {
            radius = 1.0;
        }
        this.setStroke(new BasicStroke(this.getStrokeWidth(), 1, 0, 10.0f, this.strokeDashes(), 0.0f));
        this.innerStroke = new BasicStroke(this.getStrokeWidth(), 1, 0, 10.0f, this.innerStrokeDashes(radius), 0.0f);
        this.outerStroke = new BasicStroke(this.getStrokeWidth(), 1, 0, 10.0f, this.outerStrokeDashes(radius), 0.0f);
    }

    protected abstract float[] strokeDashes();

    protected abstract float[] innerStrokeDashes(double var1);

    protected abstract float[] outerStrokeDashes(double var1);

    private String getOptionsCommand(float scale, boolean clockwise) {
        float dashSize = this.getDash() / scale;
        StringBuffer optioncmd = new StringBuffer("dash,dashsize=").append(D_FORMAT.format(dashSize));
        if (this.isPaintArrow()) {
            float arpos = this.getArrowPosition();
            String arrowcmd = this.arrowCmnd(arpos, scale);
            optioncmd.append(',').append(arrowcmd);
            if (this.isDoubleLine()) {
                optioncmd.append(",double,sep=").append(D_FORMAT.format(this.getDLSeparation()));
            }
            if (clockwise) {
                optioncmd.append(",clock");
            }
        } else if (this.isDoubleLine()) {
            optioncmd.append(",double,sep=").append(D_FORMAT.format(this.getDLSeparation()));
            if (clockwise) {
                optioncmd.append(",clock");
            }
        } else if (clockwise) {
            optioncmd.append(",clock");
        }
        optioncmd.insert(0, '[').append(']');
        return optioncmd.toString();
    }

    private String arrowCmnd(float arpos, float scale) {
        StringBuffer arrowcmd = new StringBuffer(this.getArrow().latexCommand(arpos, scale));
        if (this.isFlip()) {
            arrowcmd.append(",flip");
        }
        return arrowcmd.toString();
    }
}

