/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.arrow;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.gui.panel.edit.JaxoEditPanel;
import net.sf.jaxodraw.object.arrow.AbstractBaseArrow;
import net.sf.jaxodraw.object.arrow.JaxoArrow;
import net.sf.jaxodraw.object.arrow.JaxoDefaultArrowEditPanel;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoDefaultArrow
extends AbstractBaseArrow {
    private static final long serialVersionUID = 314159L;
    private transient GeneralPath arrowPath = new GeneralPath(1, 5);
    private float latexLineWidth = 0.5f;
    private boolean isDoubleLine = false;
    private float dlSep = 2.0f;

    public JaxoDefaultArrow() {
        this.setColor(Color.BLACK);
        this.setFillColor(Color.BLACK);
        this.setFilled(true);
        this.setStroke(new BasicStroke(1.0f));
        this.setArrowLength(JaxoPrefs.getFloatPref("prefARROWLENGTH"));
        this.setArrowWidth(JaxoPrefs.getFloatPref("prefARROWWIDTH"));
        this.setArrowInset(JaxoPrefs.getFloatPref("prefARROWINSET"));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setStroke(new BasicStroke(1.0f));
        this.arrowPath = new GeneralPath(1, 5);
    }

    public void paint(Graphics2D g2, JaxoArrow.Coordinates coords) {
        this.resetPath(coords);
        g2.setStroke(this.getStroke());
        if (this.isFilled()) {
            g2.setColor(this.getFillColor());
            g2.fill(this.arrowPath);
        }
        g2.setColor(this.getColor());
        g2.draw(this.arrowPath);
    }

    public boolean isCopy(JaxoArrow testArrow) {
        if (testArrow instanceof JaxoDefaultArrow) {
            return super.isCopy(testArrow);
        }
        return false;
    }

    public String latexCommand(float arPos, float scale) {
        float arWidth = this.getArrowWidth();
        float arLength = this.getArrowLength();
        float arInset = this.getArrowInset();
        return "arrow,arrowpos=" + D_FORMAT.format(arPos) + ",arrowlength=" + D_FORMAT.format(arLength) + ",arrowwidth=" + D_FORMAT.format(arWidth) + ",arrowinset=" + D_FORMAT.format(arInset);
    }

    public Rectangle getBounds(JaxoArrow.Coordinates coords) {
        this.resetPath(coords);
        return this.getStroke().createStrokedShape(this.arrowPath).getBounds();
    }

    public JaxoEditPanel getEditPanel() {
        return new JaxoDefaultArrowEditPanel(this, true);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("color".equals(evt.getPropertyName())) {
            Color newColor = (Color)evt.getNewValue();
            this.setColor(newColor);
            this.setFillColor(newColor);
        } else if ("strokeWidth".equals(evt.getPropertyName())) {
            float old = ((Float)evt.getOldValue()).floatValue();
            this.latexLineWidth = ((Float)evt.getNewValue()).floatValue();
            if (JaxoUtils.zero(old)) {
                old = this.latexLineWidth;
            }
            float sep = this.sep();
            this.setArrowLength(this.len(sep, this.latexLineWidth) / this.len(sep, old) * this.getArrowLength());
            this.setArrowWidth(this.wid(sep, this.latexLineWidth) / this.wid(sep, old) * this.getArrowWidth());
        } else if ("doubleLine".equals(evt.getPropertyName())) {
            this.isDoubleLine = (Boolean)evt.getNewValue();
        } else if ("dlSeparation".equals(evt.getPropertyName())) {
            float old = ((Float)evt.getOldValue()).floatValue();
            this.dlSep = ((Float)evt.getNewValue()).floatValue();
            float sep = this.sep();
            if (JaxoUtils.zero(old)) {
                old = sep;
            }
            this.setArrowLength(this.len(sep, this.latexLineWidth) / this.len(old, this.latexLineWidth) * this.getArrowLength());
            this.setArrowWidth(this.wid(sep, this.latexLineWidth) / this.wid(old, this.latexLineWidth) * this.getArrowWidth());
        }
    }

    private void resetPath(JaxoArrow.Coordinates coords) {
        this.resetPath();
        AffineTransform at = new AffineTransform();
        at.translate(coords.getX(), coords.getY());
        at.rotate(coords.getAngle());
        this.arrowPath.transform(at);
    }

    private void resetPath() {
        this.arrowPath.reset();
        float arrowlength = this.getArrowLength();
        float arrowwidth = this.getArrowWidth();
        float arrowinset = this.getArrowInset() * arrowlength;
        this.arrowPath.moveTo(arrowlength / 2.0f, 0.0f);
        this.arrowPath.lineTo(-arrowlength / 2.0f, arrowwidth);
        this.arrowPath.lineTo(arrowinset - arrowlength / 2.0f, 0.0f);
        this.arrowPath.lineTo(-arrowlength / 2.0f, -arrowwidth);
        this.arrowPath.closePath();
    }

    private float wid(float sep, float stroke) {
        return 1.2f * (2.0f + 0.7f * sep + stroke);
    }

    private float len(float sep, float stroke) {
        return 2.5f * (2.0f + 0.7f * sep + stroke);
    }

    private float sep() {
        return this.isDoubleLine ? this.dlSep : 0.0f;
    }
}

