/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.loop;

import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.loop.JaxoLoopObject;

public class JaxoFLoop
extends JaxoLoopObject {
    private static final long serialVersionUID = 314159L;

    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoFLoop) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        int r = (int)Math.round(this.getRadius());
        editPanel.addXYRPanel(this.getX(), this.getY(), r, 0, 0);
        editPanel.addArrowPanel(this.isPaintArrow(), this.isFlip(), this.getArrowPosition(), 1, 0);
        editPanel.addArrowOptionsEditPanel(this.getArrow(), 2, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addDoubleLinePanel(this.isDoubleLine(), this.getDLSeparation(), 1, 1);
        editPanel.addColorPanel(this.getColor(), 2, 2, 1);
        editPanel.setTitleAndIcon("Fermion_loop_parameters", "floop.png");
    }

    protected GeneralPath getObjectPath() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        double length = this.getRadius();
        float dlsep = this.getDLSeparation() / 2.0f;
        Ellipse2D.Double loop = new Ellipse2D.Double();
        if (this.isDoubleLine()) {
            ((RectangularShape)loop).setFrame(-length - (double)dlsep + (double)this.getX(), -length - (double)dlsep + (double)this.getY(), 2.0 * (length + (double)dlsep), 2.0 * (length + (double)dlsep));
            gp.append(loop, false);
            ((RectangularShape)loop).setFrame(-length + (double)dlsep + (double)this.getX(), -length + (double)dlsep + (double)this.getY(), 2.0 * (length - (double)dlsep), 2.0 * (length - (double)dlsep));
            gp.append(loop, false);
        } else {
            ((RectangularShape)loop).setFrame(-length + (double)this.getX(), -length + (double)this.getY(), 2.0 * length, 2.0 * length);
            gp.append(loop, false);
        }
        return gp;
    }

    protected String getAxo4JOptions(float scale) {
        StringBuffer optioncmd = new StringBuffer(128);
        if (this.isPaintArrow()) {
            float arpos = this.getArrowPosition();
            optioncmd.append(this.getArrow().latexCommand(arpos, scale));
            if (this.isFlip()) {
                optioncmd.append(",flip");
            }
            if (this.isDoubleLine()) {
                optioncmd.append(",double,sep=").append(D_FORMAT.format(this.getDLSeparation()));
            }
            optioncmd.insert(0, '[').append(']');
        } else if (this.isDoubleLine()) {
            optioncmd.append("[double,sep=").append(D_FORMAT.format(this.getDLSeparation())).append(']');
        }
        return optioncmd.toString();
    }
}

