/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.text;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.text.JaxoTextObject;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoLatexText
extends JaxoTextObject {
    private static final long serialVersionUID = 314159L;
    public static final int ALIGN_LT = 0;
    public static final int ALIGN_LC = 1;
    public static final int ALIGN_LB = 2;
    public static final int ALIGN_CT = 3;
    public static final int ALIGN_CC = 4;
    public static final int ALIGN_CB = 5;
    public static final int ALIGN_RT = 6;
    public static final int ALIGN_RC = 7;
    public static final int ALIGN_RB = 8;
    public static final int TINY = 0;
    public static final int SCRIPTSIZE = 1;
    public static final int FOOTNOTESIZE = 2;
    public static final int SMALL = 3;
    public static final int NORMALSIZE = 4;
    public static final int LARGE = 5;
    public static final int XLARGE = 6;
    public static final int XXLARGE = 7;
    public static final int HUGE = 8;
    public static final int XHUGE = 9;
    private static final String[] ALIGNS = new String[]{"[lt]", "[l]", "[lb]", "[t]", "[]", "[b]", "[rt]", "[r]", "[rb]"};
    private static final String[] SIZES = new String[]{"{\\tiny{", "{\\scriptsize{", "{\\footnotesize{", "{\\small{", "{\\normalsize{", "{\\large{", "{\\Large{", "{\\LARGE{", "{\\huge{", "{\\Huge{"};
    private int allign;
    private int latexTextSize;

    public final int getAllign() {
        return this.allign;
    }

    public final void setAllign(int newAllign) {
        try {
            this.getLaTexAllign(newAllign);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid Latex text align!", e);
        }
        Integer old = this.allign;
        this.allign = newAllign;
        this.firePropertyChange("allign", old, this.allign);
    }

    public final int getLatexTextSize() {
        return this.latexTextSize;
    }

    public final void setLatexTextSize(int newLatexfs) {
        try {
            this.getLatexTextSize();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid Latex text size!", e);
        }
        Integer old = this.latexTextSize;
        this.latexTextSize = newLatexfs;
        this.firePropertyChange("latexTextSize", old, this.latexTextSize);
    }

    public boolean isCopy(JaxoObject comp) {
        JaxoLatexText tmp;
        boolean isCopy = false;
        if (comp instanceof JaxoLatexText && (tmp = (JaxoLatexText)comp).getAllign() == this.getAllign() && tmp.getLatexTextSize() == this.getLatexTextSize() && super.isCopy(tmp)) {
            isCopy = true;
        }
        return isCopy;
    }

    public void copyFrom(JaxoLatexText temp) {
        super.copyFrom(temp);
        this.setAllign(temp.getAllign());
        this.setLatexTextSize(temp.getLatexTextSize());
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoLatexText)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoLatexText)o);
    }

    public final void paint(JaxoGraphics2D g2) {
        if (!g2.isPrinting()) {
            this.paintTexVisualAid(g2);
        }
    }

    private void paintTexVisualAid(JaxoGraphics2D g2) {
        int x = this.getX();
        int y = this.getY();
        double theta = Math.toRadians(this.getRotationAngle());
        char[] ltT = new char[]{'T'};
        char[] ltE = new char[]{'E'};
        char[] ltX = new char[]{'X'};
        Font ltTFont = new Font("Utopia", 0, 18);
        Font ltEFont = new Font("Utopia", 0, 14);
        Font ltXFont = ltTFont;
        g2.rotate(theta, x, y);
        int xOff = 5;
        int yOff = 16;
        if (this.allign == 3 || this.allign == 4 || this.allign == 5) {
            xOff = -13;
        } else if (this.allign == 6 || this.allign == 7 || this.allign == 8) {
            xOff = -31;
        }
        if (this.allign == 1 || this.allign == 4 || this.allign == 7) {
            yOff = 5;
        } else if (this.allign == 2 || this.allign == 5 || this.allign == 8) {
            yOff = -6;
        }
        g2.setColor(JaxoColor.GRAYSCALE180);
        g2.setFont(ltTFont);
        g2.drawChars(ltT, 0, ltT.length, x + xOff, y + yOff);
        g2.setFont(ltEFont);
        g2.drawChars(ltE, 0, ltE.length, x + xOff + 9, y + yOff + 2);
        g2.setFont(ltXFont);
        g2.drawChars(ltX, 0, ltX.length, x + xOff + 17, y + yOff);
        g2.setColor(JaxoColor.CADET_BLUE);
        g2.setFont(ltTFont);
        g2.drawChars(ltT, 0, ltT.length, x + xOff - 1, y + yOff - 1);
        g2.setFont(ltEFont);
        g2.drawChars(ltE, 0, ltE.length, x + xOff + 8, y + yOff + 1);
        g2.setFont(ltXFont);
        g2.drawChars(ltX, 0, ltX.length, x + xOff + 18, y + yOff - 1);
        g2.rotate(-theta, x, y);
    }

    public final boolean isRolledOver(int mouseX, int mouseY) {
        return this.getBounds().contains(mouseX, mouseY);
    }

    public Rectangle getBounds() {
        Rectangle bBox = new Rectangle();
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        int x = this.getX();
        int y = this.getY();
        int xOff = 3;
        int yOff = 1;
        if (this.allign == 3 || this.allign == 4 || this.allign == 5) {
            xOff = -15;
        } else if (this.allign == 6 || this.allign == 7 || this.allign == 8) {
            xOff = -33;
        }
        if (this.allign == 1 || this.allign == 4 || this.allign == 7) {
            yOff = -10;
        } else if (this.allign == 2 || this.allign == 5 || this.allign == 8) {
            yOff = -21;
        }
        bBox.setLocation(x + xOff, y + yOff);
        bBox.setSize(32, 16);
        gp.append(bBox, false);
        if (this.getRotationAngle() != 0) {
            AffineTransform at = new AffineTransform();
            at.rotate(Math.toRadians(this.getRotationAngle()), x, y);
            gp.transform(at);
        }
        return gp.getBounds();
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        Point2D position = this.getLaTexPosition(scale, canvasDim.height);
        String allignCode = this.getLaTexAllign(this.allign);
        String rputAllign = allignCode;
        if ("[]".equals(rputAllign)) {
            rputAllign = "";
        }
        String fontSize = this.getLaTexFontSize(this.latexTextSize);
        String color = JaxoColor.isGrayScale(this.getColor()) ? "\\Gray" : "\\" + JaxoColor.getColorName(this.getColor());
        if (this.getRotationAngle() == 0) {
            return "\\Text(" + D_FORMAT.format(position.getX()) + "," + D_FORMAT.format(position.getY()) + ")" + allignCode + fontSize + color + "{$" + this.getTextString() + "$}}}";
        }
        int ang = -this.getRotationAngle();
        return "\\Text(" + D_FORMAT.format(position.getX()) + "," + D_FORMAT.format(position.getY()) + ")" + allignCode + fontSize + color + "{$" + "\\rput" + rputAllign + "{" + ang + "}" + "{" + this.getTextString() + "}" + "$}}}";
    }

    public void setPreferences() {
        super.setPreferences();
        this.setRotationAngle(JaxoPrefs.getIntPref("prefTEXROTANGLE"));
        this.setColor(JaxoColor.getColor(JaxoPrefs.getStringPref("prefTEXTCOLOR"), 0));
        this.setTextString("");
        this.setAllign(JaxoPrefs.getIntPref("prefTEXALIGN"));
        this.setLatexTextSize(JaxoPrefs.getIntPref("prefTEXSIZE"));
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        editPanel.addPositionPanel(this.getX(), this.getY(), 0, 0);
        editPanel.addRotationPanel(this.getRotationAngle(), 1, 0);
        editPanel.addColorPanel(this.getColor(), 2, 2, 0);
        editPanel.addTextPanel(this.getTextString(), 0, 1);
        editPanel.addLatexFontSizePanel(this.getLatexTextSize(), 1, 1);
        editPanel.addLatexAlignPanel(this.getAllign(), 2, 1);
        editPanel.setTitleAndIcon("LaTeX_text_parameters", "latex.png");
    }

    private Point2D getLaTexPosition(float scaleFactor, int canvasHeight) {
        return new Point2D.Float((float)this.getX() / scaleFactor, (float)(canvasHeight - this.getY()) / scaleFactor);
    }

    private String getLaTexAllign(int all) {
        return ALIGNS[all];
    }

    private String getLaTexFontSize(int fs) {
        return SIZES[fs];
    }
}

