/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.text;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.text.JaxoTextObject;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoGeometry;
import net.sf.jaxodraw.util.JaxoGreek;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxoPSText
extends JaxoTextObject {
    private static final long serialVersionUID = 314159L;
    private static final List<Integer> FONT_SIZES;
    private static final List<Integer> FONT_STYLES;
    private static final String LATEX_COMMAND = "% There is a postscript text here!";
    private Font textFont;
    private transient List<Element> elements;
    private transient Rectangle boundingBox;

    public static List<Integer> getFontSizeDefaults() {
        return FONT_SIZES;
    }

    public static List<Integer> getFontStyles() {
        return FONT_STYLES;
    }

    public final Font getFont() {
        return this.textFont;
    }

    public final void setFont(Font font) {
        Font old = this.textFont;
        this.textFont = font;
        this.firePropertyChange("font", old, this.textFont);
        this.elements = null;
    }

    @Override
    public void setTextString(String string) {
        super.setTextString(string);
        this.elements = null;
    }

    public final void setFontName(String name) {
        this.setFont(new Font(name, this.getFont().getStyle(), this.getFont().getSize()));
    }

    public final void setFontStyle(int style) {
        this.setFont(new Font(this.getFont().getName(), style, this.getFont().getSize()));
    }

    public final void setFontSize(int size) {
        this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), size));
    }

    @Override
    public final JaxoObject copy() {
        JaxoPSText result = (JaxoPSText)super.copy();
        if (this.elements != null) {
            result.elements = new ArrayList<Element>(this.elements);
        }
        return result;
    }

    public void copyFrom(JaxoPSText temp) {
        super.copyFrom(temp);
        Font font = temp.getFont();
        this.setFont(new Font(font.getName(), font.getStyle(), font.getSize()));
    }

    @Override
    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoPSText)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoPSText)o);
    }

    @Override
    public final boolean isCopy(JaxoObject comp) {
        JaxoPSText text;
        boolean isCopy = false;
        if (comp instanceof JaxoPSText && (text = (JaxoPSText)comp).getFont().equals(this.getFont()) && super.isCopy(text)) {
            isCopy = true;
        }
        return isCopy;
    }

    @Override
    public final void paint(JaxoGraphics2D g2) {
        this.ensureParsed();
        g2.setColor(this.getColor());
        double theta = Math.toRadians(this.getRotationAngle());
        double x = this.getX();
        double y = this.getY();
        g2.rotate(theta, x, y);
        for (Element t : this.elements) {
            g2.setFont(t.getFont());
            g2.drawString(t.getText(), (float)((double)this.getX() + t.getX()), (float)((double)this.getY() + t.getY()));
        }
        g2.rotate(-theta, x, y);
    }

    @Override
    public Rectangle getBounds() {
        this.ensureParsed();
        double theta = Math.toRadians(this.getRotationAngle());
        if (theta == 0.0) {
            Rectangle result = this.boundingBox.getBounds();
            result.x += this.getX();
            result.y += this.getY();
            return result;
        }
        GeneralPath gp = new GeneralPath(this.boundingBox);
        AffineTransform at = AffineTransform.getRotateInstance(theta);
        gp.transform(at);
        gp.transform(AffineTransform.getTranslateInstance(this.getX(), this.getY()));
        return gp.getBounds();
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        return LATEX_COMMAND;
    }

    @Override
    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        editPanel.addPositionPanel(this.getX(), this.getY(), 0, 0);
        editPanel.addRotationPanel(this.getRotationAngle(), 1, 0);
        editPanel.addPSFontPanel(this.getFont(), 0, 1, 2);
        editPanel.addColorPanel(this.getColor(), 1, 0, 2);
        editPanel.addTextPanel(this.getTextString(), 1, 2);
        editPanel.setTitleAndIcon("Text_parameters", "font_truetype.png");
    }

    @Override
    public final void rescaleObject(int orx, int ory, float scale) {
        super.rescaleObject(orx, ory, scale);
        float textSize = this.textFont.getSize2D();
        float rescaledTextSize = textSize * scale;
        if (rescaledTextSize < 2.0f) {
            rescaledTextSize = 2.0f;
        } else if (rescaledTextSize > 286.0f) {
            rescaledTextSize = 286.0f;
        }
        this.setFont(this.textFont.deriveFont(rescaledTextSize));
    }

    @Override
    public void setPreferences() {
        super.setPreferences();
        this.setRotationAngle(JaxoPrefs.getIntPref("prefPSROTANGLE"));
        this.setColor(JaxoColor.getColor(JaxoPrefs.getStringPref("prefTEXTCOLOR"), JaxoPrefs.getIntPref("prefCOLORSPACE")));
        this.setFont(new Font(JaxoPrefs.getStringPref("prefPSFAMILY"), JaxoPrefs.getIntPref("prefPSSTYLE"), JaxoPrefs.getIntPref("prefPSSIZE")));
        this.setTextString("");
    }

    private void ensureParsed() {
        if (this.elements == null) {
            new Parser().parse(this.getTextString());
        }
    }

    static {
        ArrayList<Integer> fSizes = new ArrayList<Integer>(16);
        fSizes.add(6);
        fSizes.add(8);
        fSizes.add(10);
        fSizes.add(12);
        fSizes.add(14);
        fSizes.add(18);
        fSizes.add(24);
        fSizes.add(36);
        fSizes.add(48);
        fSizes.add(60);
        fSizes.add(72);
        FONT_SIZES = Collections.unmodifiableList(fSizes);
        ArrayList<Integer> fStyles = new ArrayList<Integer>(4);
        fStyles.add(0);
        fStyles.add(1);
        fStyles.add(2);
        fStyles.add(3);
        FONT_STYLES = Collections.unmodifiableList(fStyles);
    }

    private class Parser {
        private FontRenderContext renderContext;
        private double height;
        private double x;
        private Rectangle2D bounds;
        private Element element;
        private int level;

        private Parser() {
        }

        public void parse(String text) {
            this.renderContext = new FontRenderContext(new AffineTransform(), true, true);
            this.height = JaxoPSText.this.getFont().getLineMetrics("A", this.renderContext).getHeight();
            this.x = 0.0;
            this.level = 0;
            this.bounds = new Rectangle2D.Double();
            String textString = text;
            if (textString == null) {
                textString = "";
            }
            JaxoPSText.this.elements = new ArrayList(8);
            this.element = new Element(this.x, 0.0);
            StringBuffer elementText = new StringBuffer(64);
            block7: for (int i = 0; i < textString.length(); ++i) {
                char ch = textString.charAt(i);
                boolean last = i == textString.length() - 1;
                switch (ch) {
                    case '_': {
                        if (last || textString.charAt(i + 1) != '{') {
                            elementText.append(ch);
                            continue block7;
                        }
                        this.finishElement(elementText.toString());
                        ++this.level;
                        this.element.setY(this.element.getY() + 0.5 * Math.pow(0.6666666666666666, this.level) * this.height);
                        continue block7;
                    }
                    case '^': {
                        if (last || textString.charAt(i + 1) != '{') {
                            elementText.append(ch);
                            continue block7;
                        }
                        this.finishElement(elementText.toString());
                        ++this.level;
                        this.element.setY(this.element.getY() - 0.5 * Math.pow(0.6666666666666666, this.level) * this.height);
                        continue block7;
                    }
                    case '\\': {
                        char t;
                        int k;
                        if (last) {
                            elementText.append(ch);
                            continue block7;
                        }
                        char d = textString.charAt(i + 1);
                        if (d == '{' || d == '}' || d == '\\' || d == '_' || d == '^') {
                            elementText.append(d);
                            ++i;
                            continue block7;
                        }
                        for (k = i + 1; k < textString.length() && ((t = textString.charAt(k)) >= 'a' && t <= 'z' || t >= 'A' && t <= 'Z'); ++k) {
                        }
                        if (k <= i + 1) continue block7;
                        elementText.append(JaxoGreek.getCharacter(textString.substring(i, k)));
                        i = k - 1;
                        continue block7;
                    }
                    case '{': {
                        if (last || textString.charAt(i + 1) != '}') continue block7;
                        ++i;
                        continue block7;
                    }
                    case '}': {
                        if (this.level <= 0) continue block7;
                        double y = this.element.getPreviousY();
                        this.finishElement(elementText.toString());
                        this.element.setY(y);
                        --this.level;
                        continue block7;
                    }
                    default: {
                        elementText.append(ch);
                    }
                }
            }
            this.finishElement(elementText.toString());
            JaxoPSText.this.boundingBox = this.bounds.getBounds();
            JaxoPSText.this.boundingBox.grow(2, 2);
        }

        private void finishElement(String elementText) {
            if (elementText.length() > 0) {
                this.element.setText(elementText);
                this.element.setFont(JaxoPSText.this.getFont().deriveFont((float)((double)JaxoPSText.this.getFont().getSize2D() * Math.pow(0.6666666666666666, this.level))));
                JaxoPSText.this.elements.add(this.element);
                TextLayout l = new TextLayout(this.element.getText(), this.element.getFont(), this.renderContext);
                Rectangle2D.Double r = new Rectangle2D.Double();
                r.setRect(l.getBounds());
                r.x += this.element.getX();
                r.y += this.element.getY();
                JaxoGeometry.add(this.bounds, r);
                this.x += (double)l.getAdvance();
            }
            this.element = new Element(this.x, this.element.getY());
        }
    }

    private static class Element {
        private Font font;
        private String text;
        private double x;
        private double y;
        private final double previousY;

        Element(double newx, double newy) {
            this.x = newx;
            this.y = newy;
            this.previousY = newy;
        }

        public Font getFont() {
            return this.font;
        }

        public void setFont(Font newFont) {
            this.font = newFont;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String newText) {
            this.text = newText;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double newX) {
            this.x = newX;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double newY) {
            this.y = newY;
        }

        public double getPreviousY() {
            return this.previousY;
        }
    }
}

