/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.util;

public final class JaxoGreek {
    public static final char ALPHA = '\u03b1';
    public static final char BETA = '\u03b2';
    public static final char GAMMA = '\u03b3';
    public static final char DELTA = '\u03b4';
    public static final char EPSILON = '\u03b5';
    public static final char ZETA = '\u03b6';
    public static final char ETA = '\u03b7';
    public static final char THETA = '\u03b8';
    public static final char IOTA = '\u03b9';
    public static final char KAPPA = '\u03ba';
    public static final char LAMBDA = '\u03bb';
    public static final char MU = '\u03bc';
    public static final char NU = '\u03bd';
    public static final char XI = '\u03be';
    public static final char OMIKRON = '\u03bf';
    public static final char PI = '\u03c0';
    public static final char RHO = '\u03c1';
    public static final char VARSIGMA = '\u03c2';
    public static final char SIGMA = '\u03c3';
    public static final char TAU = '\u03c4';
    public static final char UPSILON = '\u03c5';
    public static final char PHI = '\u03c6';
    public static final char CHI = '\u03c7';
    public static final char PSI = '\u03c8';
    public static final char OMEGA = '\u03c9';
    public static final char VARTHETA = '\u03d1';
    public static final char VARPHI = '\u03d5';
    public static final char UPPER_GAMMA = '\u0393';
    public static final char UPPER_DELTA = '\u0394';
    public static final char UPPER_THETA = '\u0398';
    public static final char UPPER_LAMBDA = '\u039b';
    public static final char UPPER_XI = '\u039e';
    public static final char UPPER_PI = '\u03a0';
    public static final char UPPER_SIGMA = '\u03a3';
    public static final char UPPER_PHI = '\u03a6';
    public static final char UPPER_PSI = '\u03a8';
    public static final char UPPER_OMEGA = '\u03a9';
    private static final char[] GREEK_CHARS = new char[]{'\u03b1', '\u03b2', '\u03b3', '\u03b4', '\u03b5', '\u03b6', '\u03b7', '\u03b8', '\u03b9', '\u03ba', '\u03bb', '\u03bc', '\u03bd', '\u03be', '\u03bf', '\u03c0', '\u03c1', '\u03c2', '\u03c3', '\u03c4', '\u03c5', '\u03c6', '\u03c7', '\u03c8', '\u03c9', '\u03d1', '\u03d5', '\u0393', '\u0394', '\u0398', '\u039b', '\u039e', '\u03a0', '\u03a3', '\u03a6', '\u03a8', '\u03a9'};
    private static final int NOF_GREEK_CHARS = GREEK_CHARS.length;
    private static final String[] LATEX_COMMANDS = new String[]{"\\alpha", "\\beta", "\\gamma", "\\delta", "\\epsilon", "\\zeta", "\\eta", "\\theta", "\\iota", "\\kappa", "\\lambda", "\\mu", "\\nu", "\\xi", "o", "\\pi", "\\rho", "\\varsigma", "\\sigma", "\\tau", "\\upsilon", "\\phi", "\\chi", "\\psi", "\\omega", "\\vartheta", "\\varphi", "\\Gamma", "\\Delta", "\\Theta", "\\Lambda", "\\Xi", "\\Pi", "\\Sigma", "\\Phi", "\\Psi", "\\Omega"};

    private JaxoGreek() {
    }

    public static String getLatexCommand(char a) {
        int i = JaxoGreek.getIndex(a);
        return i < NOF_GREEK_CHARS ? LATEX_COMMANDS[i] : null;
    }

    public static char getCharacter(String command) {
        int i = JaxoGreek.getIndex(command);
        return i < NOF_GREEK_CHARS ? GREEK_CHARS[i] : (char)'\u0000';
    }

    public static boolean isGreekCharacter(char a) {
        return JaxoGreek.getIndex(a) < NOF_GREEK_CHARS;
    }

    public static boolean isLatexCommand(String command) {
        return JaxoGreek.getIndex(command) < NOF_GREEK_CHARS;
    }

    private static int getIndex(char a) {
        for (int i = 0; i < NOF_GREEK_CHARS; ++i) {
            if (GREEK_CHARS[i] != a) continue;
            return i;
        }
        return NOF_GREEK_CHARS;
    }

    private static int getIndex(String s) {
        for (int i = 0; i < NOF_GREEK_CHARS; ++i) {
            if (!LATEX_COMMANDS[i].equals(s)) continue;
            return i;
        }
        return NOF_GREEK_CHARS;
    }
}

