/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.util;

import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLog;

public final class JaxoInfo {
    public static final String USER_NAME = System.getProperty("user.name");
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
    public static final String JAVA_HOME = System.getProperty("java.home");
    public static final String JAVA_CLASSPATH = System.getProperty("java.class.path");
    public static final Dimension SCREEN_SIZE;
    private static final String EOL;
    public static final String VERSION_NUMBER;
    public static final String VERSION;
    public static final String WEB_SITE = "http://jaxodraw.sourceforge.net/";
    public static final String EXTENSION = "xml";
    public static final String DOT_EXTENSION = ".xml";
    public static final String SETTINGS_DIR;
    public static final String PLUGIN_DIR;
    public static final String LOG_DIR;

    private JaxoInfo() {
    }

    public static String help() {
        return JaxoLanguage.translate("Start_the_program_with:") + JaxoLanguage.translate("jaxodraw_[options]") + JaxoLanguage.translate("and_check_the_User_Guide_in_the_Help_menu.") + JaxoLanguage.translate("Command_line_options:") + JaxoLanguage.translate("--version__prints_out_the_version_number_of_JaxoDraw") + JaxoLanguage.translate("--help_____prints_out_this_help") + JaxoLanguage.translate("--info_____prints_out_some_information_about_your_system") + "--convert  converts JaxoDraw xml files to/from tex (axodraw4j) files" + EOL + " -nosplash No splash window on startup" + EOL + JaxoLanguage.translate("_-verbose__turns_on_verbose_error_messaging_(default_in_the_current_version)") + JaxoLanguage.translate("_-quiet____turns_off_verbose_error_messaging");
    }

    public static String info() {
        return JaxoLanguage.translate("OS_name:") + OS_NAME + EOL + JaxoLanguage.translate("OS_architecture:") + OS_ARCH + EOL + JaxoLanguage.translate("OS_version:") + OS_VERSION + EOL + JaxoLanguage.translate("Java_version:") + JAVA_VERSION + EOL + JaxoLanguage.translate("Java_runtime_version:") + JAVA_RUNTIME_VERSION + EOL + JaxoLanguage.translate("Java_home_directory:") + JAVA_HOME + EOL + JaxoLanguage.translate("Java_class_path:") + JAVA_CLASSPATH;
    }

    public static String sysInfo() {
        String message = JaxoLanguage.translate("User_name:") + USER_NAME + EOL + JaxoLanguage.translate("User_home:") + USER_HOME + EOL + JaxoLanguage.translate("OS_name:") + OS_NAME + EOL + JaxoLanguage.translate("OS_architecture:") + OS_ARCH + EOL + JaxoLanguage.translate("OS_version:") + OS_VERSION + EOL + JaxoLanguage.translate("Java_version:") + JAVA_VERSION + EOL + JaxoLanguage.translate("Java_runtime_version:") + JAVA_RUNTIME_VERSION + EOL + JaxoLanguage.translate("Java_home_directory:") + JAVA_HOME + EOL + JaxoLanguage.translate("Java_class_path:") + JAVA_CLASSPATH;
        return message;
    }

    public static String about(String plugins) {
        String message = JaxoLanguage.translate("JaxoDraw:_Feynman_diagrams_with_JAVA") + EOL + JaxoLanguage.translate("Version") + ": " + VERSION_NUMBER + EOL + (plugins == null ? "" : JaxoLanguage.translate("Available_plugins") + ": " + plugins + EOL) + EOL + JaxoLanguage.translate("JaxoDraw_homepage") + ": " + WEB_SITE + EOL;
        return message;
    }

    public static int compareVersion(String version) {
        if (version == null) {
            return 1;
        }
        return JaxoInfo.compareVersions(VERSION_NUMBER, version);
    }

    public static int compareVersions(String v1, String v2) {
        if (v1.equals(v2)) {
            return 0;
        }
        int major = JaxoInfo.getMajor(v1) - JaxoInfo.getMajor(v2);
        if (major != 0) {
            return major;
        }
        int minor = JaxoInfo.getMinor(v1) - JaxoInfo.getMinor(v2);
        if (minor != 0) {
            return minor;
        }
        int bugfix = JaxoInfo.getBugfix(v1) - JaxoInfo.getBugfix(v2);
        if (bugfix != 0) {
            return bugfix;
        }
        String q1 = JaxoInfo.getQualifier(v1);
        String q2 = JaxoInfo.getQualifier(v2);
        int l1 = q1.length();
        int l2 = q2.length();
        if (l1 == 0 && l2 != 0) {
            return l2;
        }
        if (l1 != 0 && l2 == 0) {
            return -l1;
        }
        int qualifier = q1.compareTo(q2);
        if (qualifier != 0) {
            return qualifier;
        }
        return 0;
    }

    private static int getMajor(String v) {
        return Integer.parseInt(v.substring(0, v.indexOf(46)));
    }

    private static int getMinor(String v) {
        int one = v.indexOf(46);
        int two = v.indexOf(46, one + 1);
        if (two == -1) {
            int dash = v.indexOf(45);
            if (dash == -1) {
                return Integer.parseInt(v.substring(one + 1));
            }
            return Integer.parseInt(v.substring(one + 1, dash));
        }
        return Integer.parseInt(v.substring(one + 1, two));
    }

    private static int getBugfix(String v) {
        int one = v.indexOf(46);
        int two = v.indexOf(46, one + 1);
        if (two == -1) {
            return 0;
        }
        int dash = v.indexOf(45);
        if (dash == -1) {
            return Integer.parseInt(v.substring(two + 1));
        }
        return Integer.parseInt(v.substring(two + 1, dash));
    }

    private static String getQualifier(String v) {
        int dash = v.indexOf(45);
        if (dash == -1) {
            return "";
        }
        return v.substring(dash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        EOL = System.getProperty("line.separator");
        SCREEN_SIZE = new Dimension(800, 600);
        try {
            SCREEN_SIZE.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        }
        catch (HeadlessException e) {
            JaxoLog.debug("Running headless...");
        }
        Properties props = new Properties();
        InputStream is = JaxoInfo.class.getResourceAsStream("/resources/properties/build-info.properties");
        if (is == null) {
            props.setProperty("version", "unknown");
        } else {
            try {
                props.load(is);
            }
            catch (IOException ex) {
                JaxoLog.debug("No version info found!", ex);
                props.setProperty("version", "unknown");
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    JaxoLog.debug(ex);
                }
            }
        }
        VERSION_NUMBER = props.getProperty("version");
        VERSION = "JaxoDraw-" + VERSION_NUMBER;
        SETTINGS_DIR = USER_HOME + "/.jaxodraw/" + VERSION_NUMBER + "/";
        PLUGIN_DIR = SETTINGS_DIR + "plugins/";
        LOG_DIR = SETTINGS_DIR + "log/";
    }
}

